/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ApplicationException;
import com.google.common.annotations.VisibleForTesting;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextAwareTrustAllManager
implements X509TrustManager,
HostnameVerifier {
    private static final Logger logger = LoggerFactory.getLogger(ContextAwareTrustAllManager.class);
    @Nullable
    private static ContextAwareTrustAllManager instance = null;
    @VisibleForTesting
    static final X509TrustManager DEFAULT_TRUST_MANAGER = ContextAwareTrustAllManager.getDefaultTrustManager();
    @VisibleForTesting
    static final HostnameVerifier DEFAULT_HOSTNAME_VERIFIER = HttpsURLConnection.getDefaultHostnameVerifier();
    private final Set<String> packagesAndClasses = ConcurrentHashMap.newKeySet();

    @Deprecated
    public static synchronized ContextAwareTrustAllManager getInstance() {
        if (null == instance) {
            instance = new ContextAwareTrustAllManager();
        } else if (!ContextAwareTrustAllManager.instance.packagesAndClasses.isEmpty()) {
            ContextAwareTrustAllManager.instance.packagesAndClasses.clear();
            logger.debug("Extending customized SSL error handling to be applied globally to all connections");
        }
        return instance;
    }

    public static synchronized ContextAwareTrustAllManager getInstance(String packageOrClass, String ... morePackagesAndClasses) {
        if (null == instance) {
            instance = new ContextAwareTrustAllManager(packageOrClass, morePackagesAndClasses);
        } else {
            instance.add(false, packageOrClass, morePackagesAndClasses);
        }
        return instance;
    }

    private ContextAwareTrustAllManager() {
        logger.debug("Customizing SSL error handling globally for all connections");
    }

    private ContextAwareTrustAllManager(String packageOrClass, String ... morePackagesAndClasses) {
        this.add(true, packageOrClass, morePackagesAndClasses);
    }

    private void add(boolean forceScopedMode, String packageOrClass, String ... morePackagesAndClasses) {
        if (forceScopedMode || !this.packagesAndClasses.isEmpty()) {
            Set allPackagesAndClasses = Stream.concat(Stream.of(packageOrClass), Arrays.stream(morePackagesAndClasses)).filter(item -> !item.isEmpty()).collect(Collectors.toSet());
            this.packagesAndClasses.addAll(allPackagesAndClasses);
            logger.debug("Customizing SSL error handling for {}", (Object)String.join((CharSequence)", ", allPackagesAndClasses));
        }
    }

    void inject(SSLContext sslContext) throws KeyManagementException {
        sslContext.init(null, new X509TrustManager[]{this}, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(this);
    }

    @VisibleForTesting
    static synchronized void resetForTesting() {
        if (null == instance) {
            instance = new ContextAwareTrustAllManager();
        }
        ContextAwareTrustAllManager.instance.packagesAndClasses.clear();
        ContextAwareTrustAllManager.instance.packagesAndClasses.add("dummy entry so that the instance is reset to scoped mode");
    }

    @VisibleForTesting
    boolean requiresValidation() {
        if (this.packagesAndClasses.isEmpty()) {
            return false;
        }
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> stream.allMatch(this::requiresValidation));
    }

    private boolean requiresValidation(StackWalker.StackFrame stackFrame) {
        return this.packagesAndClasses.stream().noneMatch(name -> stackFrame.getClassName().startsWith((String)name));
    }

    private static X509TrustManager getDefaultTrustManager() {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            for (TrustManager trustManager : trustManagerFactory.getTrustManagers()) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return (X509TrustManager)trustManager;
            }
        }
        catch (Exception exception) {
            throw new ApplicationException(exception.getMessage(), exception);
        }
        throw new ApplicationException("Failed to load the default X509TrustManager");
    }

    @Override
    @Nullable
    public X509Certificate[] getAcceptedIssuers() {
        return this.requiresValidation() ? DEFAULT_TRUST_MANAGER.getAcceptedIssuers() : new X509Certificate[]{};
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.requiresValidation()) {
            DEFAULT_TRUST_MANAGER.checkClientTrusted(chain, authType);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        if (this.requiresValidation()) {
            DEFAULT_TRUST_MANAGER.checkServerTrusted(chain, authType);
        }
    }

    @Override
    public boolean verify(String hostname, SSLSession session) {
        return !this.requiresValidation() || DEFAULT_HOSTNAME_VERIFIER.verify(hostname, session);
    }
}

