/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.io.IOUtils;
import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class PropertiesUtils {
    private static final Charset ENCODING = Charsets.UTF_8;
    private static final String LINE_SEPARATOR = System.lineSeparator();

    private PropertiesUtils() {
    }

    public static void saveUpdatedProperties(String existingFilename, Properties props) throws IOException {
        PropertiesUtils.saveUpdatedProperties(existingFilename, props, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveUpdatedProperties(String existingFilename, Properties props, List<String> comments) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            PropertiesUtils.storeProperties(props, baos, null);
        }
        finally {
            IOUtils.closeQuietly(baos);
        }
        HashMap<String, String> encodedValues = new HashMap<String, String>(props.size());
        try (BufferedReader reader = new BufferedReader(PropertiesUtils.createReader(new ByteArrayInputStream(baos.toByteArray())));){
            String line;
            while ((line = reader.readLine()) != null) {
                int equalsIndex;
                if (line.startsWith("#") || (equalsIndex = line.indexOf(61)) < 0) continue;
                String key = line.substring(0, equalsIndex);
                String string = line.substring(equalsIndex + 1);
                encodedValues.put(key, string);
            }
        }
        File existingFile = new File(existingFilename);
        ArrayList<String> existingLines = new ArrayList<String>(props.size() * 2);
        existingLines.addAll(PropertiesUtils.readLines(existingFile));
        try (PrintWriter writer = new PrintWriter(PropertiesUtils.createFileWriter(existingFile));){
            for (String string : existingLines) {
                if (string.startsWith("#") || StringUtils.isBlank((String)string)) {
                    writer.println(string);
                    continue;
                }
                int equalsIndex = string.indexOf(61);
                if (equalsIndex < 0) {
                    writer.println(string);
                    continue;
                }
                String key = string.substring(0, equalsIndex);
                String newValue = (String)encodedValues.get(key);
                if (newValue == null) {
                    writer.println(string);
                    continue;
                }
                writer.print(key);
                writer.print('=');
                writer.println(newValue);
                encodedValues.remove(key);
            }
            PropertiesUtils.writeComments(writer, comments, existingLines);
            for (Map.Entry entry : encodedValues.entrySet()) {
                writer.print((String)entry.getKey());
                writer.print('=');
                writer.println((String)entry.getValue());
            }
            writer.flush();
        }
    }

    private static List<String> readLines(File existingFile) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(PropertiesUtils.createFileReader(existingFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }

    private static void writeComments(PrintWriter writer, List<String> comments, List<String> existingLines) throws IOException {
        boolean blankBeforeComment = true;
        for (String comment : comments) {
            String commentLine = "# " + comment;
            if (existingLines.contains(commentLine)) continue;
            if (blankBeforeComment) {
                PropertiesUtils.writeLn(writer, "");
                blankBeforeComment = false;
            }
            PropertiesUtils.writeLn(writer, commentLine);
        }
    }

    private static void writeLn(Writer writer, @Nullable String line) throws IOException {
        if (line != null) {
            writer.write(line);
            writer.write(LINE_SEPARATOR);
        }
    }

    public static InputStreamReader createFileReader(File file) throws FileNotFoundException {
        return PropertiesUtils.createReader(new FileInputStream(file));
    }

    public static OutputStreamWriter createFileWriter(File file) throws FileNotFoundException {
        return PropertiesUtils.createWriter(new FileOutputStream(file));
    }

    public static InputStreamReader createReader(InputStream in) {
        return new InputStreamReader(in, ENCODING);
    }

    public static OutputStreamWriter createWriter(OutputStream out) {
        return new OutputStreamWriter(out, ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(InputStream in, Properties props) throws IOException {
        ByteArrayOutputStream baos = null;
        try {
            BufferedReader reader = new BufferedReader(PropertiesUtils.createReader(in));
            baos = new ByteArrayOutputStream();
            try (PrintWriter writer = new PrintWriter(PropertiesUtils.createWriter(baos));){
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.println(PropertiesUtils.convertUnicode(line));
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(baos);
            throw throwable;
        }
        IOUtils.closeQuietly(baos);
        props.load(PropertiesUtils.createReader(new ByteArrayInputStream(baos.toByteArray())));
    }

    public static void storeProperties(Properties props, OutputStream out, @Nullable String comments) throws IOException {
        props.store(PropertiesUtils.createWriter(out), comments);
    }

    private static String convertUnicode(@Nullable String input) {
        if (input == null) {
            return null;
        }
        int HEX_RADIX = 16;
        int UNICODE_LEN = 4;
        int length = input.length();
        StringBuilder outputBuffer = new StringBuilder(length);
        StringBuilder unicodeBuffer = new StringBuilder(4);
        boolean hadBackslash = false;
        boolean inUnicode = false;
        for (char character : input.toCharArray()) {
            if (inUnicode) {
                unicodeBuffer.append(character);
                if (unicodeBuffer.length() != 4) continue;
                try {
                    int value = Integer.parseInt(unicodeBuffer.toString(), 16);
                    outputBuffer.append((char)value);
                }
                catch (NumberFormatException nfe) {
                    outputBuffer.append("\\u").append((CharSequence)unicodeBuffer);
                }
                unicodeBuffer.setLength(0);
                inUnicode = false;
                hadBackslash = false;
                continue;
            }
            if (hadBackslash) {
                hadBackslash = false;
                if (character == 'u') {
                    inUnicode = true;
                    continue;
                }
                outputBuffer.append('\\');
                outputBuffer.append(character);
                continue;
            }
            if (character == '\\') {
                hadBackslash = true;
                continue;
            }
            outputBuffer.append(character);
        }
        if (hadBackslash) {
            outputBuffer.append('\\');
        }
        return outputBuffer.toString();
    }
}

