/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ClientAccountCache;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.PrintJobDetailsPanel;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.client.uit.accounts.AccountIdListModel;
import biz.papercut.pcng.client.uit.accounts.AccountList;
import biz.papercut.pcng.client.uit.accounts.PreferredList;
import biz.papercut.pcng.client.uit.accounts.RecentList;
import biz.papercut.pcng.common.AccountCommentOption;
import biz.papercut.pcng.common.AccountInvoiceOption;
import biz.papercut.pcng.common.ChargeRate;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.common.ClientJobUpdateResponse;
import biz.papercut.pcng.common.ClientPopupInfo;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.ClientPrintPopupConfig;
import biz.papercut.pcng.util.NumberUtils;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.EnhancedTextField;
import biz.papercut.pcng.util.swing.SwingWorker;
import com.google.common.base.Stopwatch;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdvancedAccountDialog
extends JDialog {
    private static final Logger logger = LoggerFactory.getLogger(AdvancedAccountDialog.class);
    private static final int ACCOUNT_LIST_IDX = 0;
    private static final int PREF_LIST_IDX = 1;
    private static final int RECENT_LIST_IDX = 2;
    private static final int COMMENT_MAX_LENGTH = 255;
    private static final long PERSONAL_ACCOUNT_ID = -1L;
    private static int s_lastSelectedTab = -1;
    private static String s_lastComment = "";
    private static Boolean s_rememberLastComment = false;
    private final ServerConnection _serverConnection;
    private final ClientPrintJob _printJob;
    private final ClientPrintPopupConfig _printJobConfig;
    private final UserClientConfig _clientConfig;
    private AccountIdListModel _preferredAccounts;
    private boolean _preferredAccountsHasChanged;
    private final AccountList _accountList;
    private final PreferredList _prefList;
    private final RecentList _recentList;
    private JButton _okButton;
    private JButton _cancelButton;
    private JCheckBox _applyToAllInQueue;
    private final JComboBox<Object> _chargeRateComboBox;
    private final JTextField _commentTextField;
    private final PrintJobDetailsPanel _printJobDetailsPanel;
    private final JTabbedPane _tabbedPane;
    private final JCheckBox _invoiceOption;
    private JCheckBox _rememberCommentCheckbox;
    private DialogBannerPanel _dialogBannerPanel;
    private int _jobsInQueue = 1;
    private boolean _userMustSelectChargeRate;
    private final Timer _updateJobInfoTimer = new Timer(1000, e -> this.fetchUpdatedJobInfo());
    private final Timer _updateJobCountTimer = new Timer(2000, e -> this.fetchUpdatedJobCount());

    public AdvancedAccountDialog(JFrame owner, UserClientConfig clientConfig, ServerConnection serverConnection, ClientPrintJob printJob, ClientPrintPopupConfig printJobConfig) {
        super((Frame)owner, true);
        logger.debug("Loading advanced account dialog");
        this.setAlwaysOnTop(true);
        this.toFront();
        this._serverConnection = serverConnection;
        this._printJob = printJob;
        this._printJobConfig = printJobConfig;
        this._clientConfig = clientConfig;
        boolean showCode = clientConfig.getServerGlobalConfig().isPinVisible();
        this._accountList = new AccountList(showCode);
        this._prefList = new PreferredList(showCode);
        this._recentList = new RecentList(showCode);
        this._commentTextField = new EnhancedTextField(255);
        this._tabbedPane = new JTabbedPane();
        this._invoiceOption = new JCheckBox(Messages.getString(this.getClass(), "AdvancedAccountDialog.SHOW_ON_INVOICE", new String[0]));
        this._chargeRateComboBox = new JComboBox();
        this._rememberCommentCheckbox = this.getRememberCommentCheckbox();
        this._printJobDetailsPanel = new PrintJobDetailsPanel();
        SelectionListener selectionListener = new SelectionListener();
        this._accountList.addListSelectionListener(selectionListener);
        this._prefList.addListSelectionListener(selectionListener);
        this._recentList.addListSelectionListener(selectionListener);
        this._userMustSelectChargeRate = printJobConfig.isUserMustSelectChargeRate();
        this.layoutComponents();
        this._tabbedPane.addChangeListener(e -> {
            s_lastSelectedTab = this._tabbedPane.getSelectedIndex();
            this.accountSelectionChange();
        });
        this.getRootPane().setDefaultButton(this.getOkButton(this));
        this.setTitle(Messages.getString(this.getClass(), "SelectAccount.title", new String[0]));
        this.doLayout();
        this.pack();
        final int minWidth = (int)this.getSize().getWidth();
        final int minHeight = (int)this.getSize().getHeight();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AdvancedAccountDialog.this.setSize(new Dimension(Math.max(minWidth, AdvancedAccountDialog.this.getWidth()), Math.max(minHeight, AdvancedAccountDialog.this.getHeight())));
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AdvancedAccountDialog.this.cancelButtonPressed();
            }
        });
        this.setSize((int)((double)minWidth * 1.2), (int)((double)minHeight * 1.4));
        this.setLocationRelativeTo(null);
        if (s_rememberLastComment.booleanValue()) {
            this._commentTextField.setText(s_lastComment);
        }
        if (s_lastSelectedTab == -1) {
            String tab = clientConfig.getServerGlobalConfig().getDefaultAdvancedTab();
            s_lastSelectedTab = "PREFERRED".equals(tab) ? 1 : ("RECENT".equals(tab) ? 2 : 0);
        }
        this._tabbedPane.setSelectedIndex(s_lastSelectedTab);
        if (this._tabbedPane.getSelectedIndex() == 0) {
            this._accountList.requestFocusInWindow();
        } else {
            this._commentTextField.requestFocusInWindow();
            this._commentTextField.selectAll();
        }
        this._printJobDetailsPanel.displayJobDetails(printJob);
        this.loadData();
        this._updateJobCountTimer.start();
        if (this._printJob.isPreNotification()) {
            this._updateJobInfoTimer.start();
        }
        MSWindowsUtils.addWindowListenerToBringWindowToFrontOnOpen(this, !this._clientConfig.isDisableToastNotifications());
        DialogUtils.forceRepaintAfterOpened((Window)this);
    }

    private void layoutComponents() {
        this._accountList.setOpaque(false);
        this._tabbedPane.add(Messages.getString(this.getClass(), "AdvancedAccountDialog.ALL_ACCOUNTS", new String[0]), this._accountList);
        this._prefList.setOpaque(false);
        this._tabbedPane.add(Messages.getString(this.getClass(), "AdvancedAccountDialog.PREFERRED_LIST", new String[0]), this._prefList);
        this._recentList.setOpaque(false);
        this._tabbedPane.add(Messages.getString(this.getClass(), "AdvancedAccountDialog.RECENT", new String[0]), this._recentList);
        JPanel accountPanel = new JPanel();
        FormLayout layout = new FormLayout("pref, 2dlu, pref, 2dlu, pref:grow, pref", "pref, 2dlu, pref, 2dlu, pref:grow");
        PanelBuilder builder = new PanelBuilder(layout, accountPanel);
        CellConstraints cc = new CellConstraints();
        builder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        builder.addLabel(Messages.getString(this.getClass(), "AdvancedAccountDialog.COMMENT", new String[0]), cc.xy(1, 1));
        builder.add((Component)this._commentTextField, cc.xyw(3, 1, 3));
        builder.add((Component)this.getRememberCommentCheckbox(), cc.xy(6, 1));
        builder.addLabel(Messages.getString(this.getClass(), "AdvancedAccountDialog.ADJUSTMENT", new String[0]), cc.xy(1, 3));
        builder.add(this._chargeRateComboBox, cc.xy(3, 3));
        builder.add((Component)this._invoiceOption, cc.xy(6, 3));
        builder.add((Component)this._tabbedPane, cc.xyw(1, 5, 6, CellConstraints.FILL, CellConstraints.FILL));
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this._printJobDetailsPanel, "North");
        mainPanel.add((Component)accountPanel, "Center");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.getDialogBannerPanel(), "North");
        contentPanel.add((Component)mainPanel, "Center");
        contentPanel.add((Component)this.getButtonPanel(), "South");
        this.setContentPane(contentPanel);
    }

    private JPanel getButtonPanel() {
        GridBagConstraints gridBagConstraints28 = new GridBagConstraints();
        gridBagConstraints28.gridx = 0;
        gridBagConstraints28.weightx = 1.0;
        gridBagConstraints28.anchor = 17;
        gridBagConstraints28.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints28.gridy = 0;
        GridBagConstraints gridBagConstraints27 = new GridBagConstraints();
        gridBagConstraints27.insets = new Insets(5, 3, 5, 5);
        gridBagConstraints27.gridy = 0;
        gridBagConstraints27.gridx = 2;
        GridBagConstraints gridBagConstraints26 = new GridBagConstraints();
        gridBagConstraints26.insets = new Insets(5, 5, 5, 2);
        gridBagConstraints26.gridy = 0;
        gridBagConstraints26.gridx = 1;
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        buttonPanel.add((Component)this.getOkButton(this), gridBagConstraints26);
        buttonPanel.add((Component)this.getCancelButton(), gridBagConstraints27);
        buttonPanel.add((Component)this.getApplyToAllInQueue(), gridBagConstraints28);
        return buttonPanel;
    }

    private DialogBannerPanel getDialogBannerPanel() {
        if (this._dialogBannerPanel == null) {
            this._dialogBannerPanel = UserClientUtils.getStandardDialogBanner(Messages.getString(this.getClass(), "SelectAccount.title", new String[0]), Messages.getString(this.getClass(), "SelectAccount.description", new String[0]), this._clientConfig.getServerGlobalConfig());
        }
        return this._dialogBannerPanel;
    }

    private JButton getOkButton(JDialog parent) {
        if (this._okButton == null) {
            this._okButton = new JButton();
            this._okButton.setText(Messages.getString(this.getClass(), "SelectAccount.print", new String[0]));
            this._okButton.addActionListener(e -> {
                try {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    this.okButtonPressed();
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            });
        }
        return this._okButton;
    }

    private JButton getCancelButton() {
        if (this._cancelButton == null) {
            this._cancelButton = new JButton();
            this._cancelButton.setText(Messages.getString(this.getClass(), "SelectAccount.cancel", new String[0]));
            this._cancelButton.addActionListener(e -> this.cancelButtonPressed());
        }
        return this._cancelButton;
    }

    private JCheckBox getRememberCommentCheckbox() {
        if (this._rememberCommentCheckbox == null) {
            this._rememberCommentCheckbox = new JCheckBox();
            this._rememberCommentCheckbox.setText(Messages.getString(this.getClass(), "AdvancedAccountDialog.REMEMBER", new String[0]));
            this._rememberCommentCheckbox.setSelected(s_rememberLastComment);
            this._rememberCommentCheckbox.addChangeListener(e -> {
                s_rememberLastComment = this._rememberCommentCheckbox.isSelected();
            });
        }
        return this._rememberCommentCheckbox;
    }

    private JCheckBox getApplyToAllInQueue() {
        if (this._applyToAllInQueue == null) {
            this._applyToAllInQueue = new JCheckBox();
            this._applyToAllInQueue.setText(Messages.getString(this.getClass(), "SelectAccount.apply-to-all-in-queue", "1"));
        }
        return this._applyToAllInQueue;
    }

    private void okButtonPressed() {
        boolean applyToAll;
        ClientJobUpdateResponse status;
        logger.debug("Print button pressed");
        ClientAccount selectedAccount = this.getSelectedAccount();
        if (selectedAccount == null || selectedAccount.isDisabled()) {
            this.displayErrorDialog(Messages.getString(this.getClass(), "AdvancedAccountDialog.NO_ACCOUNT_SELECTED", new String[0]));
            return;
        }
        if (selectedAccount.getComments().equals((Object)AccountCommentOption.COMMENT_REQUIRED) && StringUtils.isBlank((String)this._commentTextField.getText())) {
            this.displayErrorDialog(Messages.getString(this.getClass(), "AdvancedAccountDialog.COMMENT_REQUIRED", new String[0]));
            this._commentTextField.requestFocusInWindow();
            return;
        }
        this.savePreferredAccounts();
        ClientPopupInfo popupInfo = new ClientPopupInfo();
        if (!selectedAccount.getComments().equals((Object)AccountCommentOption.NO_COMMENT)) {
            popupInfo.setComment(StringUtils.left((String)this._commentTextField.getText(), (int)255));
            popupInfo.setComment(StringUtils.trimToEmpty((String)popupInfo.getComment()));
        }
        popupInfo.setInvoice(Boolean.valueOf(this._invoiceOption.isSelected()));
        long accountID = selectedAccount.getAccountId();
        if (accountID == -1L) {
            popupInfo.setChargeToAccountType(ChargeToAccountType.PersonalAccount);
            accountID = 0L;
        } else {
            popupInfo.setChargeToAccountType(ChargeToAccountType.AccountFromList);
        }
        popupInfo.setAccountId(accountID);
        if (this._userMustSelectChargeRate && this._chargeRateComboBox.getSelectedIndex() == 0) {
            this.displayErrorDialog(Messages.getString(this.getClass(), "AdvancedAccountDialog.ADJUSTMENT_REQUIRED", new String[0]));
            return;
        }
        ChargeRate cr = (ChargeRate)this._chargeRateComboBox.getSelectedItem();
        if (cr != null) {
            ArrayList<ChargeRate> rates = new ArrayList<ChargeRate>();
            rates.add(cr);
            popupInfo.setChargeRates(rates);
        }
        if ((status = (applyToAll = this._applyToAllInQueue.isSelected()) ? this._serverConnection.updateAllPendingPrintJobs(this._printJob, false, popupInfo) : this._serverConnection.updatePendingPrintJob(this._printJob, false, popupInfo)).isSuccess()) {
            this.closeAccountDialog();
        } else {
            this.displayErrorDialog(status.getErrorMessage());
            if (!status.isAllowRetry()) {
                this.closeAccountDialog();
            }
        }
        s_lastComment = this._rememberCommentCheckbox.isSelected() ? this._commentTextField.getText() : "";
    }

    private void displayErrorDialog(String msg) {
        DialogUtils.showInformationMessageDialog((Component)this, (String)Messages.getString(this.getClass(), "SelectAccount.error", new String[0]), (String)msg);
    }

    private void savePreferredAccounts() {
        if (this._preferredAccountsHasChanged) {
            logger.debug("Preferred account has changed so submitting this to the server");
            this._serverConnection.setUsersPreferredAccounts(this._printJob, this._preferredAccounts.toString());
        }
    }

    private void cancelButtonPressed() {
        logger.debug("Cancel button pressed");
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.savePreferredAccounts();
            boolean applyToAll = this._applyToAllInQueue.isSelected();
            this._serverConnection.cancelPendingPrintJob(this._printJob, applyToAll);
            this.closeAccountDialog();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void closeAccountDialog() {
        logger.debug("Closing dialog");
        this._updateJobCountTimer.stop();
        this._updateJobInfoTimer.stop();
        this._preferredAccounts.removeAllChangeListeners();
        this._accountList.dispose();
        this._prefList.dispose();
        this._recentList.dispose();
        this.setVisible(false);
    }

    private void accountSelectionChange() {
        ClientAccount ca = this.getSelectedAccount();
        if (ca != null) {
            if (ca.isDisabled()) {
                this._commentTextField.setEnabled(false);
                this._invoiceOption.setEnabled(false);
                this._invoiceOption.setSelected(false);
            } else {
                this._commentTextField.setEnabled(!ca.getComments().equals((Object)AccountCommentOption.NO_COMMENT));
                AccountInvoiceOption invoiceOption = ca.getInvoicing();
                if (invoiceOption.equals((Object)AccountInvoiceOption.NEVER_INVOICE)) {
                    this._invoiceOption.setEnabled(false);
                    this._invoiceOption.setSelected(false);
                } else if (invoiceOption.equals((Object)AccountInvoiceOption.ALWAYS_INVOICE)) {
                    this._invoiceOption.setEnabled(false);
                    this._invoiceOption.setSelected(true);
                } else if (invoiceOption.equals((Object)AccountInvoiceOption.USER_CHOICE_ON)) {
                    this._invoiceOption.setEnabled(true);
                    this._invoiceOption.setSelected(true);
                } else if (invoiceOption.equals((Object)AccountInvoiceOption.USER_CHOICE_OFF)) {
                    this._invoiceOption.setEnabled(true);
                    this._invoiceOption.setSelected(false);
                }
            }
        }
    }

    private ClientAccount getSelectedAccount() {
        ClientAccount ca = null;
        if (this._tabbedPane.getSelectedIndex() == 0) {
            ca = this._accountList.getSelectedAccount();
        } else if (this._tabbedPane.getSelectedIndex() == 1) {
            ca = this._prefList.getSelectedAccount();
        } else if (this._tabbedPane.getSelectedIndex() == 2) {
            ca = this._recentList.getSelectedAccount();
        }
        return ca;
    }

    boolean selectionAppliedToAllJobs() {
        return this._applyToAllInQueue.isSelected();
    }

    private void loadData() {
        SwingWorker<Object> worker = new SwingWorker<Object>(){
            private volatile List<ClientAccount> _accounts;
            private volatile List<Long> _recentAccounts;
            private final Stopwatch loadTimer = Stopwatch.createUnstarted();

            public Object construct() {
                this.loadTimer.start();
                ClientAccountCache cac = ClientAccountCache.getInstance();
                this._accounts = new ArrayList<ClientAccount>(cac.getUserAccounts(AdvancedAccountDialog.this._printJob, AdvancedAccountDialog.this._clientConfig.getDisplayUserName(), AdvancedAccountDialog.this));
                if (AdvancedAccountDialog.this._printJobConfig.isCanChargeToPersonalAccount()) {
                    ClientAccount personal = new ClientAccount(-1L);
                    personal.setParentName(Messages.getString(((Object)((Object)this)).getClass(), "AdvancedAccountDialog.PERSONAL_ACCOUNT", new String[0]));
                    personal.setComments(AccountCommentOption.COMMENT_OPTIONAL);
                    personal.setInvoicing(AccountInvoiceOption.NEVER_INVOICE);
                    this._accounts.add(personal);
                }
                String prefAcc = AdvancedAccountDialog.this._serverConnection.getUsersPreferredAccounts(AdvancedAccountDialog.this._printJob);
                AdvancedAccountDialog.this._preferredAccounts = new AccountIdListModel(prefAcc);
                AdvancedAccountDialog.this._preferredAccounts.addChangeListener(e -> {
                    AdvancedAccountDialog.this._preferredAccountsHasChanged = true;
                });
                String recentAccountsList = AdvancedAccountDialog.this._serverConnection.getUsersRecentAccounts(AdvancedAccountDialog.this._printJob);
                this._recentAccounts = NumberUtils.splitStringToLongList((String)recentAccountsList, (char)',');
                return null;
            }

            public void finished() {
                AdvancedAccountDialog.this.loadChargeRates();
                AdvancedAccountDialog.this._accountList.loadData(this._accounts, AdvancedAccountDialog.this._preferredAccounts);
                if (AdvancedAccountDialog.this._clientConfig.getDefaultSelectedOption() != null) {
                    if (ChargeToAccountType.PersonalAccount.equals((Object)AdvancedAccountDialog.this._clientConfig.getDefaultSelectedOption())) {
                        AdvancedAccountDialog.this._accountList.selectPersonalAccount();
                    } else if (ChargeToAccountType.AccountFromList.equals((Object)AdvancedAccountDialog.this._clientConfig.getDefaultSelectedOption())) {
                        AdvancedAccountDialog.this._accountList.selectAccountByName(AdvancedAccountDialog.this._clientConfig.getDefaultSelectedAccount());
                    }
                } else if (StringUtils.isNotBlank((String)AdvancedAccountDialog.this._clientConfig.getServerUserConfig().getDefaultSharedAccountName())) {
                    AdvancedAccountDialog.this._accountList.selectAccountByName(AdvancedAccountDialog.this._clientConfig.getServerUserConfig().getDefaultSharedAccountName());
                }
                AdvancedAccountDialog.this._prefList.loadData(this._accounts, AdvancedAccountDialog.this._preferredAccounts);
                AdvancedAccountDialog.this._recentList.loadData(this._accounts, this._recentAccounts);
                AdvancedAccountDialog.this.accountSelectionChange();
                logger.debug("Total account load time: {}", (Object)this.loadTimer);
            }
        };
        worker.start();
    }

    private void loadChargeRates() {
        SwingWorker<Object> worker = new SwingWorker<Object>(){
            private volatile List<ChargeRate> _chargeRates;

            public Object construct() {
                this._chargeRates = AdvancedAccountDialog.this._serverConnection.getChargeRates(AdvancedAccountDialog.this._printJob);
                return null;
            }

            public void finished() {
                if (this._chargeRates.isEmpty()) {
                    ChargeRate cr = ChargeRate.getDefaultChargeRate();
                    AdvancedAccountDialog.this._chargeRateComboBox.addItem(cr);
                    AdvancedAccountDialog.this._userMustSelectChargeRate = false;
                } else {
                    if (AdvancedAccountDialog.this._userMustSelectChargeRate) {
                        AdvancedAccountDialog.this._chargeRateComboBox.addItem(Messages.getString(((Object)((Object)this)).getClass(), "AdvancedAccountDialog.SELECT_CHARGE_RATE", new String[0]));
                    }
                    this._chargeRates.forEach(AdvancedAccountDialog.this._chargeRateComboBox::addItem);
                }
            }
        };
        worker.start();
    }

    private void fetchUpdatedJobCount() {
        this._updateJobCountTimer.stop();
        SwingWorker<Object> worker = new SwingWorker<Object>(){

            public Object construct() {
                int newJobCount = AdvancedAccountDialog.this._serverConnection.getPendingPrintJobCount();
                if (newJobCount != AdvancedAccountDialog.this._jobsInQueue) {
                    AdvancedAccountDialog.this._updateJobCountTimer.setDelay(4000);
                    AdvancedAccountDialog.this._updateJobCountTimer.setInitialDelay(4000);
                    AdvancedAccountDialog.this._jobsInQueue = newJobCount;
                }
                return null;
            }

            public void finished() {
                String jobs = String.valueOf(AdvancedAccountDialog.this._jobsInQueue);
                AdvancedAccountDialog.this._applyToAllInQueue.setText(Messages.getString(((Object)((Object)this)).getClass(), "SelectAccount.apply-to-all-in-queue", jobs));
                AdvancedAccountDialog.this._updateJobCountTimer.start();
                int newDelay = Math.min(AdvancedAccountDialog.this._updateJobCountTimer.getDelay() + 2000, 20000);
                AdvancedAccountDialog.this._updateJobCountTimer.setDelay(newDelay);
                AdvancedAccountDialog.this._updateJobCountTimer.setInitialDelay(newDelay);
            }
        };
        worker.start();
    }

    private void fetchUpdatedJobInfo() {
        this._updateJobInfoTimer.stop();
        SwingWorker<Object> worker = new SwingWorker<Object>(){

            public Object construct() {
                AdvancedAccountDialog.this._serverConnection.getUpdatedPrintJobInfo(AdvancedAccountDialog.this._printJob);
                return null;
            }

            public void finished() {
                AdvancedAccountDialog.this._printJobDetailsPanel.displayJobDetails(AdvancedAccountDialog.this._printJob);
                if (AdvancedAccountDialog.this._printJob.isPreNotification()) {
                    int newDelay = Math.min(AdvancedAccountDialog.this._updateJobInfoTimer.getDelay() + 1000, 10000);
                    AdvancedAccountDialog.this._updateJobInfoTimer.setInitialDelay(newDelay);
                    AdvancedAccountDialog.this._updateJobInfoTimer.setDelay(newDelay);
                    AdvancedAccountDialog.this._updateJobInfoTimer.start();
                }
            }
        };
        worker.start();
    }

    private class SelectionListener
    implements ListSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                AdvancedAccountDialog.this.accountSelectionChange();
            }
        }
    }
}

