/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthDialog;
import biz.papercut.pcng.client.uit.ClientAccountCache;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import biz.papercut.pcng.util.swing.DialogUtils;
import com.google.common.annotations.VisibleForTesting;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentDialog
extends JDialog {
    private static final Logger logger = LoggerFactory.getLogger(IdentDialog.class);
    private JTextField _userNameField;
    private JPasswordField _passwordField;
    private JCheckBox _rememberIdentityCheckBox;
    private final UserClientConfig _clientConfig;
    private final ServerConnection _serverConnection;

    public IdentDialog(UserClientFrame uit, UserClientConfig clientConfig, ServerConnection connection) {
        super(uit, IdentDialog.format("login", new String[0]), true);
        logger.debug("Displaying identity dialog");
        this.setAlwaysOnTop(true);
        this.toFront();
        this._serverConnection = connection;
        this._clientConfig = clientConfig;
        this.layoutComponents();
        MSWindowsUtils.addWindowListenerToBringWindowToFrontOnOpen(this, !this._clientConfig.isDisableToastNotifications());
        DialogUtils.forceRepaintAfterOpened((Window)this);
    }

    protected IdentDialog(UserClientConfig config, ServerConnection connection) {
        this._serverConnection = connection;
        this._clientConfig = config;
    }

    private void layoutComponents() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        ClientGlobalConfigFromServer confFromServer = this._clientConfig.getServerGlobalConfig();
        DialogBannerPanel bannerPanel = UserClientUtils.getStandardDialogBanner(IdentDialog.format("login", new String[0]), IdentDialog.format("description", new String[0]), confFromServer);
        contentPanel.add((Component)bannerPanel, "North");
        FormLayout layoutCenter = new FormLayout("15dlu, right:max(pref;40dlu), 3dlu, max(pref;120dlu):grow, 20dlu", "0dlu:grow, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 0dlu:grow");
        layoutCenter.setRowGroups((int[][])new int[][]{{2, 4, 6}});
        JPanel centerPanel = new JPanel();
        DefaultFormBuilder builder = new DefaultFormBuilder(layoutCenter, centerPanel);
        builder.setDefaultDialogBorder();
        builder.setRow(2);
        builder.setColumn(2);
        builder.append((Component)new JLabel(IdentDialog.format("detailed-description", new String[0])), 3);
        builder.nextLine(2);
        builder.setColumn(2);
        this._userNameField = new JTextField();
        builder.append(IdentDialog.format("username", new String[0]), (Component)this._userNameField);
        builder.nextLine(2);
        builder.setColumn(2);
        this._passwordField = new JPasswordField();
        builder.append(IdentDialog.format("password", new String[0]), (Component)this._passwordField);
        builder.nextLine(2);
        builder.setColumn(4);
        boolean remember = this._clientConfig.isAlwaysRequestIdentity();
        this._rememberIdentityCheckBox = new JCheckBox(IdentDialog.format("remember", new String[0]), remember);
        builder.append((Component)this._rememberIdentityCheckBox);
        contentPanel.add((Component)centerPanel, "Center");
        JButton okButton = new JButton(IdentDialog.format("ok", new String[0]));
        okButton.addActionListener(e -> this.okButtonPressed());
        JButton cancelButton = new JButton(IdentDialog.format("cancel", new String[0]));
        cancelButton.addActionListener(e -> this.cancelButtonPressed());
        FormLayout layoutFooter = new FormLayout("pref:grow", "pref");
        JPanel buttonPanel = new JPanel();
        builder = new DefaultFormBuilder(layoutFooter, buttonPanel);
        builder.setDefaultDialogBorder();
        JPanel buttonPanelInner = ButtonBarFactory.buildOKCancelBar((JButton)okButton, (JButton)cancelButton);
        builder.append((Component)buttonPanelInner);
        contentPanel.add((Component)buttonPanel, "South");
        this.setContentPane(contentPanel);
        this.getRootPane().setDefaultButton(okButton);
        this.pack();
        final int minWidth = (int)this.getSize().getWidth();
        final int minHeight = (int)this.getSize().getHeight();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                IdentDialog.this.setSize(new Dimension(Math.max(minWidth, IdentDialog.this.getWidth()), Math.max(minHeight, IdentDialog.this.getHeight())));
            }
        });
        this.setLocationRelativeTo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void okButtonPressed() {
        try {
            logger.debug("OK button pressed");
            this.setCursor(Cursor.getPredefinedCursor(3));
            String username = this.getUserNameField().getText();
            String password = new String(this.getPasswordField().getPassword());
            ClientAuthResponse response = this._serverConnection.checkIdentity(username, password);
            if (response.isSuccess()) {
                this.logUserIn(false, response);
            } else {
                if (response.isMfaRequired()) {
                    ClientAuthResponse mfaOutcome;
                    this.closeDialog();
                    if (!this.enforceHigherSecurity(username)) {
                        this.displayEnforceHigherSecurityFailedError();
                        return;
                    }
                    String extAuthUrl = response.getExtAuthUrl();
                    boolean browseSuccess = this.browseUrl(extAuthUrl);
                    if (browseSuccess && (mfaOutcome = this.pollServerForMfaOutcome(response, username)) != null && mfaOutcome.isSuccess()) {
                        this.logUserIn(true, mfaOutcome);
                    }
                    return;
                }
                DialogUtils.showInformationMessageDialog((Component)this, (String)IdentDialog.format("error", new String[0]), (String)response.getErrorMessage());
            }
        }
        catch (Throwable e) {
            logger.error("Unable to call authentication method: {}", (Object)e.getMessage(), (Object)e);
            this.showInformationMessageDialog(e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void showInformationMessageDialog(Throwable exception) {
        DialogUtils.showInformationMessageDialog((Component)this, (String)IdentDialog.format("error", new String[0]), (String)(exception.getCause() != null ? exception.getCause().getMessage() : exception.getMessage()));
    }

    @VisibleForTesting
    protected void logUserIn(boolean isMfa, ClientAuthResponse mfaOutcome) {
        logger.debug(isMfa ? "MFA log in success!" : "Log in success!");
        String username = mfaOutcome.getRealName();
        this._clientConfig.setDisplayUserName(username);
        this._clientConfig.setUserName(username);
        if (isMfa) {
            ClientAccountCache.initialise(this.getServerConnection(), this.getClientConfig());
        }
        if (this._rememberIdentityCheckBox.isSelected() && !username.equalsIgnoreCase(System.getProperty("user.name"))) {
            logger.debug("Saving identity to file: {}", (Object)username);
            ClientConfigFile.saveUsernameToUserLevelConfig(username);
            logger.debug("Completed save of identity file.");
        }
        this._clientConfig.setSuccessfullyIdentified(true);
        this.closeDialog();
    }

    private static String format(String key, String ... args) {
        String fullKey = "IdentDialog." + key;
        return Messages.getString(AuthDialog.class, fullKey, args);
    }

    protected void cancelButtonPressed() {
        logger.debug("Cancel button pressed");
        this.closeDialog();
    }

    @VisibleForTesting
    protected void closeDialog() {
        this.setVisible(false);
    }

    public ServerConnection getServerConnection() {
        return this._serverConnection;
    }

    public UserClientConfig getClientConfig() {
        return this._clientConfig;
    }

    @VisibleForTesting
    protected JTextField getUserNameField() {
        return this._userNameField;
    }

    @VisibleForTesting
    protected JPasswordField getPasswordField() {
        return this._passwordField;
    }

    @VisibleForTesting
    protected boolean enforceHigherSecurity(String username) {
        return UserClientUtils.enforceHigherSec(this.getServerConnection(), this.getClientConfig(), username, false);
    }

    @VisibleForTesting
    protected boolean browseUrl(String extAuthUrl) {
        return UserClientUtils.browseUrlInOS(extAuthUrl);
    }

    @VisibleForTesting
    protected void displayEnforceHigherSecurityFailedError() {
        DialogUtils.showInformationMessageDialog((Component)this, (String)IdentDialog.format("error", new String[0]), (String)IdentDialog.format("no-ssl-for-mfa", new String[0]));
    }

    @VisibleForTesting
    protected ClientAuthResponse pollServerForMfaOutcome(ClientAuthResponse originalResponse, String username) {
        return UserClientUtils.pollServerForMfaStatus(originalResponse, this.getServerConnection(), username, this, null);
    }
}

