/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public final class Messages {
    private static final Properties _customMessages = new Properties();
    private static final Map<String, String> _configMessageKeyMap = Messages.createMap();

    public static void processCustomMessages(Properties config) {
        for (Map.Entry<String, String> entry : _configMessageKeyMap.entrySet()) {
            String message = config.getProperty(entry.getKey());
            if (!StringUtils.isNotBlank((String)message)) continue;
            _customMessages.setProperty(entry.getValue(), message);
        }
    }

    public static String getString(Class<?> clazz, String key, String ... args) {
        return Messages.getString(clazz, null, key, args);
    }

    public static String getString(Class<?> clazz, Locale locale, String key, String ... args) {
        String pattern = _customMessages.getProperty(key);
        if (pattern != null) {
            if (args == null || args.length == 0) {
                return pattern;
            }
            return MessageFormat.format(pattern, args);
        }
        return biz.papercut.pcng.util.Messages.getString(clazz, (Locale)locale, (String)key, (String[])args);
    }

    private static Map<String, String> createMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("account-from-list-allocate-text", "SelectAccount.account-from-list-allocate");
        map.put("account-from-list-text", "SelectAccount.account-from-list");
        map.put("account-pin-text", "SelectAccount.account-pin");
        map.put("account-with-pin-allocate-text", "SelectAccount.account-with-pin-allocate");
        map.put("account-with-pin-text", "SelectAccount.account-with-pin");
        map.put("auth-description-text", "AuthDialog.description");
        map.put("auth-login-text", "AuthDialog.login");
        map.put("auth-password-text", "AuthPanel.password");
        map.put("auth-username-text", "AuthPanel.username");
        map.put("auth-pin-text", "AuthPanel.pin");
        map.put("auth-id-number-text", "AuthPanel.id-number");
        map.put("identity-description-text", "IdentDialog.description");
        map.put("identity-detailed-text", "IdentDialog.detailed-description");
        map.put("identity-login-text", "IdentDialog.login");
        map.put("identity-password-text", "IdentDialog.password");
        map.put("identity-username-text", "IdentDialog.username");
        map.put("no-accounts-text", "SelectAccount.no-accounts");
        map.put("other-user-account-text", "SelectAccount.other-user-account");
        map.put("personal-account-text", "SelectAccount.personal-account");
        map.put("select-account-text", "SelectAccount.select-account");
        map.put("user-balance-for-text", "UserClientFrame.balance-for");
        map.put("user-close-warning-text", "UserClientFrame.close-warning");
        map.put("user-details-text", "UserClientFrame.user-details");
        return map;
    }

    private Messages() {
    }
}

