/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.client.dialogrequest;

import biz.papercut.pcng.common.client.dialogrequest.ChoiceDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.HTMLFormDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.TextDialogRequest;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogProtocolHelper {
    private static final Logger logger = LoggerFactory.getLogger(DialogProtocolHelper.class);

    public static ClientDialogRequest parseFromHashtable(Hashtable<String, Object> data) {
        String typeName = (String)data.get("type");
        if (typeName == null) {
            throw new IllegalArgumentException("Unknown dialog type. Not 'type' specified.");
        }
        switch (typeName) {
            case "MessageDialog": {
                return new MessageDialogRequest(data);
            }
            case "TextDialog": {
                return new TextDialogRequest(data);
            }
            case "ChoiceDialog": {
                return new ChoiceDialogRequest(data);
            }
            case "HTMLFormDialog": {
                return new HTMLFormDialogRequest(data);
            }
        }
        logger.debug("Unknown dialog type: {}. Data: {}", (Object)typeName, data);
        return null;
    }

    public static String getResponsePrintEventID(Hashtable<String, Object> data) {
        return (String)data.get("printEventID");
    }

    public static String getResponseUniqueID(Hashtable<String, Object> data) {
        return (String)data.get("uniqueID");
    }

    private DialogProtocolHelper() {
    }
}

