/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import biz.papercut.pcng.util.swing.DisabledComboBoxItemTester;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class DisabledComboBox<E>
extends JComboBox<E> {
    public DisabledComboBox(DisabledComboBoxItemTester tester) {
        if (tester == null) {
            throw new IllegalArgumentException("A valid tester is required");
        }
        this.setRenderer(new ComboBoxRenderer(tester));
        this.addActionListener(new ComboListener(this, tester));
    }

    public static class ComboBoxRenderer<E>
    extends JLabel
    implements ListCellRenderer<E> {
        private final DisabledComboBoxItemTester _tester;

        public ComboBoxRenderer(DisabledComboBoxItemTester tester) {
            this._tester = tester;
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (this._tester.isDisabled(value)) {
                this.setBackground(list.getBackground());
                this.setForeground(UIManager.getColor("Label.disabledForeground"));
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    public static class ComboListener<E>
    implements ActionListener {
        private final JComboBox<E> _combo;
        private final DisabledComboBoxItemTester _tester;
        private Object _currentItem;

        ComboListener(JComboBox<E> combo, DisabledComboBoxItemTester tester) {
            this._tester = tester;
            this._combo = combo;
            this._currentItem = combo.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object tempItem = this._combo.getSelectedItem();
            if (this._tester.isDisabled(tempItem)) {
                if (this._currentItem != null) {
                    this._combo.setSelectedItem(this._currentItem);
                } else {
                    this._combo.setSelectedIndex(0);
                }
            } else {
                this._currentItem = tempItem;
            }
        }
    }
}

