/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import biz.papercut.pcng.util.NetworkUtils;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleInstanceLock {
    protected static final Logger logger = LoggerFactory.getLogger(SingleInstanceLock.class);
    private final String _appName;
    private File _file;
    private FileChannel _channel;
    private RandomAccessFile randomAccessFile;
    private FileLock _lock;
    private final boolean _firstInstance;
    private final String _lockDirectory;

    public SingleInstanceLock(String appName, String lockDirectory) {
        this._appName = appName;
        this._lockDirectory = lockDirectory;
        this._firstInstance = this.isFirstInstanceInternal();
    }

    private boolean isFirstInstanceInternal() {
        try {
            String fileName = ("." + this._appName + "." + StringUtils.trimToEmpty((String)System.getProperty("user.name")) + "." + StringUtils.trimToEmpty((String)NetworkUtils.getComputerName()) + ".tmp").toLowerCase();
            this._file = null;
            if (StringUtils.isNotEmpty((String)this._lockDirectory)) {
                this._file = new File(this._lockDirectory, fileName);
            } else {
                try {
                    File profileDir;
                    String profileDirPath;
                    if (SystemUtils.IS_OS_WINDOWS && SystemUtils.isJavaVersionAtLeast((int)150) && StringUtils.isNotEmpty((String)(profileDirPath = System.getenv("USERPROFILE"))) && (profileDir = new File(profileDirPath)).exists()) {
                        this._file = new File(profileDir, fileName);
                    }
                }
                catch (Exception e) {
                    this._file = null;
                }
                if (this._file == null) {
                    this._file = new File(System.getProperty("user.home"), fileName);
                }
            }
            this.randomAccessFile = new RandomAccessFile(this._file, "rw");
            this._channel = this.randomAccessFile.getChannel();
            try {
                this._lock = this._channel.tryLock();
            }
            catch (OverlappingFileLockException e) {
                logger.debug("File already locked");
                this.releaseLockAndCloseFile();
                return false;
            }
            if (this._lock == null) {
                this.releaseLockAndCloseFile();
                return false;
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                this.releaseLockAndCloseFile();
                this.deleteFile();
            }));
            return true;
        }
        catch (Exception e) {
            logger.error("Error setting up lock. {}", (Object)e.getMessage(), (Object)e);
            this.releaseLockAndCloseFile();
            return true;
        }
    }

    private void releaseLockAndCloseFile() {
        try {
            this._lock.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this._channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.randomAccessFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteFile() {
        try {
            this._file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isFirstInstance() {
        return this._firstInstance;
    }
}

