/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwingUtils {
    private static final Logger logger = LoggerFactory.getLogger(SwingUtils.class);

    private SwingUtils() {
    }

    public static boolean isLocaleThatHasFontDisplayProblems() {
        String langCode = Locale.getDefault().getLanguage().toLowerCase();
        return langCode.equals("zh") || langCode.equals("ja") || langCode.equals("ko");
    }

    public static void setupSystemLookAndFeel() {
        SwingUtils.runOnEventThread(() -> {
            boolean winLAFEnabled = false;
            if (SystemUtils.IS_OS_WINDOWS && !SwingUtils.isLocaleThatHasFontDisplayProblems()) {
                try {
                    UIManager.setLookAndFeel("net.java.plaf.windows.WindowsLookAndFeel");
                    winLAFEnabled = true;
                }
                catch (Throwable t) {
                    logger.debug("Could not enable WinLAF, falling back to system LAF.");
                }
            }
            if (!winLAFEnabled) {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (Throwable t) {
                    logger.debug("Could not enable system LAF, using default LAF.");
                }
            }
        }, true);
    }

    public static void addEscapeKeyHandler(JComponent component, final ActionListener actionListener) {
        KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction escapeAction = new AbstractAction("escape"){
            private static final long serialVersionUID = 4995949603013461434L;

            @Override
            public void actionPerformed(ActionEvent e) {
                actionListener.actionPerformed(e);
            }
        };
        component.getInputMap(2).put(stroke, escapeAction.getValue("Name"));
        component.getActionMap().put(escapeAction.getValue("Name"), escapeAction);
    }

    public static void changeDefaultFontSizes(double scale) {
        SwingUtils.runOnEventThread(() -> {
            UIDefaults defaults = UIManager.getDefaults();
            for (Object key : Collections.list(defaults.keys())) {
                try {
                    Object value = defaults.get(key);
                    if (!(value instanceof Font)) continue;
                    UIManager.put(key, null);
                    Font font = UIManager.getFont(key);
                    if (font == null) continue;
                    float size = font.getSize2D();
                    UIManager.put(key, new FontUIResource(font.deriveFont((float)((double)size * scale))));
                }
                catch (Exception e) {
                    logger.warn("Could not scale font for UI key: {}", key, (Object)e);
                }
            }
        }, true);
    }

    public static Color getColorWithAlpha(Color baseColor, float alpha) {
        float[] rgb = baseColor.getRGBComponents(null);
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    public static JDialog createAlwaysOnTopOkDialog(String title, String message, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType);
        JDialog dialog = pane.createDialog(null, title);
        dialog.setAlwaysOnTop(true);
        return dialog;
    }

    public static boolean setWindowAlpha(Window win, float alpha) {
        boolean success = false;
        try {
            Class<?> awtutil = Class.forName("com.sun.awt.AWTUtilities");
            Method setWindowOpaque = awtutil.getMethod("setWindowOpacity", Window.class, Float.TYPE);
            setWindowOpaque.invoke(null, win, Float.valueOf(alpha));
            success = true;
        }
        catch (Exception awtutil) {
            // empty catch block
        }
        if (!success && SystemUtils.IS_OS_MAC) {
            try {
                if (win instanceof JFrame) {
                    JFrame frame = (JFrame)win;
                    frame.getRootPane().putClientProperty("Window.alpha", Float.valueOf(alpha));
                    success = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return success;
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration graphicsConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (image.getColorModel().equals(graphicsConfig.getColorModel())) {
            return image;
        }
        int transparency = 3;
        try {
            transparency = image.getTransparency();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BufferedImage compatibleImage = graphicsConfig.createCompatibleImage(image.getWidth(), image.getHeight(), transparency);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static void setOpaqueIfRequired(JButton button) {
        SwingUtils.runOnEventThread(() -> {
            try {
                Class<?> windowsLookAndFeel = Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                LookAndFeel laf = UIManager.getLookAndFeel();
                if (windowsLookAndFeel.isInstance(laf)) {
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    button.setOpaque(!Boolean.TRUE.equals(toolkit.getDesktopProperty("win.xpstyle.themeActive")));
                }
            }
            catch (Exception e) {
                logger.debug("Unable to determine graphics environment. Defaulting to non-opaque button.");
                button.setOpaque(false);
            }
        }, true);
    }

    public static void runOnEventThread(Runnable runnable, boolean andWait) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                if (andWait) {
                    SwingUtilities.invokeAndWait(runnable);
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (InvocationTargetException ite) {
                logger.error(ite.getMessage(), (Throwable)ite);
            }
        }
    }
}

