/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing.flash;

import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.SwingUtils;
import biz.papercut.pcng.util.swing.flash.FlashContent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.StringUtils;

public class FlashInput
extends JPanel
implements FlashContent {
    private final JTextField _inputField;
    private final SubmitListener _submitListener;
    private final ActionListener _activityListener;
    private volatile FlashContent.FlashContentEventHandler _eventHandler;

    public FlashInput(Builder builder) {
        String title = StringUtils.trimToNull((String)builder._title);
        String text = StringUtils.trimToEmpty((String)builder._text).replace("\n", "<br />");
        this._submitListener = builder._submitListener;
        this._activityListener = builder._activityListener;
        ActionListener submitActionListener = e -> {
            this._submitListener.submitPerformed(this.getInput());
            this._eventHandler.hide();
        };
        ActionListener dismissActionListener = e -> {
            if (this._eventHandler != null) {
                this._eventHandler.dismiss();
            }
        };
        int pad = 10;
        this.setLayout(new BorderLayout(pad, pad));
        this.setOpaque(true);
        this.setBackground(builder._background);
        this.setForeground(builder._foreground);
        this.setBorder(BorderFactory.createLineBorder(builder._foreground, 2));
        if (title != null) {
            JPanel titlePanel = new JPanel(new BorderLayout());
            titlePanel.setBackground(builder._background);
            titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, builder._foreground), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            JLabel titleLabel = new JLabel(title);
            titleLabel.setForeground(builder._foreground);
            titlePanel.add((Component)titleLabel, "West");
            this.add((Component)titlePanel, "North");
        }
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(pad, pad));
        contentPanel.setBackground(builder._background);
        contentPanel.setBorder(BorderFactory.createEmptyBorder(pad, pad, pad, pad));
        JLabel textLabel = new JLabel("<html><center>" + text + "</center></html>");
        textLabel.setForeground(builder._foreground);
        textLabel.setFont(new Font(textLabel.getFont().getName(), 0, textLabel.getFont().getSize()));
        contentPanel.add((Component)textLabel, "North");
        this._inputField = new JTextField(20);
        this._inputField.addActionListener(submitActionListener);
        this._inputField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FlashInput.this.activityOccurred();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FlashInput.this.activityOccurred();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FlashInput.this.activityOccurred();
            }
        });
        contentPanel.add((Component)this._inputField, "Center");
        if (builder._label != null) {
            JLabel inputLabel = new JLabel(builder._label);
            inputLabel.setForeground(builder._foreground);
            inputLabel.setLabelFor(this._inputField);
            contentPanel.add((Component)inputLabel, "West");
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.setOpaque(false);
        JButton okButton = new JButton(Messages.getString(this.getClass(), "FlashInput.ok", new String[0]));
        SwingUtils.setOpaqueIfRequired(okButton);
        okButton.addActionListener(submitActionListener);
        buttonPanel.add(okButton);
        JButton cancelButton = new JButton(Messages.getString(this.getClass(), "FlashInput.cancel", new String[0]));
        SwingUtils.setOpaqueIfRequired(cancelButton);
        cancelButton.addActionListener(dismissActionListener);
        buttonPanel.add(cancelButton);
        contentPanel.add((Component)buttonPanel, "South");
        this.add((Component)contentPanel, "Center");
    }

    public void addFocusListenerOnInput(FocusListener focusListener) {
        this._inputField.addFocusListener(focusListener);
    }

    public String getInput() {
        return StringUtils.trimToNull((String)this._inputField.getText());
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public void setEventHandler(FlashContent.FlashContentEventHandler eventHandler) {
        this._eventHandler = eventHandler;
    }

    @Override
    public void showing() {
        this._inputField.requestFocus();
    }

    protected void activityOccurred() {
        if (this._eventHandler != null) {
            this._eventHandler.activityOccurred();
        }
        if (this._activityListener != null) {
            this._activityListener.actionPerformed(new ActionEvent(this, 0, "KEY_TYPED"));
        }
    }

    public static class Builder {
        private String _title;
        private String _text;
        private String _label;
        private Color _background;
        private Color _foreground;
        private SubmitListener _submitListener;
        private ActionListener _activityListener;

        public Builder title(String title) {
            this._title = title;
            return this;
        }

        public Builder text(String text) {
            this._text = text;
            return this;
        }

        public Builder background(Color background) {
            this._background = background;
            return this;
        }

        public Builder foreground(Color foreground) {
            this._foreground = foreground;
            return this;
        }

        public Builder label(String label) {
            this._label = label;
            return this;
        }

        public Builder submitListener(SubmitListener submitListener) {
            this._submitListener = submitListener;
            return this;
        }

        public Builder activityListener(ActionListener activityListener) {
            this._activityListener = activityListener;
            return this;
        }

        public FlashInput build() {
            if (this._background == null) {
                throw new IllegalStateException("background color is required");
            }
            if (this._foreground == null) {
                throw new IllegalStateException("foreground color is required");
            }
            if (this._submitListener == null) {
                throw new IllegalStateException("submit listener is required");
            }
            return new FlashInput(this);
        }
    }

    public static interface SubmitListener {
        public void submitPerformed(String var1);
    }
}

