/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.io.IOUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientAccountFile {
    private static final Logger logger = LoggerFactory.getLogger(ClientAccountFile.class);
    private static final String CLIENT_ACCOUNTS_ZIP_ENTRY = "client-accounts";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeClientAccountFile(String fileName, List<ClientAccount> accounts, int accountFormat) throws IOException {
        FileOutputStream fos = null;
        try {
            File file = new File(fileName);
            fileName = file.getCanonicalPath();
            File tempFile = new File(fileName + ".incomplete");
            logger.debug("Writing client account file to: {}", (Object)fileName);
            File parentDir = new File(fileName).getParentFile();
            if (!parentDir.exists() && !parentDir.mkdirs()) {
                logger.debug("Unable to create parent dirs");
            }
            fos = new FileOutputStream(tempFile);
            ClientAccountFile.writeClientAccountsToStream(fos, accounts, accountFormat);
            IOUtils.closeQuietly(fos);
            if (file.exists()) {
                logger.debug("Deleting previous client account file: {}", (Object)fileName);
                if (!file.delete()) {
                    logger.debug("Unable to delete old parent account file.");
                }
            }
            if (!tempFile.renameTo(file)) {
                logger.debug("Unable to rename tmp file to: {}", (Object)file);
            }
            logger.debug("Completed writing client account file.");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ClientAccount> readClientAccountFile(String fileName, int accountFormat, boolean loadDisabledSharedAccounts) throws IOException {
        List<ClientAccount> list;
        FileInputStream fin = null;
        try {
            File f = new File(fileName);
            fileName = f.getAbsolutePath();
            long start = System.currentTimeMillis();
            logger.debug("Loading account data from file: {}", (Object)fileName);
            if (!f.exists()) {
                throw new FileNotFoundException("Cannot find client account file: " + fileName);
            }
            fin = new FileInputStream(f);
            List<ClientAccount> accounts = ClientAccountFile.readClientAccountsFromStream(fin, accountFormat, loadDisabledSharedAccounts);
            long stop = System.currentTimeMillis();
            logger.debug("Completed loading account data from file. Took: {}ms. Accounts: {}", (Object)(stop - start), (Object)accounts.size());
            list = accounts;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            throw throwable;
        }
        IOUtils.closeQuietly(fin);
        return list;
    }

    public static void writeClientAccountsToStream(OutputStream out, List<ClientAccount> accounts, int accountFormat) throws IOException {
        ZipOutputStream zipOut = new ZipOutputStream(out);
        zipOut.putNextEntry(new ZipEntry(CLIENT_ACCOUNTS_ZIP_ENTRY));
        DataOutputStream dos = new DataOutputStream(zipOut);
        dos.writeInt(accountFormat);
        dos.writeInt(accounts.size());
        for (ClientAccount clientAccount : accounts) {
            ClientAccountFile.writeListToStream(dos, clientAccount.saveToVector(accountFormat));
        }
        dos.flush();
        zipOut.finish();
    }

    public static List<ClientAccount> readClientAccountsFromStream(InputStream in, int accountFormat, boolean loadDisabledSharedAccounts) throws IOException {
        ZipEntry ze;
        ZipInputStream zipIn = new ZipInputStream(in);
        do {
            if ((ze = zipIn.getNextEntry()) != null) continue;
            throw new ApplicationException("Invalid client account file, and does not contain the entry: client-accounts");
        } while (!CLIENT_ACCOUNTS_ZIP_ENTRY.equals(ze.getName()));
        DataInputStream din = new DataInputStream(zipIn);
        int format = din.readInt();
        if (format != accountFormat) {
            throw new ApplicationException("Unsupported client file format: " + format + ". Expecting: " + accountFormat);
        }
        int size = din.readInt();
        ArrayList<ClientAccount> accounts = new ArrayList<ClientAccount>(size);
        Vector<Object> prototypeList = new ClientAccount(0L).saveToVector(accountFormat);
        for (int i = 0; i < size; ++i) {
            List<Object> acctList = ClientAccountFile.readListFromStream(din, prototypeList);
            ClientAccount clientAccount = ClientAccount.loadFromList(acctList, accountFormat);
            if (!loadDisabledSharedAccounts && clientAccount.isDisabled()) continue;
            accounts.add(clientAccount);
        }
        zipIn.closeEntry();
        return accounts;
    }

    private static List<Object> readListFromStream(DataInputStream in, List<Object> prototype) throws IOException {
        ArrayList<Object> r = new ArrayList<Object>(prototype.size());
        Iterator<Object> iterator = prototype.iterator();
        block8: while (iterator.hasNext()) {
            Object protoObj;
            Object object = protoObj = iterator.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Boolean.class, Double.class, Float.class}, (Object)object, n)) {
                case -1: {
                    throw new IllegalArgumentException("Null prototype data not supported");
                }
                case 0: {
                    String string = (String)object;
                    String s = in.readUTF();
                    if (s.isEmpty()) {
                        s = "";
                    }
                    r.add(s);
                    continue block8;
                }
                case 1: {
                    Integer i = (Integer)object;
                    r.add(in.readInt());
                    continue block8;
                }
                case 2: {
                    Boolean b = (Boolean)object;
                    r.add(in.readBoolean());
                    continue block8;
                }
                case 3: {
                    Double v = (Double)object;
                    r.add(in.readDouble());
                    continue block8;
                }
                case 4: {
                    Float v = (Float)object;
                    r.add(Float.valueOf(in.readFloat()));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unsupported type to serialize: " + protoObj.getClass().getName());
        }
        return r;
    }

    private static void writeListToStream(DataOutputStream out, List<Object> data) throws IOException {
        Iterator<Object> iterator = data.iterator();
        block8: while (iterator.hasNext()) {
            Object obj;
            Object object = obj = iterator.next();
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Boolean.class, Double.class, Float.class}, (Object)object, n)) {
                case -1: {
                    throw new IllegalArgumentException("Null data not supported");
                }
                case 0: {
                    String s = (String)object;
                    out.writeUTF(s);
                    continue block8;
                }
                case 1: {
                    Integer i = (Integer)object;
                    out.writeInt(i);
                    continue block8;
                }
                case 2: {
                    Boolean b = (Boolean)object;
                    out.writeBoolean(b);
                    continue block8;
                }
                case 3: {
                    Double v = (Double)object;
                    out.writeDouble(v);
                    continue block8;
                }
                case 4: {
                    Float v = (Float)object;
                    out.writeFloat(v.floatValue());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unsupported type to serialize: " + obj.getClass().getName());
        }
    }
}

