/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.common.ChargeRate;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.util.ObjectUtils;
import java.nio.charset.StandardCharsets;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPopupInfo {
    private static final Logger logger = LoggerFactory.getLogger(ClientPopupInfo.class);
    private ChargeToAccountType _chargeToAccountType;
    private long _accountId;
    private String _accountPin;
    private String _userName;
    private String _password;
    private String _comment;
    private Boolean _invoice;
    private List<ChargeRate> _chargeRates;

    public static ClientPopupInfo createFromRPCData(Hashtable<String, Object> data) {
        ClientPopupInfo popupInfo = new ClientPopupInfo();
        String s = (String)data.get("account-to-charge-type");
        ChargeToAccountType type = ChargeToAccountType.valueOf(s);
        if (type == null) {
            logger.error("Client popup info missing mandatory charge-to-type: {}", data);
            throw new IllegalArgumentException("Client popup info missing mandatory charge-to-type");
        }
        popupInfo.setChargeToAccountType(type);
        if ((type == ChargeToAccountType.AccountFromList || type == ChargeToAccountType.ManagerPrint) && StringUtils.isNotBlank((String)(s = (String)data.get("account-id")))) {
            popupInfo.setAccountId(Long.parseLong(s));
        }
        if ((type == ChargeToAccountType.AccountWithPin || type == ChargeToAccountType.ManagerPrint) && (s = (String)data.get("account-pin")) != null) {
            popupInfo.setAccountPin(ClientPopupInfo.decodePassword(s));
        }
        if (type == ChargeToAccountType.OtherUser || type == ChargeToAccountType.ManagerPrint) {
            s = (String)data.get("username");
            if (s != null) {
                popupInfo.setUserName(s);
            }
            if ((s = (String)data.get("password")) != null) {
                popupInfo.setPassword(ClientPopupInfo.decodePassword(s));
            }
        }
        popupInfo.setComment((String)data.get("job-comment"));
        popupInfo.setInvoice((Boolean)data.get("job-invoice"));
        s = (String)data.get("charge-rate");
        try {
            List<ChargeRate> rates = ChargeRate.stringToList(s);
            if (rates != null && !rates.isEmpty()) {
                popupInfo.setChargeRates(rates);
            }
        }
        catch (Exception e) {
            logger.debug("Error parsing charge rates from client: {}", (Object)s, (Object)e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{} from {}", (Object)popupInfo, data);
        }
        return popupInfo;
    }

    public long getAccountId() {
        return this._accountId;
    }

    public void setAccountId(long accountId) {
        this._accountId = accountId;
    }

    public ChargeToAccountType getChargeToAccountType() {
        return this._chargeToAccountType;
    }

    public void setChargeToAccountType(ChargeToAccountType chargeToAccountType) {
        this._chargeToAccountType = chargeToAccountType;
    }

    public String getComment() {
        return this._comment;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public Boolean getInvoice() {
        return this._invoice;
    }

    public void setInvoice(Boolean invoice) {
        this._invoice = invoice;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public synchronized String getAccountPin() {
        return this._accountPin;
    }

    public synchronized void setAccountPin(String accountPin) {
        this._accountPin = accountPin;
    }

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    public List<ChargeRate> getChargeRates() {
        return this._chargeRates;
    }

    public void setChargeRates(List<ChargeRate> chargeRates) {
        this._chargeRates = chargeRates;
    }

    public static String decodePassword(String encodedPassword) {
        return new String(Base64.decodeBase64((byte[])encodedPassword.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
    }

    public static String encodePassword(String password) {
        return new String(Base64.encodeBase64((byte[])password.getBytes(StandardCharsets.UTF_8)));
    }

    public String toString() {
        return ObjectUtils.createToStringBuilder(this).append("chargeToType", (Object)this._chargeToAccountType).append("accountId", this._accountId).append("accountPin", (Object)this._accountPin).append("userName", (Object)this._userName).append("comment", (Object)this._comment).append("invoice", (Object)this._invoice).append("chargeRates", this._chargeRates).toString();
    }
}

