/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.DateTimeFormatterRegistry;
import biz.papercut.pcng.util.Messages;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nullable;

public final class Formatter {
    private static final DateTimeFormatterRegistry DATE_FORMATTER_REGISTER = DateTimeFormatterRegistry.getInstance();

    private Formatter() {
    }

    public static String formatISODate(@Nullable Date date) {
        return date != null ? Formatter.formatDateOfPattern(date, "yyyy-MM-dd") : "";
    }

    public static String formatISODateAndTime(@Nullable Date date) {
        return date != null ? Formatter.formatDateOfPattern(date, "yyyy-MM-dd HH:mm:ss") : "";
    }

    public static String formatISO8601BasicDateTime(@Nullable Date date) {
        return date != null ? Formatter.formatDateOfPattern(date, "yyyyMMdd'T'HHmmss") : "";
    }

    public static String formatStandardDateTime(@Nullable Date date, @Nullable Locale locale) {
        return date != null ? DATE_FORMATTER_REGISTER.getLocalizedDateTimeFormatter(FormatStyle.MEDIUM, FormatStyle.MEDIUM, Formatter.resolveMandatoryLocale(locale)).format(Formatter.toLocalDateTime(date)) : "";
    }

    public static String formatStandardDateTime(@Nullable Date date) {
        return Formatter.formatStandardDateTime(date, Locale.ROOT);
    }

    public static String formatStandardDate(@Nullable Date date, @Nullable Locale locale) {
        return date != null ? DATE_FORMATTER_REGISTER.getDateOnlyFormatter(FormatStyle.MEDIUM, Formatter.resolveMandatoryLocale(locale)).format(Formatter.toLocalDateTime(date)) : "";
    }

    public static String formatStandardDate(@Nullable Date date) {
        return Formatter.formatStandardDate(date, Locale.ROOT);
    }

    public static String formatStandardTime(@Nullable Date date, @Nullable Locale locale) {
        return date != null ? DATE_FORMATTER_REGISTER.getTimeOnlyFormatter(FormatStyle.MEDIUM, Formatter.resolveMandatoryLocale(locale)).format(Formatter.toLocalDateTime(date)) : "";
    }

    public static String formatTime(@Nullable Date date, @Nullable Locale locale) {
        return date != null ? DATE_FORMATTER_REGISTER.getPatternDateTimeFormatter("H:mm:ss", Formatter.resolveMandatoryLocale(locale)).format(Formatter.toLocalDateTime(date)) : "";
    }

    public static String formatTime(@Nullable Date date) {
        return Formatter.formatTime(date, Locale.ROOT);
    }

    public static String formatTimeHM(@Nullable Date date, @Nullable Locale locale) {
        return date != null ? DATE_FORMATTER_REGISTER.getPatternDateTimeFormatter("H:mm", Formatter.resolveMandatoryLocale(locale)).format(Formatter.toLocalDateTime(date)) : "";
    }

    private static Locale resolveMandatoryLocale(@Nullable Locale locale) {
        return locale != null ? locale : Locale.getDefault();
    }

    public static String formatDateTimeFilename(@Nullable Date date) {
        if (date == null) {
            return "";
        }
        return Formatter.formatDateOfPattern(date, "yyyy-MM-dd-HH-mm-ss");
    }

    public static String formatNumber(double value, int fractionDigits, @Nullable Locale locale) {
        return Formatter.getNumberFormat(fractionDigits, locale).format(value);
    }

    public static NumberFormat getNumberFormat(int fractionDigits, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberFormat(locale);
        if (fractionDigits >= 0) {
            format.setMaximumFractionDigits(fractionDigits);
            format.setMinimumFractionDigits(fractionDigits);
        }
        return format;
    }

    public static String formatCurrency(double value, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberCurrencyFormat(locale);
        return format.format(value);
    }

    public static String formatPercentage(double value, int fractionDigits, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberPercentageFormat(locale);
        format.setMaximumFractionDigits(fractionDigits);
        format.setMinimumFractionDigits(fractionDigits);
        return format.format(value);
    }

    public static double parseDouble(String value, @Nullable Locale locale) {
        Number number;
        try {
            number = Formatter.getNumberFormat(locale).parse(value);
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getLocalizedMessage());
        }
        return number.doubleValue();
    }

    public static double parsePercentage(String value, @Nullable Locale locale) {
        Number number;
        try {
            number = Formatter.getNumberPercentageFormat(locale).parse(value);
        }
        catch (ParseException e) {
            return Formatter.parseDouble(value, locale) / 100.0;
        }
        return number.doubleValue();
    }

    public static String formatInteger(int value, @Nullable Locale locale) {
        return Formatter.formatInteger(value, 1, locale);
    }

    public static String formatInteger(int value, int minimumIntDigits, @Nullable Locale locale) {
        return Formatter.formatWithLocale(value, minimumIntDigits, locale);
    }

    public static String formatLong(long value, @Nullable Locale locale) {
        return Formatter.formatLong(value, 1, locale);
    }

    public static String formatLong(long value, int minimumIntDigits, @Nullable Locale locale) {
        return Formatter.formatWithLocale(value, minimumIntDigits, locale);
    }

    static String formatWithLocale(long value, int minimumIntDigits, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberFormat(locale);
        format.setMaximumFractionDigits(0);
        format.setMinimumIntegerDigits(minimumIntDigits);
        return format.format(value);
    }

    public static String formatHours(double hours, @Nullable Locale locale) {
        int minsPerHour = 60;
        int hoursInt = (int)hours;
        int minsInt = (int)Math.round((hours - (double)hoursInt) * 60.0);
        return Formatter.formatInteger(hoursInt, locale) + ":" + Formatter.formatInteger(minsInt, 2, locale);
    }

    public static String formatMegabytes(double mb, @Nullable Locale locale) {
        return Formatter.formatNumber(mb, 2, locale);
    }

    public static String formatBooleanYesNo(boolean value, @Nullable Locale locale) {
        return Messages.getString(Formatter.class, locale, value ? "yes" : "no", new String[0]);
    }

    @Nullable
    public static String stripNonNumeric(@Nullable String str) {
        int end;
        int start;
        int strLen;
        String allowedChars = "-+0123456789.";
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        for (start = 0; start != strLen && allowedChars.indexOf(str.charAt(start)) < 0; ++start) {
        }
        for (end = strLen; end >= start && allowedChars.indexOf(str.charAt(end - 1)) < 0; --end) {
        }
        return str.substring(start, end);
    }

    private static NumberFormat getNumberFormat(@Nullable Locale locale) {
        if (locale == null) {
            return NumberFormat.getInstance();
        }
        return NumberFormat.getInstance(locale);
    }

    private static NumberFormat getNumberPercentageFormat(@Nullable Locale locale) {
        if (locale == null) {
            return NumberFormat.getPercentInstance();
        }
        return NumberFormat.getPercentInstance(locale);
    }

    private static NumberFormat getNumberCurrencyFormat(@Nullable Locale locale) {
        if (locale == null) {
            return NumberFormat.getCurrencyInstance();
        }
        return NumberFormat.getCurrencyInstance(locale);
    }

    public static String formatZonedISODate(Date date, @Nullable TimeZone optionalTimezone) {
        if (date == null) {
            throw new IllegalArgumentException("Date to format must not be null");
        }
        TimeZone formatTimeZone = optionalTimezone != null ? optionalTimezone : TimeZone.getDefault();
        return DATE_FORMATTER_REGISTER.getPatternDateTimeFormatter("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ROOT).format(date.toInstant().atZone(formatTimeZone.toZoneId()));
    }

    public static String formatDateOfPattern(Date date, String pattern) {
        if (date == null) {
            throw new IllegalArgumentException("Date to format must not be null");
        }
        if (pattern == null) {
            throw new IllegalArgumentException("Format pattern must not be null");
        }
        return DATE_FORMATTER_REGISTER.getPatternDateTimeFormatter(pattern, Locale.ROOT).format(Formatter.toLocalDateTime(date));
    }

    public static String formatCurrentDateTimeOfPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Format pattern must not be null");
        }
        return DATE_FORMATTER_REGISTER.getPatternDateTimeFormatter(pattern, Locale.ROOT).format(LocalDateTime.now());
    }

    public static String formatDateForScheduledReport(LocalDate localDate) {
        if (localDate == null) {
            throw new IllegalArgumentException("Date to format must not be null");
        }
        return DATE_FORMATTER_REGISTER.getPatternDateTimeFormatter("MMM dd, yyyy", Locale.ROOT).format(localDate);
    }

    public static String formatDateOfFormatStyle(Date date, FormatStyle formatStyle, @Nullable Locale optionalLocale) {
        if (date == null) {
            throw new IllegalArgumentException("Date to format must not be null");
        }
        if (formatStyle == null) {
            throw new IllegalArgumentException("Format style must not be null");
        }
        Locale formatLocale = optionalLocale != null ? optionalLocale : Locale.ROOT;
        return DATE_FORMATTER_REGISTER.getDateOnlyFormatter(formatStyle, formatLocale).format(Formatter.toLocalDateTime(date));
    }

    private static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}

