/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthDialog;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.common.ClientAuthResponse;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthHandler
implements ClientController.AuthenticationEventListener {
    private static final Logger logger = LoggerFactory.getLogger(AuthHandler.class);
    private final ServerConnection _serverConnection;
    private final UserClientConfig _config;
    private final UserClientFrame _userClientFrame;

    public AuthHandler(UserClientFrame userClientFrame, ServerConnection serverConnection, UserClientConfig clientConfig) {
        this._serverConnection = serverConnection;
        this._config = clientConfig;
        this._userClientFrame = userClientFrame;
    }

    @Override
    public void newAuthenticationRequest() {
        try {
            SwingUtilities.invokeAndWait(this::doAuthRequest);
        }
        catch (Throwable t) {
            logger.error("Error displaying auth dialog. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAuthRequest() {
        try {
            logger.debug("Processing an authentication request");
            String savedAuthCookie = ClientConfigFile.loadUserAuthCookie();
            if (StringUtils.isNotBlank((String)savedAuthCookie)) {
                ClientAuthResponse r;
                try {
                    r = this._serverConnection.authenticateUserWithCookie(savedAuthCookie);
                }
                catch (Exception e) {
                    logger.error("Unable to authenticate with user cookie. Fall back to normal auth.{}", (Object)e.getMessage(), (Object)e);
                    r = ClientAuthResponse.newFail((String)e.getMessage());
                }
                if (r.isSuccess()) {
                    logger.debug("Successfully authenticated with cookie.");
                    this._config.loginUser(r.getRealName());
                    this._userClientFrame.updateDisplay();
                    return;
                }
                logger.debug("Failed to authenticate with cookie. Clear cookie and display auth dialog. Error: {}", (Object)r.getErrorMessage());
                ClientConfigFile.deleteUserAuthCookie();
            }
            this._userClientFrame.setPopupDialogIsDisplayed(true);
            AuthDialog d = new AuthDialog(this._userClientFrame, this._config, this._serverConnection);
            d.setAlwaysOnTop(true);
            d.setVisible(true);
            d.setAlwaysOnTop(false);
            d.dispose();
        }
        catch (Throwable t) {
            logger.error("Error displaying auth dialog. {}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            this._userClientFrame.setPopupDialogIsDisplayed(false);
        }
    }

    @Override
    public void authenticationExpired() {
        try {
            this._config.logoutUser();
            this._userClientFrame.updateDisplay();
        }
        catch (Exception e) {
            logger.error("Error processing expire auth request", (Throwable)e);
        }
    }
}

