/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthDialog;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.WinSecur32Utils;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.swing.DialogBannerPanel;
import biz.papercut.pcng.util.swing.DialogUtils;
import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserClientUtils {
    private static final Logger logger = LoggerFactory.getLogger(UserClientUtils.class);
    private static final String PROP_CLIENT_HOME = "client.home";
    private static final String CUSTOM_IMAGE_NAME = "client-logo.png";
    private static final int CHECK_MFA_STATUS_INTERVAL_IN_SECONDS = 2;
    private static final int CHECK_MFA_STATUS_MAX_RETRIES = 150;
    private static boolean _hasCheckedForCustomImage;
    private static URL _customImageUrl;

    private UserClientUtils() {
    }

    public static String getHomeDirectory() {
        String home = System.getProperty(PROP_CLIENT_HOME);
        if (home != null) {
            File homeDir = new File(home);
            logger.debug("Testing home directory: {}", (Object)home);
            if (homeDir.exists() && homeDir.isDirectory()) {
                home = homeDir.getAbsolutePath();
            } else {
                logger.warn("Specified client.home does not exist, using current dir.");
                home = new File("").getAbsolutePath();
            }
        }
        if (home == null) {
            logger.debug("client.home null, using current directory as home directory");
            home = new File("").getAbsolutePath();
        }
        logger.debug("Using home directory: {}", (Object)home);
        return home;
    }

    @Nullable
    public static URL getCustomIconImage() {
        if (!_hasCheckedForCustomImage) {
            logger.debug("Checking for custom icon image");
            UserClientUtils.setCustomIconImage(null);
        }
        return _customImageUrl;
    }

    public static void setCustomIconImage(@Nullable String customLogoUrl) {
        logger.debug("Set custom icon image for : {}", (Object)customLogoUrl);
        try {
            if (customLogoUrl != null) {
                _customImageUrl = new URL(customLogoUrl);
            } else {
                File f = new File(UserClientUtils.getHomeDirectory(), CUSTOM_IMAGE_NAME);
                if (f.exists()) {
                    _customImageUrl = f.toURI().toURL();
                }
            }
        }
        catch (Exception e) {
            logger.debug("Unable to locate custom icon", (Throwable)e);
        }
        _hasCheckedForCustomImage = true;
    }

    public static DialogBannerPanel getStandardDialogBanner(String title, String description, ClientGlobalConfigFromServer conf) {
        Image scaledImage;
        ImageIcon orig;
        ImageIcon icon = null;
        URL customIcon = UserClientUtils.getCustomIconImage();
        if (customIcon != null) {
            try {
                orig = new ImageIcon(customIcon);
                scaledImage = orig.getImage().getScaledInstance(48, 48, 4);
                icon = new ImageIcon(scaledImage);
            }
            catch (Exception e) {
                logger.debug("Unable to load custom icon: {}", (Object)e.getMessage());
            }
        }
        if (icon == null) {
            orig = new ImageIcon(UserClientUtils.class.getResource("images/client-icon.png"));
            scaledImage = orig.getImage().getScaledInstance(48, 48, 4);
            icon = new ImageIcon(scaledImage);
        }
        return new DialogBannerPanel(title, description, icon, conf.isShowLink(), conf.getLinkURL(), conf.getLinkText());
    }

    public static ImageIcon createRetinaImageIcon(URL imgURL) {
        if (imgURL != null) {
            return new ScalableIcon(imgURL, 0.5, 0.5);
        }
        logger.debug("Unable to load refresh image");
        return null;
    }

    public static boolean hasRetinaDisplay() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            try {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice device = env.getDefaultScreenDevice();
                Field field = device.getClass().getDeclaredField("scale");
                if (field != null) {
                    field.setAccessible(true);
                    Object scale = field.get(device);
                    if (scale instanceof Integer && (Integer)scale == 2) {
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean enforceHigherSec(ServerConnection connection, UserClientConfig config, String username, boolean isTest) {
        ClientGlobalConfigFromServer configFromServer = connection.getGlobalConfig();
        int sslPort = configFromServer.getSslPort();
        if (sslPort > 0) {
            config.setServerPort(sslPort);
            config.getServerGlobalConfig().setUseSslInBrowser(true);
            ClientConfigFile.saveServerPortToUserLevelConfig(String.valueOf(sslPort));
            connection = UserClientUtils.getNewServerConnection(config, username, isTest);
            connection.trySecureConnection();
            return true;
        }
        logger.debug("No valid SSL port in configs. Cannot proceed with MFA");
        return false;
    }

    public static ServerConnection getNewServerConnection(UserClientConfig conf, String username, boolean isTest) {
        if (isTest) {
            return new ServerConnection("testHost", "127.0.0.1", 9191, false);
        }
        ServerConnection newConnection = new ServerConnection(conf.getServerName(), conf.getServerIP(), conf.getServerPort(), conf.getTimeoutSecs(), false, conf.isUseStrictSSLVerification());
        if (StringUtils.isNotBlank((String)username)) {
            newConnection.setUserName(username);
        }
        return newConnection;
    }

    public static boolean browseUrlInOS(String extAuthUrl) {
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(new URI(extAuthUrl));
                    return true;
                }
                catch (URISyntaxException e) {
                    logger.error("Could not form legit URI with \"{}\": {}", (Object)extAuthUrl, (Object)e.getMessage());
                }
                catch (IOException e) {
                    logger.error("Error launching browser: {}", (Object)e.getMessage());
                }
            }
            logger.debug("This desktop does not support browsing");
        }
        logger.debug("Desktop is not supported");
        return false;
    }

    public static ClientAuthResponse pollServerForMfaStatus(ClientAuthResponse originalResponse, ServerConnection connection, String inputUsername, JDialog parent, @Nullable Integer ttl) {
        ClientAuthResponse mfaOutcome = null;
        String username = inputUsername;
        int retries = 0;
        if (StringUtils.isNotBlank((String)originalResponse.getRealName())) {
            username = originalResponse.getRealName();
        }
        while (retries < 150) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                logger.error("Interrupted while pollling for MFA status", (Throwable)e);
            }
            ++retries;
            mfaOutcome = UserClientUtils.getMfaStatus(username, connection, ttl);
            if (mfaOutcome == null) continue;
        }
        logger.debug("AuthDialog: MFA process complete.");
        String MFA_PREFIX = "MFA.";
        if (mfaOutcome == null) {
            logger.debug("MFA failed after checking with app server for a maximum of {} times", (Object)150);
            int timeoutInMinutes = 5;
            DialogUtils.showInformationMessageDialog((Component)parent, (String)UserClientUtils.format("MFA.", "error", new String[0]), (String)UserClientUtils.format("MFA.", "failed-after-max-retries", String.valueOf(timeoutInMinutes)));
            return null;
        }
        if (!mfaOutcome.isSuccess()) {
            logger.debug("Received MFA outcome: it failed. Reason: {}", (Object)mfaOutcome.getErrorMessage());
            DialogUtils.showInformationMessageDialog((Component)parent, (String)UserClientUtils.format("MFA.", "error", new String[0]), (String)(StringUtils.isNotBlank((String)mfaOutcome.getErrorMessage()) ? mfaOutcome.getErrorMessage() : "dummy"));
            return null;
        }
        return mfaOutcome;
    }

    private static String format(String prefix, String key, String ... args) {
        String fullKey = prefix + key;
        return Messages.getString(AuthDialog.class, fullKey, args);
    }

    private static ClientAuthResponse getMfaStatus(String username, ServerConnection connection, @Nullable Integer ttl) {
        if (ttl != null) {
            return connection.authenticateUserViaMfa(username, ttl);
        }
        return connection.checkIdentityViaMfa(username);
    }

    public static String getWindowsUserUpn(String samCompatibleUsername) {
        if (!SystemUtils.IS_OS_WINDOWS) {
            logger.debug("Non-Windows OS, OS-level username returned unchanged");
            return samCompatibleUsername;
        }
        int bufferSize = 512;
        char[] charBuffer = new char[512];
        IntByReference size = new IntByReference(512);
        try {
            boolean result = WinSecur32Utils.INSTANCE.GetUserNameEx(8, charBuffer, size);
            if (!result) {
                int error = Native.getLastError();
                logger.debug("Failed to retrieve UPN of current logged-in user, error code {}", (Object)error);
                throw new ApplicationException("Cannot get UPN for logged in user");
            }
            String upn = new String(charBuffer, 0, size.getValue());
            logger.debug("Found user UPN: {}", (Object)upn);
            return upn;
        }
        catch (Throwable e) {
            int error = Native.getLastError();
            logger.debug("Error while trying to get UPN. Last error code was: {}", (Object)error);
            throw new ApplicationException("Error occurred while trying to get logged-in user's UPN: " + e.getMessage() + " The last error code was " + error);
        }
    }

    private static class ScalableIcon
    extends ImageIcon {
        private static final long serialVersionUID = -8924613592985700330L;
        private final double sx;
        private final double sy;

        public ScalableIcon(URL iconUrl, double sx, double sy) {
            super(iconUrl);
            this.sx = sx;
            this.sy = sy;
        }

        @Override
        public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.getImageObserver() == null) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.scale(this.sx, this.sy);
                g.drawImage(this.getImage(), x, y, c);
            } else {
                Graphics2D g2d = (Graphics2D)g;
                g2d.scale(this.sx, this.sy);
                g.drawImage(this.getImage(), x, y, this.getImageObserver());
            }
        }
    }
}

