/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.CustomMessagePrintDialog;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ChoiceDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.ChoiceDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import biz.papercut.pcng.util.swing.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public class CustomChoicePrintDialog
extends CustomMessagePrintDialog {
    private final JComboBox<String> _comboBox;
    private final DefaultComboBoxModel<String> _model = new DefaultComboBoxModel();

    public static CustomMessagePrintDialog construct(JFrame owner, ChoiceDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        CustomChoicePrintDialog d = new CustomChoicePrintDialog(owner, request, job, conn, config);
        d.initializeChoiceDialog();
        return d;
    }

    protected CustomChoicePrintDialog(JFrame owner, ChoiceDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        super(owner, (MessageDialogRequest)request, job, conn, config);
        this._comboBox = new JComboBox<String>(this._model);
    }

    @Override
    protected JPanel constructMainPanel() {
        JPanel messagePanel = super.constructMainPanel();
        ChoiceDialogRequest request = (ChoiceDialogRequest)this._request;
        String textLabel = request.getFieldLabel();
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 20));
        if (StringUtils.isNotBlank((String)textLabel)) {
            textPanel.add((Component)new JLabel(textLabel), "West");
        }
        JPanel fieldPanel = new JPanel(new BorderLayout());
        if (StringUtils.isNotBlank((String)textLabel)) {
            fieldPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        }
        fieldPanel.add(this._comboBox, "Center");
        textPanel.add((Component)fieldPanel, "Center");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)messagePanel, "Center");
        p.add((Component)textPanel, "South");
        return p;
    }

    public void initializeChoiceDialog() {
        this.initializeMessageDialog();
        ChoiceDialogRequest req = (ChoiceDialogRequest)this._request;
        String defaultChoice = req.getDefaultChoice();
        Vector choices = req.getChoices();
        for (String choice : choices) {
            this._model.addElement(choice);
        }
        this._comboBox.requestFocus();
        if (!defaultChoice.isEmpty() && choices.contains(defaultChoice)) {
            this._comboBox.setSelectedItem(defaultChoice);
        } else {
            this._model.insertElementAt("", 0);
            this._comboBox.setSelectedIndex(0);
        }
    }

    @Override
    protected boolean handleWindowClosing(WindowEvent e) {
        this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new ChoiceDialogResponse("CANCEL", (String)this._comboBox.getSelectedItem()));
        return true;
    }

    @Override
    protected boolean handleButtonPress(String button) {
        String text = (String)this._comboBox.getSelectedItem();
        if (!"CANCEL".equalsIgnoreCase(button) && StringUtils.isBlank((String)text)) {
            DialogUtils.showInformationMessageDialog((Component)this, (String)Messages.getString(this.getClass(), "SelectAccount.error", new String[0]), (String)Messages.getString(this.getClass(), "CustomChoicePrintDialog.select-item", new String[0]));
            return false;
        }
        this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new ChoiceDialogResponse(button, (String)this._comboBox.getSelectedItem()));
        return true;
    }
}

