/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.util.ApplicationInfo;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MacUtils {
    private static final String CLIENT_APP_NAME = "PCClient";
    private static final Logger logger = LoggerFactory.getLogger(MacUtils.class);

    private MacUtils() {
    }

    static boolean growlNotify(String message) {
        try {
            int bytes;
            logger.debug("trying growl ...");
            Process growlNotify = Runtime.getRuntime().exec("./growlnotify --image client-icon.icns  -n PCClient " + ApplicationInfo.getInstance().getApplicationName());
            try (OutputStreamWriter output = new OutputStreamWriter(growlNotify.getOutputStream(), StandardCharsets.UTF_8);){
                output.write(message);
            }
            try (InputStreamReader error = new InputStreamReader(growlNotify.getErrorStream(), StandardCharsets.UTF_8);){
                bytes = ((Reader)error).read();
            }
            logger.debug("growlnotify stderr read returned: {}", (Object)bytes);
            int exitValue = growlNotify.waitFor();
            logger.debug("growlnotify exit value: {}", (Object)exitValue);
            boolean success = exitValue == 0 && bytes < 0;
            logger.debug("growlnotify success: {}", (Object)success);
            return success;
        }
        catch (IOException e) {
            logger.info("Error running growlnotify: {}", (Object)e.getMessage(), (Object)e);
        }
        catch (InterruptedException e) {
            logger.error("growlNotify waitFor interrupted", (Throwable)e);
        }
        return false;
    }
}

