/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public final class LocaleUtils {
    public static String MAORI = "mi";

    private LocaleUtils() {
    }

    @Nullable
    public static Locale getLocaleFromString(String loc) {
        Locale[] locales;
        if (loc.contains("-")) {
            return Locale.forLanguageTag(loc);
        }
        for (Locale locale : locales = LocaleUtils.getAvailableDisplayLocales()) {
            if (!locale.toString().equalsIgnoreCase(loc)) continue;
            return locale;
        }
        if ("eu_ES".equalsIgnoreCase(loc)) {
            return new Locale("eu", "ES");
        }
        if ("gl_ES".equalsIgnoreCase(loc)) {
            return new Locale("gl", "ES");
        }
        if ("cy_GB".equalsIgnoreCase(loc) || "cy".equalsIgnoreCase(loc)) {
            return new Locale("cy", "GB");
        }
        if ("mi".equalsIgnoreCase(loc)) {
            return new Locale(MAORI);
        }
        if ("iw".equalsIgnoreCase(loc)) {
            return new Locale("he");
        }
        return null;
    }

    public static Locale[] getAvailableDisplayLocales() {
        return (Locale[])Arrays.stream(Locale.getAvailableLocales()).filter(locale -> !locale.equals(Locale.ROOT)).toArray(Locale[]::new);
    }

    public static List<Locale> getLocaleListFromString(String values) {
        ArrayList<Locale> l = new ArrayList<Locale>();
        if (StringUtils.isNotEmpty((String)values)) {
            String[] additional;
            for (String s : additional = values.split("\\s*,\\s*")) {
                Locale loc = LocaleUtils.getLocaleFromString(s);
                if (loc == null) continue;
                l.add(loc);
            }
        }
        return l;
    }

    @Nullable
    public static String upperCaseUSLocale(@Nullable String s) {
        return s != null ? s.toUpperCase(Locale.US) : null;
    }

    @Nullable
    public static String lowerCaseUSLocale(@Nullable String s) {
        return s != null ? s.toLowerCase(Locale.US) : null;
    }

    public static Locale fixRegionlessAndNonGregorianLocale(@Nonnull Locale locale) {
        return LocaleUtils.forceGregorianCalendar(LocaleUtils.fixRegionlessLocale(locale));
    }

    public static Locale fixRegionlessLocale(@Nonnull Locale locale) {
        if (!LocaleUtils.isRegionlessLocale(locale)) {
            return locale;
        }
        return switch (locale.getLanguage()) {
            case "en" -> Locale.US;
            case "th" -> Locale.forLanguageTag("th-TH");
            case "ja" -> Locale.JAPAN;
            case "shi" -> Locale.forLanguageTag("shi-MA");
            case "az" -> Locale.forLanguageTag("az-AZ");
            case "su" -> Locale.forLanguageTag("su-ID");
            case "be" -> Locale.forLanguageTag("be-BY");
            case "vai" -> Locale.forLanguageTag("vai-LR");
            case "sd" -> Locale.forLanguageTag("sd-PK");
            case "hi" -> Locale.forLanguageTag("hi-IN");
            case "mni" -> Locale.forLanguageTag("mni-IN");
            case "ks" -> Locale.forLanguageTag("ks-IN");
            case "sat" -> Locale.forLanguageTag("sat-IN");
            case "el" -> Locale.forLanguageTag("el-GR");
            default -> Arrays.stream(LocaleUtils.getAvailableDisplayLocales()).filter(l -> l.getLanguage().equals(locale.getLanguage())).filter(l -> !l.equals(locale)).findFirst().orElse(locale);
        };
    }

    static Locale forceGregorianCalendar(@Nonnull Locale locale) {
        if (LocaleUtils.isLocaleUsingNonGregorianCalendar(locale)) {
            return new Locale.Builder().setLocale(locale).setExtension('u', "ca-gregory").build();
        }
        return locale;
    }

    public static boolean isSystemLocaleUsingNonGregorianCalendar() {
        return Calendar.getInstance().getClass() != GregorianCalendar.class;
    }

    public static boolean isLocaleUsingNonGregorianCalendar(@Nonnull Locale locale) {
        return Calendar.getInstance(locale).getClass() != GregorianCalendar.class;
    }

    public static boolean isRegionlessLocale(@Nonnull Locale locale) {
        return locale.getCountry().isEmpty();
    }
}

