/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Messages {
    private static final Logger logger = LoggerFactory.getLogger(Messages.class);
    private static final String MESSAGE_FILE_NAME = "messages";
    private static final Locale NO_LANGUAGE_HACK_LOCALE = new Locale("");

    private Messages() {
    }

    public static ResourceBundle loadBundle(Class<?> clazz, @Nullable Locale locale) {
        String bundleName = clazz.getPackage().getName() + ".messages";
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ("en".equalsIgnoreCase(locale.getLanguage())) {
            locale = NO_LANGUAGE_HACK_LOCALE;
        }
        return ResourceBundle.getBundle(bundleName, locale, clazz.getClassLoader());
    }

    public static String getString(Class<?> clazz, @Nullable Locale locale, String key, String ... args) {
        try {
            String pattern = Messages.loadStringFromBundle(clazz, locale, key);
            return Messages.applyFormatting(locale, key, pattern, args);
        }
        catch (MissingResourceException e) {
            logger.warn("Could not find message for key: {}, error: {}", (Object)key, (Object)e.getMessage());
            return Messages.formatUnknownString(key);
        }
    }

    @Nullable
    public static String getOptString(Class<?> clazz, @Nullable Locale locale, String key, String ... args) {
        try {
            String pattern = Messages.loadOptStringFromBundle(clazz, locale, key);
            return pattern != null ? Messages.applyFormatting(locale, key, pattern, args) : null;
        }
        catch (MissingResourceException e) {
            return Messages.formatUnknownString(key);
        }
    }

    private static String applyFormatting(@Nullable Locale locale, String key, String pattern, @Nullable String[] args) {
        if (args == null || args.length == 0) {
            return pattern;
        }
        try {
            return MessageFormat.format(pattern, args);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Error parsing message: {} Locale: {} Err: {}", new Object[]{pattern, locale, iae.getMessage()});
            return Messages.formatUnknownString(key);
        }
    }

    public static String getHtmlString(Class<?> clazz, Locale locale, String key, String ... args) {
        return StringEscapeUtils.escapeHtml((String)Messages.getString(clazz, locale, key, args));
    }

    public static String getXmlString(Class<?> clazz, Locale locale, String key, String ... args) {
        return StringEscapeUtils.escapeXml((String)Messages.getString(clazz, locale, key, args));
    }

    public static String getString(Class<?> clazz, String key, String ... args) {
        return Messages.getString(clazz, null, key, args);
    }

    @Nullable
    public static String getOptString(Class<?> clazz, String key, String ... args) {
        return Messages.getOptString(clazz, null, key, args);
    }

    private static String loadStringFromBundle(Class<?> clazz, @Nullable Locale locale, String key) {
        return Messages.loadBundle(clazz, locale).getString(key);
    }

    @Nullable
    private static String loadOptStringFromBundle(Class<?> clazz, @Nullable Locale locale, String key) {
        ResourceBundle rb = Messages.loadBundle(clazz, locale);
        return rb.containsKey(key) ? rb.getString(key) : null;
    }

    private static String formatUnknownString(String key) {
        return "!" + key + "!";
    }
}

