/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.io;

import biz.papercut.pcng.util.io.LineHandler;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtils {
    private static final Logger logger = LoggerFactory.getLogger(IOUtils.class);
    private static final int BUFFER_SIZE = 4096;
    private static final char EXT_SEPARATION = '.';
    private static final Pattern FILENAME_SUFFIX = Pattern.compile("^_\\d{4}\\..*");
    private static final int MAXIMUM_NO_OVERWRITE_FILES = 10000;
    private static final Pattern FILE_PATH_DISALLOWED_CHARS = Pattern.compile("[\\Q\\/:*?\"<>|\\E]");
    public static final int DEFAULT_MAX_FILE_NAME_LENGTH = 200;

    private IOUtils() {
    }

    public static long getFreeSpace(String dir) {
        Method m;
        File dirFile = new File(dir);
        if (!dirFile.isDirectory()) {
            logger.debug("Cannot determine free space. '{}' is not a directory.", (Object)dir);
            return -1L;
        }
        try {
            m = File.class.getMethod("getFreeSpace", new Class[0]);
        }
        catch (Exception e) {
            logger.debug("No free space method, probably non-1.6 VM. {}", (Object)e.getMessage());
            return -1L;
        }
        try {
            return (Long)m.invoke((Object)dirFile, new Object[0]);
        }
        catch (Exception e) {
            logger.debug("Error determining free space: {}", (Object)e.getMessage(), (Object)e);
            return -1L;
        }
    }

    public static void copy(InputStream input, OutputStream output, boolean closeWhenExhausted) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        if (closeWhenExhausted) {
            try {
                output.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void copy(Reader input, Writer output, boolean closeWhenExhausted) throws IOException {
        int n;
        char[] buffer = new char[4096];
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
        if (closeWhenExhausted) {
            IOUtils.closeQuietly(output);
        }
    }

    public static void copyLines(Reader input, LineHandler lineHandler) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(input);
        while (null != (line = reader.readLine())) {
            lineHandler.handleLine(line);
        }
    }

    public static void closeQuietly(@Nullable InputStream s) {
        org.apache.commons.io.IOUtils.closeQuietly((InputStream)s);
    }

    public static void closeQuietly(@Nullable OutputStream s) {
        org.apache.commons.io.IOUtils.closeQuietly((OutputStream)s);
    }

    public static void closeQuietly(@Nullable Reader r) {
        org.apache.commons.io.IOUtils.closeQuietly((Reader)r);
    }

    public static void closeQuietly(Writer w) {
        org.apache.commons.io.IOUtils.closeQuietly((Writer)w);
    }

    public static void closeQuietly(@Nullable Socket s) {
        org.apache.commons.io.IOUtils.closeQuietly((Socket)s);
    }

    public static void closeQuietly(@Nullable ServerSocket s) {
        org.apache.commons.io.IOUtils.closeQuietly((ServerSocket)s);
    }

    public static void copyFile(File src, File dest) throws IOException {
        try (FileInputStream in = new FileInputStream(src);
             FileOutputStream out = new FileOutputStream(dest);){
            int len;
            byte[] buf = new byte[4096];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
    }

    public static void testCopyFile(File src, File dest) throws IOException {
        if (dest.exists()) {
            throw new IOException(new IllegalArgumentException("Test copy failed, destination file already exists: " + dest.getAbsolutePath()));
        }
        IOUtils.copyFile(src, dest);
        if (!dest.delete()) {
            logger.debug("Unable to delete file during test copying: {}", (Object)dest.getPath());
        }
    }

    public static String copyFileNoOverwrite(File src, File dest) throws IOException {
        int finalExtIndex;
        File destDirectory;
        String[] sequencedFiles;
        Preconditions.checkNotNull((Object)src, (Object)"Source file is null");
        Preconditions.checkNotNull((Object)dest, (Object)"Destination file is null");
        String origFileName = dest.getName();
        int extIndex = origFileName.lastIndexOf(46);
        if (extIndex <= 0) {
            extIndex = origFileName.length();
        }
        String origExtension = origFileName.substring(extIndex);
        int pathSepIndex = origFileName.lastIndexOf(File.separatorChar);
        String origFileNameNoExtension = extIndex >= pathSepIndex ? origFileName.substring(0, extIndex) : origFileName;
        boolean isExists = dest.exists();
        if (isExists && (sequencedFiles = (destDirectory = dest.getParentFile()).list((arg_0, arg_1) -> IOUtils.lambda$copyFileNoOverwrite$0(origFileName, origExtension, finalExtIndex = extIndex, arg_0, arg_1))) != null && sequencedFiles.length > 0) {
            if (sequencedFiles.length >= 10000) {
                throw new IOException("The maximum number of files with prefix " + origFileNameNoExtension + " (10000) has been reached in the directory " + dest.getAbsolutePath());
            }
            int newSequence = sequencedFiles.length;
            String newSequenceStr = "_" + StringUtils.leftPad((String)String.valueOf(newSequence), (int)4, (String)"0");
            String newFileName = origFileNameNoExtension + newSequenceStr + origExtension;
            File newDest = new File(dest.getParentFile(), newFileName);
            IOUtils.copyFile(src, newDest);
            return newFileName;
        }
        IOUtils.copyFile(src, dest);
        return origFileName;
    }

    public static String toString(InputStream input) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input, (Writer)sw);
        return sw.toString();
    }

    public static String toString(InputStream input, String charset) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy(input, (Writer)sw, charset);
        return sw.toString();
    }

    public static void copy(InputStream input, Writer output) throws IOException {
        InputStreamReader in = new InputStreamReader(input);
        IOUtils.copy(in, output);
    }

    public static void copy(InputStream input, Writer output, String charset) throws IOException {
        InputStreamReader in = new InputStreamReader(input, charset);
        IOUtils.copy(in, output);
    }

    public static int copy(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[4096];
        int count = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += n;
        }
        return count;
    }

    public static void closeQuietly(@Nullable ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean deleteRecursive(File file) {
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                IOUtils.deleteRecursive(files[i]);
            }
        }
        return file.delete();
    }

    public static long getFileSize(String fileName) {
        if (StringUtils.isBlank((String)fileName)) {
            throw new IllegalArgumentException("getFileSize() cannot accept a blank filename.");
        }
        File f = new File(fileName);
        if (!f.exists() || !f.isFile()) {
            return -1L;
        }
        return f.length();
    }

    public static void serializeObjectToFile(File saveFile, Serializable obj) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(saveFile);
             ObjectOutputStream oos = new ObjectOutputStream(fos);){
            oos.writeObject(obj);
            oos.flush();
            fos.flush();
        }
    }

    public static Object deserializeObjectFromFile(File loadFile) throws IOException, ClassNotFoundException {
        try (FileInputStream fis = new FileInputStream(loadFile);){
            Object object;
            try (ObjectInputStream ois = new ObjectInputStream(fis);){
                object = ois.readObject();
            }
            return object;
        }
    }

    public static String readFile(File file, Charset charset) throws IOException {
        try (FileInputStream fin = new FileInputStream(file);){
            String string;
            try (InputStreamReader r = new InputStreamReader((InputStream)fin, charset);){
                int charsRead;
                char[] cbuf = new char[2048];
                StringBuilder sb = new StringBuilder(cbuf.length);
                while ((charsRead = r.read(cbuf)) >= 0) {
                    sb.append(cbuf, 0, charsRead);
                }
                string = sb.toString();
            }
            return string;
        }
    }

    public static String sanitiseFileName(@Nullable String fileName, String replacement, int maxLength) {
        if (fileName == null) {
            return "";
        }
        Object modifiedFileName = FILE_PATH_DISALLOWED_CHARS.matcher(fileName).replaceAll(replacement);
        if (maxLength != -1 && ((String)modifiedFileName).length() > maxLength) {
            String extension = "." + StringUtils.substringAfterLast((String)modifiedFileName, (String)".");
            modifiedFileName = StringUtils.left((String)modifiedFileName, (int)(maxLength - extension.length()));
            modifiedFileName = (String)modifiedFileName + extension;
        }
        return modifiedFileName;
    }

    private static /* synthetic */ boolean lambda$copyFileNoOverwrite$0(String origFileName, String origExtension, int finalExtIndex, File dir, String name) {
        String diff = StringUtils.difference((String)origFileName, (String)name);
        return StringUtils.isEmpty((String)diff) || diff.endsWith(origExtension) && StringUtils.indexOfDifference((String)origFileName, (String)name) == finalExtIndex && FILENAME_SUFFIX.matcher(diff).matches();
    }
}

