/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.util.AbstractResponse;
import java.util.Hashtable;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class ClientAuthResponse
extends AbstractResponse {
    private static final String FIELD_SUCCESS = "success";
    private static final String FIELD_ERROR_MSG = "error-msg";
    private static final String FIELD_REALNAME = "realname";
    private static final String FIELD_AUTH_COOKIE = "authCookie";
    private static final String FIELD_MOBILE_RELEASE_ENABLED = "isMobileReleaseEnabled";
    private static final String FIELD_REMEMBER_ME_ENABLED = "rememberMeEnabled";
    private static final String FIELD_MFA_REQUIRED = "mfaRequired";
    private static final String FIELD_EXT_AUTH_URL = "extAuthUrl";
    private static final String FIELD_SESSION_TOKEN = "sessionToken";
    private String _realName;
    private String _authCookie;
    private final boolean _mobileReleaseEnabled;
    private final boolean _rememberMeEnabled;
    private boolean _mfaRequired;
    private String _extAuthUrl;
    private String _sessionToken = "";

    private ClientAuthResponse(boolean success, String realName, String authCookie, String errorMessage, boolean mobileReleaseEnabled, boolean rememberMeEnabled, boolean mfaRequired, @Nullable String extAuthUrl, @Nullable String sessionToken) {
        super(success, errorMessage);
        this.setRealName(realName);
        this._authCookie = StringUtils.trimToEmpty((String)authCookie);
        this._mobileReleaseEnabled = mobileReleaseEnabled;
        this._rememberMeEnabled = rememberMeEnabled;
        this._mfaRequired = mfaRequired;
        this._extAuthUrl = extAuthUrl;
        this._sessionToken = success ? StringUtils.trimToEmpty((String)sessionToken) : "";
    }

    public static ClientAuthResponse newSuccess(String realName, String authCookie, @Nullable String sessionToken) {
        return new ClientAuthResponse(true, realName, authCookie, "", false, false, false, null, sessionToken);
    }

    public static ClientAuthResponse newSuccess(String realName, String authCookie, boolean mobileReleaseEnabled, boolean rememberMeEnabled) {
        return new ClientAuthResponse(true, realName, authCookie, "", mobileReleaseEnabled, rememberMeEnabled, false, null, null);
    }

    public static ClientAuthResponse newFail(String errorMessage) {
        return new ClientAuthResponse(false, "", "", errorMessage, false, false, false, null, null);
    }

    public static ClientAuthResponse newFail(String errorMessage, boolean rememberMeEnabled) {
        return new ClientAuthResponse(false, "", "", errorMessage, false, rememberMeEnabled, false, null, null);
    }

    public static ClientAuthResponse newMfaFail(String errorMessage, String extAuthUrl) {
        return new ClientAuthResponse(false, "", "", errorMessage, false, false, true, extAuthUrl, null);
    }

    public ClientAuthResponse(Hashtable<String, Object> data) {
        this(false, "", "", "", false, false, false, null, null);
        Boolean isMfaRequired;
        String strValue;
        if (data.isEmpty()) {
            return;
        }
        Boolean isSuccess = (Boolean)data.get(FIELD_SUCCESS);
        if (isSuccess != null) {
            this.setSuccess(isSuccess);
        }
        if ((strValue = (String)data.get(FIELD_ERROR_MSG)) != null) {
            this.setErrorMessage(strValue);
        }
        if ((strValue = (String)data.get(FIELD_REALNAME)) != null) {
            this.setRealName(strValue);
        }
        if ((strValue = (String)data.get(FIELD_AUTH_COOKIE)) != null) {
            this._authCookie = StringUtils.trimToEmpty((String)strValue);
        }
        if ((isMfaRequired = (Boolean)data.get(FIELD_MFA_REQUIRED)) != null) {
            this.setMfaRequired(isMfaRequired);
        }
        if ((strValue = (String)data.get(FIELD_EXT_AUTH_URL)) != null) {
            this.setExtAuthUrl(strValue);
        }
        if ((strValue = (String)data.get(FIELD_SESSION_TOKEN)) != null) {
            this._sessionToken = StringUtils.trimToEmpty((String)strValue);
        }
    }

    public Hashtable<String, Object> saveToHashtable() {
        Hashtable<String, Object> data = new Hashtable<String, Object>(2);
        data.put(FIELD_SUCCESS, this.isSuccess());
        if (!this.isSuccess() && StringUtils.isNotBlank((String)this.getErrorMessage())) {
            data.put(FIELD_ERROR_MSG, this.getErrorMessage());
        }
        data.put(FIELD_REALNAME, this.getRealName());
        if (StringUtils.isNotBlank((String)this.getAuthCookie())) {
            data.put(FIELD_AUTH_COOKIE, this.getAuthCookie());
        }
        if (StringUtils.isNotBlank((String)this.getSessionToken())) {
            data.put(FIELD_SESSION_TOKEN, this.getSessionToken());
        }
        data.put(FIELD_MOBILE_RELEASE_ENABLED, this._mobileReleaseEnabled);
        data.put(FIELD_REMEMBER_ME_ENABLED, this._rememberMeEnabled);
        data.put(FIELD_MFA_REQUIRED, this._mfaRequired);
        data.put(FIELD_EXT_AUTH_URL, this._extAuthUrl == null ? "" : this._extAuthUrl);
        return data;
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(StringUtils.trimToEmpty((String)errorMessage));
    }

    public String getRealName() {
        return this._realName;
    }

    public void setRealName(String realName) {
        this._realName = StringUtils.trimToEmpty((String)realName);
    }

    public final String getAuthCookie() {
        return this._authCookie;
    }

    public final String getSessionToken() {
        return this._sessionToken;
    }

    public boolean isMfaRequired() {
        return this._mfaRequired;
    }

    public void setMfaRequired(boolean mfaRequired) {
        this._mfaRequired = mfaRequired;
    }

    @Nullable
    public String getExtAuthUrl() {
        return this._extAuthUrl;
    }

    public void setExtAuthUrl(String _extAuthUrl) {
        this._extAuthUrl = _extAuthUrl;
    }
}

