/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

import biz.papercut.pcng.util.NumberUtils;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RecentAccountsList {
    private LinkedList<Long> _queue = new LinkedList();
    private final int _maxSize;
    private boolean _changed;

    public RecentAccountsList(int maxSize) {
        this(maxSize, null);
    }

    public RecentAccountsList(int maxSize, String s) {
        this._maxSize = maxSize;
        if (StringUtils.isNotBlank((String)s)) {
            this.loadFromString(s);
        }
    }

    public synchronized void loadFromString(String s) {
        this._queue = new LinkedList<Long>(NumberUtils.splitStringToLongList(s, ','));
        if (this._queue.size() > this._maxSize) {
            this._queue = new LinkedList(this._queue.subList(0, this._maxSize));
        }
        this._changed = false;
    }

    public synchronized void add(long id) {
        if (this._queue.isEmpty() || this._queue.getFirst() != id) {
            this._changed = true;
            this._queue.remove(id);
            this._queue.addFirst(id);
            int oversize = this._queue.size() - this._maxSize;
            if (oversize > 0) {
                for (int i = 0; i < oversize; ++i) {
                    this._queue.removeLast();
                }
            }
        }
    }

    public synchronized List<Long> getRecent() {
        return this._queue;
    }

    public synchronized String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this._queue.size(); ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this._queue.get(i).toString());
        }
        return buf.toString();
    }

    public boolean isChanged() {
        return this._changed;
    }
}

