/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.card;

import biz.papercut.pcng.common.card.CardNumberConverter;

public class AsciiEncodedConverter
implements CardNumberConverter {
    protected AsciiEncodedConverter() {
    }

    @Override
    public String convert(String cardNo) {
        String c;
        if (cardNo.length() < 2) {
            return cardNo;
        }
        if (cardNo.length() % 2 != 0) {
            throw new RuntimeException("Can't be Ascii encoded as not multiple of 2.");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cardNo.length() && !"FF".equals(c = cardNo.substring(i, i + 2).toUpperCase()) && !"00".equals(c); i += 2) {
            int code = Integer.parseInt(c, 16);
            if (code < 32 || code > 126) {
                throw new RuntimeException("Char not in standard ASCII range.");
            }
            sb.append((char)code);
        }
        return sb.toString();
    }
}

