/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.Tainted;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BrowserLinkUtils {
    private static final Logger logger = LoggerFactory.getLogger(BrowserLinkUtils.class);

    private BrowserLinkUtils() {
    }

    public static void openBrowser(@Tainted String url) {
        logger.debug("Open browser: {}", (Object)url);
        if (BrowserLinkUtils.tryOpenBrowserWithJavaDesktop(url)) {
            return;
        }
        if (!SystemUtils.IS_OS_WINDOWS) {
            try {
                BrowserLinkUtils.browse(new URI(url));
            }
            catch (URISyntaxException e) {
                logger.debug("Cannot open URL with Java 'desktop': {}", (Object)e.getMessage(), (Object)e);
            }
        } else {
            BrowserLinkUtils.openBrowserUsingUrlDLL(url);
        }
    }

    private static boolean tryOpenBrowserWithJavaDesktop(String url) {
        Method browseMethod;
        Object desktop;
        try {
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Method isSupportedMethod = desktopClass.getMethod("isDesktopSupported", new Class[0]);
            if (!((Boolean)isSupportedMethod.invoke(null, (Object[])null)).booleanValue()) {
                logger.debug("Java 'desktop' not supported.");
                return false;
            }
            Method getDesktopMethod = desktopClass.getMethod("getDesktop", new Class[0]);
            desktop = getDesktopMethod.invoke(null, (Object[])null);
            browseMethod = desktopClass.getMethod("browse", URI.class);
        }
        catch (Exception e) {
            logger.debug("Java 'desktop' support not available.", (Throwable)e);
            return false;
        }
        try {
            URI uri = new URI(url);
            browseMethod.invoke(desktop, uri);
            return true;
        }
        catch (Exception e) {
            logger.debug("Cannot open URL with Java 'desktop': {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
    }

    private static boolean browse(URI uri) {
        return BrowserLinkUtils.openSystemSpecific(uri.toString()) || BrowserLinkUtils.browseDESKTOP(uri);
    }

    private static boolean openSystemSpecific(String uriAsString) {
        if (SystemUtils.IS_OS_LINUX) {
            if (BrowserLinkUtils.runCommand("kde-open", "%s", uriAsString)) {
                return true;
            }
            if (BrowserLinkUtils.runCommand("gnome-open", "%s", uriAsString)) {
                return true;
            }
            if (BrowserLinkUtils.runCommand("xdg-open", "%s", uriAsString)) {
                return true;
            }
        }
        if (SystemUtils.IS_OS_MAC_OSX && BrowserLinkUtils.runCommand("open", "%s", uriAsString)) {
            return true;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return BrowserLinkUtils.runCommand("explorer", "%s", uriAsString);
        }
        return false;
    }

    private static boolean browseDESKTOP(URI uri) {
        logger.debug("Trying to use Desktop.getDesktop().browse() with {}", (Object)uri);
        try {
            if (!Desktop.isDesktopSupported()) {
                logger.error("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                logger.error("BROWSE is not supported.");
                return false;
            }
            Desktop.getDesktop().browse(uri);
            return true;
        }
        catch (Throwable t) {
            logger.error("Error using desktop browse.", t);
            return false;
        }
    }

    private static boolean runCommand(String command, String args, String file) {
        logger.debug("Trying to exec:\n   cmd = {}\n   args = {}\n   %s = {}", new Object[]{command, args, file});
        String[] parts = BrowserLinkUtils.prepareCommand(command, args, file);
        try {
            Process browserProcess = Runtime.getRuntime().exec(parts);
            return browserProcess != null && browserProcess.isAlive();
        }
        catch (IOException e) {
            logger.error("Error running command.", (Throwable)e);
            return false;
        }
    }

    private static String[] prepareCommand(String command, String args, String file) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(command);
        if (args != null) {
            for (String s : args.split(" ")) {
                s = String.format(s, file);
                parts.add(s.trim());
            }
        }
        return parts.toArray(new String[0]);
    }

    private static void openBrowserUsingUrlDLL(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            logger.error("Cannot invoke browser on invalid URL: {}", (Object)url);
            return;
        }
        Thread launcherThread = new Thread(() -> {
            try {
                logger.debug("Try opening URL with rundll32: {}", (Object)url);
                new ProcessBuilder("rundll32", "url.dll,FileProtocolHandler", url).start();
            }
            catch (IOException e) {
                logger.error("Error opening URL with rundll32: {}", (Object)e.getMessage(), (Object)e);
            }
        });
        launcherThread.start();
    }
}

