/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class IdGenerator {
    private int _nextCounter = 1;
    private final SimpleDateFormat _prefixDateFormat;
    private String _lastPrefix = "";
    private final int _counterDigits;

    public IdGenerator(String prefixFormat, int counterDigits) {
        if (counterDigits <= 0) {
            throw new IllegalArgumentException("counterDigits must be >= 0");
        }
        this._prefixDateFormat = new SimpleDateFormat(prefixFormat, Locale.US);
        this._counterDigits = counterDigits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String nextId() {
        int currentCount;
        SimpleDateFormat simpleDateFormat = this._prefixDateFormat;
        synchronized (simpleDateFormat) {
            String prefix = this._prefixDateFormat.format(new Date());
            if (!this._lastPrefix.equals(prefix)) {
                this._nextCounter = 1;
                this._lastPrefix = prefix;
            }
            currentCount = this._nextCounter++;
        }
        return this._lastPrefix + StringUtils.leftPad((String)String.valueOf(currentCount), (int)this._counterDigits, (char)'0');
    }
}

