/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.util.Collections;
import java.util.List;

public final class ListUtils {
    public static <T> List<T> applyOffsetAndLimit(List<T> list, int offset, int limit) {
        if (ListUtils.isUnlimitedOffsetAndLimit(offset, limit)) {
            return list;
        }
        int lower = Math.max(offset, 0);
        int upper = lower + (limit <= 0 ? list.size() : limit);
        if (upper > list.size()) {
            upper = list.size();
        }
        if (upper <= lower) {
            return Collections.emptyList();
        }
        return list.subList(lower, upper);
    }

    public static boolean isUnlimitedOffsetAndLimit(int offset, int limit) {
        return offset <= 0 && limit <= 0;
    }

    private ListUtils() {
    }
}

