/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.concurrent;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class RateLimiter {
    private final long _inDurationNanos;
    private final BlockingQueue<Long> _hits;
    private final Ticker _nanosSource;

    public RateLimiter(int maxRequests, int duration, TimeUnit durationUnit) {
        this(maxRequests, duration, durationUnit, null);
    }

    public RateLimiter(int maxRequests, int duration, TimeUnit durationUnit, @Nullable Ticker ticker) {
        Preconditions.checkArgument((durationUnit.toSeconds(duration) >= 1L ? 1 : 0) != 0, (Object)"Duration must be greater than 1 second");
        Preconditions.checkArgument((maxRequests > 0 ? 1 : 0) != 0, (Object)"maxRequests must be > 0");
        this._inDurationNanos = durationUnit.toNanos(duration);
        this._hits = new ArrayBlockingQueue<Long>(maxRequests);
        this._nanosSource = ticker == null ? Ticker.systemTicker() : ticker;
    }

    public boolean tryAcquire() {
        this.expireHits();
        long expiryTime = this._nanosSource.read() + this._inDurationNanos;
        return this._hits.offer(expiryTime);
    }

    public boolean isAtLimit() {
        this.expireHits();
        return this._hits.remainingCapacity() == 0;
    }

    public long remainingCapacity() {
        this.expireHits();
        return this._hits.remainingCapacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireHits() {
        long now = this._nanosSource.read();
        RateLimiter rateLimiter = this;
        synchronized (rateLimiter) {
            Long expiryTime;
            while ((expiryTime = (Long)this._hits.peek()) != null && expiryTime < now) {
                this._hits.poll();
            }
        }
    }

    public String toString() {
        return "RateLimiter[count=" + this._hits.size() + "]";
    }
}

