/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.ListIterator;
import java.util.Locale;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RolloverFileOutputStream
extends FilterOutputStream {
    private static final Logger logger = LoggerFactory.getLogger(RolloverFileOutputStream.class);
    private static final String YYYY_MM_DD = "yyyy_mm_dd";
    private static final ArrayList<WeakReference<RolloverFileOutputStream>> __rollovers = new ArrayList();
    private static Rollover __rollover;
    private final SimpleDateFormat _fileBackupFormat = new SimpleDateFormat(System.getProperty("ROLLOVERFILE_BACKUP_FORMAT", "HHmmssSSS"), Locale.US);
    private final SimpleDateFormat _fileDateFormat = new SimpleDateFormat(System.getProperty("ROLLOVERFILE_DATE_FORMAT", "yyyy_MM_dd"), Locale.US);
    private String _filename;
    private File _file;
    private final boolean _append;
    private final int _retainDays;
    private WeakReference<RolloverFileOutputStream> _ref;

    public RolloverFileOutputStream(String filename) throws IOException {
        this(filename, true, Integer.getInteger("ROLLOVERFILE_RETAIN_DAYS", 31));
    }

    public RolloverFileOutputStream(String filename, boolean append) throws IOException {
        this(filename, true, Integer.getInteger("ROLLOVERFILE_RETAIN_DAYS", 31));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RolloverFileOutputStream(String filename, boolean append, int retainDays) throws IOException {
        super(null);
        if (filename != null && (filename = filename.trim()).isEmpty()) {
            filename = null;
        }
        if (filename == null) {
            throw new IllegalArgumentException("Invalid filename");
        }
        this._filename = filename;
        this._append = append;
        this._retainDays = retainDays;
        this._ref = new WeakReference<RolloverFileOutputStream>(this);
        this.setFile();
        ArrayList<WeakReference<RolloverFileOutputStream>> arrayList = __rollovers;
        synchronized (arrayList) {
            if (__rollover == null) {
                __rollover = new Rollover();
                __rollover.start();
            }
            __rollovers.add(this._ref);
        }
    }

    public String getFilename() {
        return this._filename;
    }

    public String getDatedFilename() {
        if (this._file == null) {
            return null;
        }
        return this._file.toString();
    }

    public int getRetainDays() {
        return this._retainDays;
    }

    private synchronized void setFile() throws IOException {
        File file = new File(this._filename);
        this._filename = file.getCanonicalPath();
        file = new File(this._filename);
        File dir = new File(file.getParent());
        if (!dir.isDirectory() || !dir.canWrite()) {
            throw new IOException("Cannot write log directory " + String.valueOf(dir));
        }
        Date now = new Date();
        String filename = file.getName();
        int i = filename.toLowerCase().indexOf(YYYY_MM_DD);
        if (i >= 0) {
            file = new File(dir, filename.substring(0, i) + this._fileDateFormat.format(now) + filename.substring(i + YYYY_MM_DD.length()));
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException("Cannot write log file " + String.valueOf(file));
        }
        if (this.out == null || !file.equals(this._file)) {
            this._file = file;
            if (!this._append && file.exists()) {
                file.renameTo(new File(String.valueOf(file) + "." + this._fileBackupFormat.format(now)));
            }
            OutputStream oldOut = this.out;
            this.out = new FileOutputStream(file.toString(), this._append);
            if (oldOut != null) {
                oldOut.close();
            }
        }
    }

    private void removeOldFiles() {
        if (this._retainDays > 0) {
            String[] logList;
            Calendar retainDate = Calendar.getInstance();
            retainDate.add(5, -this._retainDays);
            int borderYear = retainDate.get(1);
            int borderMonth = retainDate.get(2) + 1;
            int borderDay = retainDate.get(5);
            File file = new File(this._filename);
            File dir = new File(file.getParent());
            String fn = file.getName();
            int s = fn.toLowerCase().indexOf(YYYY_MM_DD);
            if (s < 0) {
                return;
            }
            String prefix = fn.substring(0, s);
            String suffix = fn.substring(s + YYYY_MM_DD.length());
            for (String string : logList = dir.list()) {
                fn = string;
                if (!fn.startsWith(prefix) || fn.indexOf(suffix, prefix.length()) < 0) continue;
                try {
                    StringTokenizer st = new StringTokenizer(fn.substring(prefix.length()), "_.");
                    int nYear = Integer.parseInt(st.nextToken());
                    int nMonth = Integer.parseInt(st.nextToken());
                    int nDay = Integer.parseInt(st.nextToken());
                    if (nYear >= borderYear && (nYear != borderYear || nMonth >= borderMonth) && (nYear != borderYear || nMonth != borderMonth || nDay > borderDay)) continue;
                    new File(dir, fn).delete();
                }
                catch (Exception e) {
                    logger.debug("Error removing old files", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<WeakReference<RolloverFileOutputStream>> arrayList = __rollovers;
        synchronized (arrayList) {
            __rollovers.remove(this._ref);
            this._ref = null;
            try {
                super.close();
            }
            finally {
                this.out = null;
                this._file = null;
            }
        }
    }

    private static class Rollover
    extends Thread {
        private final Logger logger = LoggerFactory.getLogger(Rollover.class);

        Rollover() {
            this.setName("Rollover");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Calendar now = Calendar.getInstance();
                    GregorianCalendar midnight = new GregorianCalendar(now.get(1), now.get(2), now.get(5), 23, 0);
                    midnight.add(10, 1);
                    long sleeptime = midnight.getTime().getTime() - now.getTime().getTime();
                    Thread.sleep(sleeptime);
                }
                catch (InterruptedException e) {
                    this.logger.error("Interrupted during rollover file stream", (Throwable)e);
                }
                ArrayList<WeakReference<RolloverFileOutputStream>> arrayList = __rollovers;
                synchronized (arrayList) {
                    ListIterator<WeakReference<RolloverFileOutputStream>> iter = __rollovers.listIterator();
                    while (iter.hasNext()) {
                        WeakReference<RolloverFileOutputStream> ref = iter.next();
                        RolloverFileOutputStream rfos = (RolloverFileOutputStream)ref.get();
                        if (rfos == null) {
                            iter.remove();
                            continue;
                        }
                        try {
                            rfos.setFile();
                            rfos.removeOldFiles();
                        }
                        catch (IOException e) {
                            this.logger.debug("Error removing old files", (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

