/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class EnhancedTextField
extends JTextField {
    private final int _maxLength;

    public EnhancedTextField(int maxLength) {
        this._maxLength = maxLength;
        this.setDocument(new TextVerifier());
        this.addFocusListener(new FocusHandler());
    }

    private class TextVerifier
    extends PlainDocument {
        private static final long serialVersionUID = 7534332484564072933L;

        private TextVerifier() {
        }

        @Override
        public void insertString(int offset, String str, AttributeSet attSet) throws BadLocationException {
            if (str == null) {
                return;
            }
            String old = this.getText(0, this.getLength());
            String newStr = old.substring(0, offset) + str + old.substring(offset);
            if (newStr.length() <= EnhancedTextField.this._maxLength) {
                super.insertString(offset, str, attSet);
            }
        }
    }

    private class FocusHandler
    implements FocusListener {
        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            EnhancedTextField.this.selectAll();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

