/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.CustomMessagePrintDialog;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.TextDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.TextDialogResponse;
import biz.papercut.pcng.util.swing.DialogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;

public class CustomTextPrintDialog
extends CustomMessagePrintDialog {
    private final JTextField _textField;

    public static CustomMessagePrintDialog construct(JFrame owner, TextDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        CustomTextPrintDialog d = new CustomTextPrintDialog(owner, request, job, conn, config);
        d.initializeTextDialog();
        return d;
    }

    protected CustomTextPrintDialog(JFrame owner, TextDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        super(owner, (MessageDialogRequest)request, job, conn, config);
        this._textField = request.isMasked() ? new JPasswordField() : new JTextField();
    }

    @Override
    protected JPanel constructMainPanel() {
        JPanel messagePanel = super.constructMainPanel();
        TextDialogRequest request = (TextDialogRequest)this._request;
        String textLabel = request.getFieldLabel();
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 20));
        if (StringUtils.isNotBlank((String)textLabel)) {
            textPanel.add((Component)new JLabel(textLabel), "West");
        }
        JPanel fieldPanel = new JPanel(new BorderLayout());
        if (StringUtils.isNotBlank((String)textLabel)) {
            fieldPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        }
        fieldPanel.add((Component)this._textField, "Center");
        textPanel.add((Component)fieldPanel, "Center");
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)messagePanel, "Center");
        p.add((Component)textPanel, "South");
        return p;
    }

    public void initializeTextDialog() {
        this.initializeMessageDialog();
        String defaultText = ((TextDialogRequest)this._request).getDefaultText();
        this._textField.setText(defaultText);
        this._textField.requestFocus();
        if (!defaultText.isEmpty()) {
            this._textField.setSelectionStart(0);
            this._textField.setSelectionEnd(defaultText.length());
        }
    }

    @Override
    protected boolean handleWindowClosing(WindowEvent e) {
        this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new TextDialogResponse("CANCEL", this._textField.getText()));
        return true;
    }

    @Override
    protected boolean handleButtonPress(String button) {
        String text = this._textField.getText();
        if (!"CANCEL".equalsIgnoreCase(button) && StringUtils.isBlank((String)text)) {
            DialogUtils.showInformationMessageDialog((Component)this, (String)Messages.getString(this.getClass(), "SelectAccount.error", new String[0]), (String)Messages.getString(this.getClass(), "CustomTextPrintDialog.enter-text", new String[0]));
            return false;
        }
        this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new TextDialogResponse(button, this._textField.getText()));
        return true;
    }
}

