/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.CustomChoicePrintDialog;
import biz.papercut.pcng.client.uit.CustomHTMLFormPrintDialog;
import biz.papercut.pcng.client.uit.CustomMessagePrintDialog;
import biz.papercut.pcng.client.uit.CustomTextPrintDialog;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ChoiceDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequestWithJobInfo;
import biz.papercut.pcng.common.client.dialogrequest.HTMLFormDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.TextDialogRequest;
import biz.papercut.pcng.util.swing.DialogUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DialogRequestHandler
implements ClientController.DialogRequestListener {
    private static final Logger logger = LoggerFactory.getLogger(DialogRequestHandler.class);
    private final ServerConnection _serverConnection;
    private final UserClientConfig _config;
    private final UserClientFrame _userClientFrame;

    public DialogRequestHandler(UserClientFrame userClientFrame, ServerConnection serverConnection, UserClientConfig clientConfig) {
        this._serverConnection = serverConnection;
        this._config = clientConfig;
        this._userClientFrame = userClientFrame;
    }

    @Override
    public void newDialogRequests(List<ClientDialogRequestWithJobInfo> dialogRequests) {
        try {
            SwingUtilities.invokeAndWait(() -> this.processDialogRequests(dialogRequests));
        }
        catch (Exception e) {
            logger.error("Unable to process new print jobs: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDialogRequests(List<ClientDialogRequestWithJobInfo> dialogRequests) {
        try {
            this._userClientFrame.setPopupDialogIsDisplayed(true);
            for (ClientDialogRequestWithJobInfo t : dialogRequests) {
                ClientPrintJob job = t.getJob();
                ClientDialogRequest request = t.getRequest();
                if (logger.isDebugEnabled()) {
                    logger.debug("Dialog request: {}, Job: {}", (Object)request, (Object)job);
                }
                Dialog dialog = null;
                ClientDialogRequest clientDialogRequest = request;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TextDialogRequest.class, ChoiceDialogRequest.class, HTMLFormDialogRequest.class, MessageDialogRequest.class}, (Object)clientDialogRequest, n)) {
                    case 0: {
                        TextDialogRequest tdr = (TextDialogRequest)clientDialogRequest;
                        dialog = CustomTextPrintDialog.construct((JFrame)this._userClientFrame, tdr, job, this._serverConnection, this._config);
                        break;
                    }
                    case 1: {
                        ChoiceDialogRequest tdr = (ChoiceDialogRequest)clientDialogRequest;
                        dialog = CustomChoicePrintDialog.construct((JFrame)this._userClientFrame, tdr, job, this._serverConnection, this._config);
                        break;
                    }
                    case 2: {
                        HTMLFormDialogRequest hfdr = (HTMLFormDialogRequest)clientDialogRequest;
                        dialog = CustomHTMLFormPrintDialog.construct(this._userClientFrame, (MessageDialogRequest)hfdr, job, this._serverConnection, this._config);
                        break;
                    }
                    case 3: {
                        MessageDialogRequest bdr = (MessageDialogRequest)clientDialogRequest;
                        dialog = CustomMessagePrintDialog.construct(this._userClientFrame, bdr, job, this._serverConnection, this._config);
                        break;
                    }
                    default: {
                        DialogUtils.showErrorMessageDialog((Component)this._userClientFrame, (String)"Error", (String)("Unsupported dialog type: " + String.valueOf(request)));
                    }
                }
                if (dialog == null) continue;
                dialog.setVisible(true);
                dialog.dispose();
            }
        }
        catch (Throwable t) {
            logger.error("Error displaying dialog requests. {}", (Object)t.getMessage(), (Object)t);
        }
        finally {
            this._userClientFrame.setPopupDialogIsDisplayed(false);
        }
    }
}

