// Fermify — JavaScript "behind the scenes"
// NOTA: gli studenti non devono modificare questo file.
// Serve solo per simulare play/pausa e un piccolo highlight su una tabella.

(function(){
  function qs(sel){ return document.querySelector(sel); }
  function qsa(sel){ return Array.from(document.querySelectorAll(sel)); }

  // Play/Pause toggle
  const btn = qs('#btnPlay');
  const icon = qs('#btnPlayIcon');
  if(btn && icon){
    btn.addEventListener('click', () => {
      const state = btn.getAttribute('data-state') || 'paused';
      const next = (state === 'paused') ? 'playing' : 'paused';
      btn.setAttribute('data-state', next);

      // Swap icon
      icon.src = next === 'playing' ? '../assets/icons/pause.svg' : '../assets/icons/play.svg';
      icon.alt = next === 'playing' ? 'Pausa' : 'Play';

      // Status text
      const status = qs('#playerStatus');
      if(status){
        status.textContent = (next === 'playing') ? 'In riproduzione…' : 'In pausa';
      }
    });
  }

  // Click-to-highlight rows (if table exists)
  const rows = qsa('table.tracks tbody tr');
  rows.forEach(r => r.addEventListener('click', () => {
    rows.forEach(x => x.classList.remove('is-active'));
    r.classList.add('is-active');

    // Update "now playing" title if present
    const titleCell = r.querySelector('[data-title]');
    const artistCell = r.querySelector('[data-artist]');
    const nowTitle = qs('#nowTitle');
    const nowArtist = qs('#nowArtist');
    if(titleCell && artistCell && nowTitle && nowArtist){
      nowTitle.textContent = titleCell.textContent.trim();
      nowArtist.textContent = artistCell.textContent.trim();
    }
  }));
})();
