/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: aut_canc.cc          ULTIMA MODIFICA: 03/10/1999        */
/*                                                                  */
/*  Programma per cancellare le autorizzazioni di accesso al        */
/*  database di un dipendente della biblioteca                      */
/*                                                                  */
/*------------------------------------------------------------------*/

#include <iostream.h>
#include <stdlib.h>
#include <unistd.h>
#include "mysql.h"
#include "sqltypes.h"

#ifdef _WIN32
char* getpass(const char* prompt) {
    static char passbuf[1024];
    cout << prompt;
    cin >> passbuf;
    return passbuf;
}
#else
#include <unistd.h>
#endif


const char host[]="localhost";   // nome della macchina su cui si trova il DB
const char dbname[]="cherubino"; // nome del DB

const char querydip[]="SELECT Codice, Denominaz1, Denominaz2 FROM CORRISPONDENTE_AFFIDATARIO WHERE Tipo='dipendente' ORDER BY Codice";


// la seguente funzioncina intercetta i NULL trasformandoli in uno spazio
inline char* fn2(char* c) {
    if(c!=NULL) return c; else return " ";
}


int main() {
    MYSQL mysql;

    cout<<"----------------------------------------------\n";
    cout<<"|  Cancellazione del login di un dipendente  |\n";
    cout<<"----------------------------------------------\n\n";

    // innanzitutto, chiede all'utente la password di root
    // e si connette per vedere se e` valida
    char buff[1024];
    char* ppass=getpass("Inserire la password di root: ");
    int i=-1;
    do {
        ++i;
        buff[i]=*(ppass+i);
        *(ppass+i)='\0';
    } while((buff[i]!='\0')&&(i<1023));
    buff[i]='\0';
    if(mysql_connect(&mysql, host, "root", buff)==NULL) {
        cout<<"Connessione al database server fallita.\n";
        cout<<"Utente non autorizzato all'accesso.\n";
	return(1);
    }
    for(i=0;i<1024;++i) buff[i]='\0';
    if(mysql_select_db(&mysql, dbname)!=0) {;
        cout<<"Connessione al database '"<<dbname<<"' fallita.\n";
	cout<<"Impossibile proseguire.\n";
        mysql_close(&mysql);
	return(2);
    }
    cout << "connessione avvenuta con dB " << dbname << endl;

    // a questo punto, esegue una query per determinare codice, nome e cognome
    // di tutti i dipendenti della biblioteca
    MYSQL_RES* res;
    SqlResult r;
    int numdip;
    if(mysql_query(&mysql, querydip)!=0) {
        cout<<"Query dei dipendenti fallita: impossibile proseguire.\n";
        mysql_close(&mysql);
	return(3);
    }    
    res=mysql_store_result(&mysql);
    r.store(res);
    numdip=r.rowNum();
    if(numdip==0) {
        cout<<"Nessun dipendente risulta attualmente registrato nella base dati.\n";
        mysql_close(&mysql);
	return(0);
    }

    // stampa una lista dei dipendenti trovati
    cout<<"I dipendenti attualmente registrati nel database sono:\n\n";
    int* listacodici=new int[numdip];
    for(i=0; i<numdip; ++i) {
	cout<<r.get(i,0)<<") "<<r.get(i,1)<<" "<<fn2(r.get(i,2))<<endl;
	listacodici[i]=atoi(r.get(i,0));
    }

    // chiede quale dipendente si vuole considerare
    bool OK=0;
    while(!OK) {
        cout<<"\nInserire il codice del dipendente prescelto: ";
        cin>>buff;
	for(i=0; i<numdip; ++i) if(listacodici[i]==atoi(buff)) OK=1;
    }
    delete listacodici;
    int Codice_dip=atoi(buff);

    // chiede conferma della cancellazione del login
    cout<<"Si e` sicuri di voler cancellare il login del dipendente "
        <<Codice_dip<<"?(s/n) ";
    cin>>buff;
    if(strcmp(buff,"s")!=0) {
        cout<<"Login non cancellato.\n";
	cout<<"Il dipendente potra` continuare a usare il programma M.O.N.K.\n";
        mysql_close(&mysql);
        return(0);
    }
    // cancellazione confermata: spazza via l'utente
    if(mysql_select_db(&mysql, "mysql")!=0) {;
        cout<<"Connessione al database 'mysql' fallita.\n";
	cout<<"Cancellazione del login non effettuata.\n";
        mysql_close(&mysql);
	return(4);
    }
    int r1, r2, r3;
    String tmp;
    tmp="DELETE FROM user WHERE User='";
    tmp=tmp+Codice_dip+"'";
    r1=mysql_query(&mysql, tmp.cString());
    if(r1!=0) cout<<mysql_error(&mysql)<<endl;
    
    tmp="DELETE FROM db WHERE User='";
    tmp=tmp+Codice_dip+"'";
    r2=mysql_query(&mysql, tmp.cString());
    if(r2!=0) cout<<mysql_error(&mysql)<<endl;

#ifdef _WIN32
    r3=mysql_reload(&mysql);
    if(r3!=0) cout<<mysql_error(&mysql)<<endl;
#else
    r3=mysql_query(&mysql, "FLUSH PRIVILEGES");
    if(r3!=0) cout<<mysql_error(&mysql)<<endl;
#endif
    i=r1||r2||r3;
    if(i!=0) {
        cout<<"Cancellazione del login fallita.\n";
        mysql_close(&mysql);
	return(5);
    }    
    cout<<"Login cancellato.\n";
    cout<<"Il dipendente "<<Codice_dip<<" non ha piu` accesso al programma M.O.N.K.\n";;

    mysql_close(&mysql);
    return(0);
}
