/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: aut_mod.cc           ULTIMA MODIFICA: 03/10/1999        */
/*                                                                  */
/*  Programma per impostare le autorizzazioni di accesso al         */
/*  database per i dipendenti della biblioteca                      */
/*                                                                  */
/*------------------------------------------------------------------*/

#include <iostream.h>
#include <stdlib.h>
#include <unistd.h>
#include "mysql.h"
#include "sqltypes.h"

#ifdef _WIN32
char* getpass(const char* prompt) {
    static char passbuf[1024];
    cout << prompt;
    cin >> passbuf;
    return passbuf;
}
#else
#include <unistd.h>
#endif


const char host[]="localhost";   // nome della macchina su cui si trova il DB
const char dbname[]="cherubino"; // nome del DB

const char querydip[]="SELECT Codice, Denominaz1, Denominaz2 FROM CORRISPONDENTE_AFFIDATARIO WHERE Tipo='dipendente' ORDER BY Codice";


// la seguente funzioncina intercetta i NULL trasformandoli in uno spazio
inline char* fn2(char* c) {
    if(c!=NULL) return c; else return " ";
}


int main() {
    MYSQL mysql;

    cout<<"----------------------------------------------------\n";
    cout<<"|  Modifica delle autorizzazioni di un dipendente  |\n";
    cout<<"----------------------------------------------------\n\n";

    // innanzitutto, chiede all'utente la password di root
    // e si connette per vedere se e` valida
    char* ppass=getpass("Inserire la password di root: ");
    if(mysql_connect(&mysql, host, "root", ppass)==NULL) {
        cout<<"Connessione al database server fallita.\n";
        cout<<"Utente non autorizzato all'accesso.\n";
	return(1);
    }
    int i=0;
    do {
        *(ppass+i)='\0';
        ++i;
    } while(*(ppass+i)!='\0');
    if(mysql_select_db(&mysql, dbname)!=0) {;
        cout<<"Connessione al database '"<<dbname<<"' fallita.\n";
	cout<<"Impossibile proseguire.\n";
        mysql_close(&mysql);
	return(2);
    }
    cout << "connessione avvenuta con dB " << dbname << endl;

    // a questo punto, esegue una query per determinare codice, nome e cognome
    // di tutti i dipendenti della biblioteca
    MYSQL_RES* res;
    SqlResult r;
    int numdip;
    if(mysql_query(&mysql, querydip)!=0) {
        cout<<"Query dei dipendenti fallita: impossibile proseguire.\n";
        mysql_close(&mysql);
	return(3);
    }    
    res=mysql_store_result(&mysql);
    r.store(res);
    numdip=r.rowNum();
    if(numdip==0) {
        cout<<"Nessun dipendente risulta attualmente registrato nella base dati.\n";
	cout<<"Prima di poter modificare le autorizzazioni di un dipendente, e`\n";
	cout<<"necessario inserirne i dati usando il programma M.O.N.K.\n";
        mysql_close(&mysql);
	return(0);
    }

    // stampa una lista dei dipendenti trovati
    cout<<"I dipendenti attualmente registrati nel database sono:\n\n";
    int* listacodici=new int[numdip];
    for(i=0; i<numdip; ++i) {
	cout<<r.get(i,0)<<") "<<r.get(i,1)<<" "<<fn2(r.get(i,2))<<endl;
	listacodici[i]=atoi(r.get(i,0));
    }

    // chiede quale dipendente si vuole considerare
    char buff[1024];
    bool OK=0;
    while(!OK) {
        cout<<"\nInserire il codice del dipendente prescelto: ";
        cin>>buff;
	for(i=0; i<numdip; ++i) if(listacodici[i]==atoi(buff)) OK=1;
    }
    delete listacodici;
    int Codice_dip=atoi(buff);

    // chiede le autorizzazioni da assegnare al dipendente
    char* autorizz=new char[5];
    for(i=0; i<4; ++i) autorizz[i]='0';
    autorizz[4]='\0';
    String nomiautorizz[4]={ "lettura","inserimento","modifica","cancellazione" };
    for(i=0; i<4; ++i) {
        cout<<"Si vogliono consentire al dipendente le operazioni di "
	    <<nomiautorizz[i]<<"?(s/n) ";
	cin>>buff;
	if(strcmp(buff,"s")==0) autorizz[i]='1';
    }

    // aggiorna le autorizzazioni in base alle decisioni dell'utente
    // innanzitutto, determina se nella tabella DIPENDENTE_INFO_AGG
    // e` gia` presente una tupla per il dipendente (dovrebbe esserci...)
    String tmp="SELECT Codice_dip FROM DIPENDENTE_INFO_AGG ";
    tmp=tmp+"WHERE Codice_dip="+Codice_dip;
    if(mysql_query(&mysql, tmp.cString())!=0) {
        cout<<"Errore nell'accesso al DB: impossibile proseguire.\n";
        mysql_close(&mysql);
	return(4);
    }    
    res=mysql_store_result(&mysql);
    r.store(res);
    // se non e` presente allora aggiunge una tupla, altrimenti aggiorna
    // la tupla (o le tuple, se il DB e` incasinato) gia` presente
    if(r.rowNum()==0) {
        tmp="INSERT INTO DIPENDENTE_INFO_AGG VALUES('";
	tmp=tmp+Codice_dip+"',null,'"+autorizz+"')";
    } else {
        tmp="UPDATE DIPENDENTE_INFO_AGG SET Autorizzazione='";
	tmp=tmp+autorizz+"' WHERE Codice_dip='"+Codice_dip+"'";
    }
    if(mysql_query(&mysql, tmp.cString())!=0) {
        cout<<"Aggiornamento delle autorizzazioni fallito: impossibile proseguire.\n";
        mysql_close(&mysql);
	return(5);
    }    
    cout<<"Autorizzazioni aggiornate con successo.\n";

    // a questo punto, non rimane che controllare se il dipendente ha
    // un login per l'accesso al database
    MYSQL mysqltest;
    ppass=getpass("Inserire la password del dipendente: ");
    tmp=Codice_dip;
    if(mysql_connect(&mysqltest, host, tmp.cString(), ppass)!=NULL) {
        cout<<"OK: il dipendente "<<Codice_dip<<" ha un login valido.\n";
        mysql_close(&mysqltest);
        mysql_close(&mysql);
        return(0);
    }
    // se si arriva qui, l'utente non ha un login al database
    // e bisogna provvedere a crearne uno
    cout<<"L'utente non ha un login al DB con questa password.\n";
    cout<<"Si desidera creare un login?(s/n) ";
    cin>>buff;
    if(strcmp(buff,"s")!=0) {
        cout<<"Login non creato.\n";
	cout<<"Si ricordi comunque che il dipendente non potra` usare il programma M.O.N.K.\n";
	cout<<"fino a quando non avra` un login.\n";
        mysql_close(&mysql);
        return(0);
    }
    // crea un login per l'utente    
    if(mysql_select_db(&mysql, "mysql")!=0) {;
        cout<<"Connessione al database 'mysql' fallita.\n";
	cout<<"Impossibile proseguire.\n";
        mysql_close(&mysql);
	return(6);
    }
    int r1, r2, r3;
#ifdef _WIN32
    tmp="INSERT INTO user VALUES ('%','";
    tmp=tmp+Codice_dip+"',password('"+ppass+"'),";
    tmp=tmp+"'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y')";
    r1=mysql_query(&mysql, tmp.cString());
    if(r1!=0) cout<<mysql_error(&mysql)<<endl;

    tmp="INSERT INTO user VALUES ('localhost','";
    tmp=tmp+Codice_dip+"',password('"+ppass+"'),";
    tmp=tmp+"'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y')";
    r1=mysql_query(&mysql, tmp.cString());
    if(r1!=0) cout<<mysql_error(&mysql)<<endl;
    
    tmp="INSERT INTO db VALUES ('%','";
    tmp=tmp+dbname+"','"+Codice_dip+"','Y','Y','Y','Y','Y','Y')";
    r2=mysql_query(&mysql, tmp.cString());
    if(r2!=0) cout<<mysql_error(&mysql)<<endl;

    r3=mysql_reload(&mysql);
    if(r3!=0) cout<<mysql_error(&mysql)<<endl;
#else
    tmp="INSERT INTO user VALUES ('";
    tmp=tmp+host+"','"+Codice_dip+"',password('"+ppass+"'),";
    tmp=tmp+"'Y','Y','Y','Y','Y','Y','Y','Y','Y','Y','N','N','N','N')";
    r1=mysql_query(&mysql, tmp.cString());
    if(r1!=0) cout<<mysql_error(&mysql)<<endl;

    tmp="INSERT INTO db VALUES ('%','";
    tmp=tmp+dbname+"','"+Codice_dip+"','Y','Y','Y','Y','Y','Y','Y','Y','Y','Y')";
    r2=mysql_query(&mysql, tmp.cString());
    if(r2!=0) cout<<mysql_error(&mysql)<<endl;

    r3=mysql_query(&mysql, "FLUSH PRIVILEGES");
    if(r3!=0) cout<<mysql_error(&mysql)<<endl;
#endif
    i=r1||r2||r3;
    if(i!=0) {
        cout<<"Creazione del login fallita.\n";
        mysql_close(&mysql);
	return(7);
    }    
    cout<<"OK: adesso il dipendente ha un login con nome '"<<Codice_dip;
    cout<<"'\ne password '"<<ppass<<"'.\n";

    mysql_close(&mysql);
    return(0);
}
