CREATE DATABASE cherubino;

USE cherubino;

CREATE TABLE SCARICO_INFO_OPZ (
    Anno SMALLINT UNSIGNED NOT NULL,
    Numero SMALLINT UNSIGNED NOT NULL,
    Annotazioni VARCHAR(40) NOT NULL,
    PRIMARY KEY (Anno,Numero),
    FOREIGN KEY (Anno,Numero) REFERENCES SCARICO ON DELETE CASCADE
);

CREATE TABLE SCARICO (
    Anno SMALLINT UNSIGNED NOT NULL,
    Numero SMALLINT UNSIGNED NOT NULL,
    Ladata DATE,
    Oggetto TINYTEXT NOT NULL,
    Tipo_documento VARCHAR(20),
    Classifica CHAR(3),
    Destinatario SMALLINT UNSIGNED,
    PRIMARY KEY (Anno,Numero),
    FOREIGN KEY (Destinatario) REFERENCES CORRISPONDENTE_AFFIDATARIO(Codice) ON DELETE NO ACTION
);

CREATE TABLE CORRISPONDENZA (
    Anno_scarico SMALLINT UNSIGNED NOT NULL,
    Numero_scarico SMALLINT UNSIGNED NOT NULL,
    Anno_carico SMALLINT UNSIGNED NOT NULL, 
    Numero_carico SMALLINT UNSIGNED NOT NULL,
    PRIMARY KEY (Anno_scarico,Numero_scarico),
    FOREIGN KEY (Anno_scarico,Numero_scarico) REFERENCES SCARICO (Anno,Numero) ON DELETE NO ACTION,
    FOREIGN KEY (Anno_carico,Numero_carico) REFERENCES CARICO (anno,numero) ON DELETE NO ACTION
); 

CREATE TABLE RIPARTO (
    Codice CHAR(3) NOT NULL,
    Significato VARCHAR(128) NOT NULL,
    PRIMARY KEY (Codice)
);

CREATE TABLE CARICO (
    Anno SMALLINT UNSIGNED NOT NULL,
    Numero SMALLINT UNSIGNED NOT NULL,
    Ladata DATE,
    Oggetto TINYTEXT NOT NULL,
    Tipo_documento VARCHAR (20), 
    Riparto CHAR (3),
    Mittente SMALLINT UNSIGNED,
    Data_atto VARCHAR (20),
    Num_atto VARCHAR (40),
    Data_fax DATE,
    PRIMARY KEY (Anno,Numero),
    FOREIGN KEY (Riparto) REFERENCES RIPARTO (Codice) ON DELETE NO ACTION,
    FOREIGN KEY (Mittente) REFERENCES CORRISPONDENTE_AFFIDATARIO (Codice) ON DELETE NO ACTION
);

CREATE TABLE AFFIDAMENTO (
    Anno_carico SMALLINT UNSIGNED NOT NULL, 
    Numero_carico SMALLINT UNSIGNED NOT NULL, 
    Codice_affidatario SMALLINT UNSIGNED NOT NULL,
    Data_inizio_aff DATE NOT NULL,
    Data_fine_aff DATE,
    PRIMARY KEY (Anno_carico,Numero_carico,Codice_affidatario),
    FOREIGN KEY (Anno_carico,Numero_carico) REFERENCES CARICO (Anno,Numero) ON DELETE NO ACTION,
    FOREIGN KEY (Codice_affidatario) REFERENCES CORRISPONDENTE_AFFIDATARIO (Codice) ON DELETE NO ACTION
);

CREATE TABLE CORRISPONDENTE_AFFIDATARIO (
    Codice SMALLINT UNSIGNED NOT NULL, 
    Denominaz1 VARCHAR (40) NOT NULL,
    Denominaz2 VARCHAR (40),
    Tipo VARCHAR (20) NOT NULL, 
    Via VARCHAR (50),
    Citta VARCHAR (30),
    Cap CHAR (6),
    Telefono VARCHAR (25),
    Fax VARCHAR (25),
    Obsoleto SET('VALIDO','SCADUTO') NOT NULL,
    PRIMARY KEY (Codice)
);

CREATE TABLE CORRISP_ORGANIZZAZIONE (
    Codice SMALLINT UNSIGNED NOT NULL,
    Partita_iva VARCHAR (20),
    Tramite VARCHAR (50),
    PRIMARY KEY (Codice),
    FOREIGN KEY (Codice) REFERENCES CORRISPONDENTE_AFFIDATARIO ON DELETE CASCADE
);
                 
CREATE TABLE CORRISP_PERSONA (
    Codice SMALLINT UNSIGNED NOT NULL,
    Titolo VARCHAR (30),
    Cod_fisc CHAR (16),
    PRIMARY KEY (Codice),
    FOREIGN KEY (Codice) REFERENCES CORRISPONDENTE_AFFIDATARIO ON DELETE CASCADE
);

CREATE TABLE DIPENDENTE_INFO_AGG (
    Codice_dip SMALLINT UNSIGNED NOT NULL,
    Ufficio VARCHAR (50), 
    Autorizzazione VARCHAR (10),
    PRIMARY KEY (Codice_dip),
    FOREIGN KEY (Codice_dip) REFERENCES CORRISPONDENTE_AFFIDATARIO (Codice) ON DELETE CASCADE 
); 

CREATE TABLE OPERAZIONE (
    Codice_operatore SMALLINT UNSIGNED NOT NULL, 
    Data_operazione DATE NOT NULL,
    Ora_operazione TIME, 
    Tipo_operazione VARCHAR (50) NOT NULL,
    PRIMARY KEY (Codice_operatore,Data_operazione),
    FOREIGN KEY (Codice_operatore) REFERENCES DIPENDENTE_INFO_AGG (Codice_dip) ON DELETE CASCADE
);
