/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: angel.cc             ULTIMA MODIFICA: 22/09/1999        */
/*                                                                  */
/*  Codice per il programma angel.                                  */
/*                                                                  */
/*------------------------------------------------------------------*/

#include <stdio.h>
//#include <stdlib.h>  // Prima c'era
#include <string.h>
#ifdef __CYGWIN__
    #include <process.h>
#endif
#include "angel.h"
#include "html_utils.h"
#include "stringone.h"
#include "operation.h"
#include <sys/types.h>  // Aggiunto per SunOS
#include <unistd.h>     // Aggiunto per SunOS


#define DEFAULT_PORT 1975               // anno di nascita degli sviluppatori
int     TIMEOUT=3600;                   // 3600 secondi (1 ora) di timeout
#define DEFAULT_DB_MACHINE "localhost"  // macchina su cui si trova il database

String userName;
String userPwd;

// Array di puntatori alle classi delle operazioni; l'array viene "riempito"
// nel metodo Angel::process()
const int maxOps=17;
Operation* AngelOp[maxOps];

Angel::Angel(int argCount, char* argv []) {
    int port;

    if (argCount <= 1) {
        
        port = DEFAULT_PORT;
    }
    else {
        cout << "CLONNNNNNNNNNNNNNNNE" << endl;
        port = atoi(argv[1]);
    }
    // Il padre di tutti gli angeli si mette in ascolto sulla porta di default
    angelport=port;
    cout << angelport << ": in ascolto" << endl;
    
    try {
            channel.create(angelport);
    }
    catch (Channel::Error error) {
        cerr << angelport << ": " << error << endl;  // senza canale l'angelo scrive su stderr
    }
    catch (Error error) {
        cerr << angelport << ": " << error << endl;  // senza canale l'angelo scrive su stderr
    }

    NumCalls = 0;
    exeName = argv[0];
    DataBase = new SqlConnection();
}

Angel::~Angel() {
    delete DataBase;
}

int Angel::clone() {
        int port = Channel::freePort(SOCK_STREAM);
#ifdef _WIN32
        spawn(port);
#else                    // UGLY: questa e` una toppa per Linux
	sleep(1);
        spawn(port);
	sleep(1);
#endif

//    cout << "clone on port " << port << endl;
        return port;    
}

void Angel::run() {
        String message;
        try {
                for(;;) {
                        cout << angelport << ": al tuo servizio" << endl;
                        channel.listen(TIMEOUT);

                        channel >> message;

                        if (message == "NEW_USER")
                          channel << clone();
                        else
                          channel << process(message);
                } 
        }
        catch (Channel::Timeout) {}     
}

String & Angel::process(const String & message) {
    // alloca le variabili
    static String risposta;
    char* m;
    char* buff;
    stringone bigstr;
    token* mytoken;
    int i;

    // inserisce l'input in una occorrenza di stringone
    m=message.cString();
    i=bigstr.newstring(m);
    if(i!=0) {
        risposta="<BODY>ANGEL: errore nel passaggio dati alla classe stringone.</BODY>";
        return(risposta);
    }
    
    // cerca di capire quale operazione l'utente ha richiesto
    buff=bigstr.findtoken("op");
    if(buff==NULL) {
        risposta="<BODY>ANGEL: identificativo dell'operazione non trovato.</BODY>";
        return(risposta);    
    }

    // se e` la prima chiamata, allora accetta solo l'operazione di login
    if(NumCalls==0) {
        if(strcmp(buff,"login")!=0) {
            risposta="<BODY>ANGEL: operazione non consentita all'utente 0.</BODY>";
            return(risposta);    
        }
        
        // si connette al database con la login e la password fornite
        // dall'utente: se si verifica un errore, allora l'utente e`
        // considerato un intruso non autorizzato
        buff=bigstr.findtoken("nome");
        try {
            userName =  bigstr.findtoken("nome");
            userPwd = bigstr.findtoken("codiceacc");
            DataBase->connect(DEFAULT_DB_MACHINE, userName, userPwd);
        }       
        catch (SqlConnection::GenericError error) {
cout << "ERRORE" << endl;
            risposta=beginbody();
            risposta+="ANGEL - connessione al database non riuscita.<BR>\n";
            risposta+="Identit non confermata.<BR>\n";
            risposta+=endbody();
            TIMEOUT=5;   // UGLY: questo modo di fare non e` elegante...
            cout << error << endl;
            return(risposta);
        }
        
        // se si arriva qui, allora l'utente ha le autorizzazioni
        for(i=0;i<maxOps;++i) AngelOp[i]=NULL;
        // alloca le classi delle operazioni
        AngelOp[0] = new Menu;        // menu principale
        AngelOp[1] = new InsDoc;      // inserimento di un documento
        AngelOp[2] = new InsRip;      // inserimento di un riparto
        AngelOp[3] = new InsCA;       // ins. di un corrispondente/affidatario
        AngelOp[4] = new InsAff;      // prestito/restituz. di un carico
        AngelOp[5] = new ModDoc;      // modifica delle inform. su un documento
        AngelOp[6] = new ModRip;      // modifica delle inform. su un riparto
        AngelOp[7] = new ModCA;       // modifica delle inform. su un c/a/d
        AngelOp[8] = new QueryInt;    // query ad uso interno
        AngelOp[9] = new QueryDoc;    // super-query dei documenti
        AngelOp[10]= new QuerySimple; // query semplici (senza form)
        AngelOp[11]= new QueryCA;     // query sui c/a/d
        AngelOp[12]= new QueryOp;     // query relative al log operazioni
        AngelOp[14]= new BackUp;      // backup dei dati
        AngelOp[15]= new CancCA;      // "cancellazione" di un c/a/d
        AngelOp[16]= new Restore;     // restore dei dati
        // inizializza le classi
        for(i=0;i<maxOps;++i)
            if(AngelOp[i]!=NULL) AngelOp[i]->init(angelport,DataBase);
        // mostra il menu
        risposta=AngelOp[0]->process(&bigstr);
    // fine dell'autenticazione
    
    } else {  // se non e` la prima chiamata, accetta tutte le operazioni
        if(strcmp(buff,"logout")==0) {
            risposta=beginbody();
            risposta+="Connessione terminata: ora si pu chiudere il browser.\n";
            risposta+=endbody();
            TIMEOUT=5;   // UGLY: questo modo di fare non e` elegante...
            return(risposta);
        }
        i=atoi(buff);
        if((i<maxOps)&&(AngelOp[i]!=NULL)) risposta=AngelOp[i]->process(&bigstr);
        else {
            // operazione non riconosciuta: stampa informazioni di debug
            risposta=beginbody();
            risposta+="Hai richiesto un'operazione che mi  sconosciuta.<BR>\n";
            risposta+="Io sono l'angelo sulla porta ";
            risposta=risposta+angelport+"<BR>\n";
            risposta+="Questa per me  la chiamata n. ";
            risposta=risposta+(long int)NumCalls+"<BR>\n";
            risposta+="I token che ho ricevuto sono:<BR>\n";
            bigstr.rewind();
            while((mytoken=bigstr.nexttoken())!=NULL)
            risposta=risposta+mytoken->name+"="+mytoken->value+"<BR>\n";
            risposta=risposta+"<BR><A HREF=\"/cgi-bin/bridge.exe?userid="+angelport+"&op=0\">";
            risposta+="Torna al menu</A><BR>\n";
            risposta+=endbody();
        }
    }
        
    // incrementa il contatore delle chiamate ed esce
    NumCalls++;
    return risposta;
}

int Angel::spawn(int port) {
    String portStr(port);

    int result;
#ifdef __CYGWIN__                               // alcune patches per il cygnus
    result = spawnl(_P_NOWAIT, exeName, exeName, portStr.cString());
#else
    result = fork();
    if (result == 0)
        execl(exeName, exeName, portStr.cString(), NULL);
#endif
    return result;
}

