#include "finder.h"
#include <ctype.h>

bool operator == (const DocKey & first, const DocKey & second) {
    return (first.anno == second.anno) && (first.numero == second.numero);
}

template <class T>
SortArray<T>::SortArray(int _inc) {
    count = 0;
    size = 2;
    inc = _inc;
    items = new T[size];
}

template <class T>
SortArray<T>::~SortArray() {
    reset();
}

template <class T>
void SortArray<T>::insert(const T & value) {
    if (count >= size) 
        extend();

    items[count] = value;
	for (int i=0; i < count; ++i) {
		if (items[count] < items[i]) {
			T tmp = items[count];
			items[count] = items[i];
			items[i] = tmp;
		} 
	}

	count++;
}

template <class T>
int SortArray<T>::retrieve(const T & value) {
	int start = 0; 
	int end = count-1;
	
	while (start <= end) {
		int pivot = (start+end)/2;
		T item = items[pivot];

		if (value < item) { 
			 end = pivot-1;
			 continue;
		}
		  
		if (value > item) { 
			 start = pivot+1;
			 continue;
		}

		return pivot;
	}

	return -1;
}

template <class T>
void SortArray<T>::extend() {
    size += inc;
    T* tmp = new T[size];

    for (int i=0; i < count; ++i) 
        tmp[i] = items[i];

    delete[] items;
    items = tmp;
}

template <class T>
void SortArray<T>::reset() {
    delete[] items;
}

template <class T>
Link<T>::Link(const String & _word): keys(0) {
    word = _word;
}

template <class T>
void Link<T>::link(T & key) {
    int count = keys.count();

    for(int i=0; i < count; ++i)
        if (key == keys[i])
            return;

    keys.addObject(key);
}

template <class T>
bool Link<T>::operator < (const Link & other) const{
    return word < other.word;
}

template <class T>
bool Link<T>::operator > (const Link & other) const{
    return word > other.word;
}

Candidate::Candidate(DocKey* _key) {
    key = _key;
    goodness = 0;
}

bool Candidate::operator > (const Candidate & other) const{
    if (key->anno > other.key->anno)
        return true;
    else
    if (key->anno < other.key->anno)
        return false;
    else
        return key->numero > other.key->numero;
}

bool Candidate::operator < (const Candidate & other) const{
    if (key->anno < other.key->anno)
        return true;
    else
    if (key->anno > other.key->anno)
        return false;
    else
        return key->numero < other.key->numero;
}

void Candidate::candy(double value) {
    goodness += value;
}

Elected::Elected(Candidate & candidate) {
    key = candidate.key;
    goodness = candidate.goodness;
}

bool Elected::operator > (const Elected & other) const{
    return goodness > other.goodness;
}

bool Elected::operator < (const Elected & other) const{
    return goodness < other.goodness;
}

DocKey & Elected::getKey() {
    return *key;
}

Finder::Finder(SqlConnection* _connection) {
    connection = _connection;

    stopWord.insert("un");
    stopWord.insert("una");
    stopWord.insert("uno");

    stopWord.insert("il");
    stopWord.insert("la");
    stopWord.insert("i");
    stopWord.insert("le");
    stopWord.insert("gli");
    stopWord.insert("lo");
    stopWord.insert("l");
    
    stopWord.insert("dei");
    stopWord.insert("delle");

    stopWord.insert("di");
    stopWord.insert("del");
    stopWord.insert("della");

    stopWord.insert("da");
    stopWord.insert("dalla");
    stopWord.insert("dal");

    stopWord.insert("in");
    stopWord.insert("nel");
    stopWord.insert("nella");
    stopWord.insert("nei");
    stopWord.insert("nelle");

    stopWord.insert("con");
    
    stopWord.insert("su");
    stopWord.insert("sul");
    stopWord.insert("sulla");
    
    stopWord.insert("per");
    stopWord.insert("tra");
    stopWord.insert("fra");

    result.items = new DocKey[1];       // piccolo trucco
}

void Finder::update() {
    SqlResult* result = connection->queryOggettoCarico();

    int rows = result->rowNum();

    for (int i=0; i < rows; ++i) {
        char* anno = result->get(i, 0);
        char* numero = result->get(i, 1);
        char* oggetto = result->get(i, 2);
        insert(anno, numero, oggetto);
    }
         
    result = connection->queryOggettoScarico();

    rows = result->rowNum();

    for (int i=0; i < rows; ++i) {
        char* anno = result->get(i, 0);
        char* numero = result->get(i, 1);
        char* oggetto = result->get(i, 2);
        insert(anno, numero, oggetto);
    }
         
}

void Finder::insert(const char* anno, const char* numero, const char* oggetto) {
    if (oggetto == NULL)
        return;

    
    DocKey key(anno, numero);
    char copy[1000];

// ripulisce dalla punteggiatura e porta in minuscolo    
    int i;
    for (i=0; oggetto[i] && i < 1000; ++i) {
        char c = tolower(oggetto[i]);
        if (( c < 'a' || c > 'z') && ( c < 'A' || c > 'Z') && (
                (c < '0' || c > '9')))
            c = ' ';

        copy[i] = c;  
    }
    
    copy[i] = 0;
    
    char* delimiters = " ";        
    for (char* token = strtok(copy, delimiters); token != NULL; 
        token = strtok(NULL, delimiters)) {
        String word(token);
        if (word.length() < 4)            // se  molto corta
            continue;
            
        if (stopWord.retrieve(word) >= 0)        // se  una stop word
            continue;

        Link<DocKey> link(word);
        int idx = dictionary.retrieve(link);
        if (idx >= 0) 
            dictionary[idx].link(key);
        else {
            link.link(key);
            dictionary.insert(link);
        }
    }
} 

KeyArray & Finder::select(const SqlString & oggetto, int number) {    
    SortArray<Candidate> candidates;
    SortArray<Elected> elects;

    if (oggetto.isNull()) {
        result.count = -1;
        return result;
    }

    String str = oggetto.html();
    char* ogg = str.cString();
// ripulisce dalla punteggiatura e porta in minuscolo    
    int i;
    char copy[200];
    for (i=0; ogg[i] && i < 1000; ++i) {
        char c = tolower(ogg[i]);
        if (( c < 'a' || c > 'z') && ( c < 'A' || c > 'Z') && (
                (c < '0' || c > '9')))
            c = ' ';

        copy[i] = c;  
    }
    
    copy[i] = 0;

    int wordOrder = 1;
    char* delimiters = " ";        
    for (char* token = strtok(copy, delimiters); token != NULL; 
        token = strtok(NULL, delimiters)) {
        String word(token);
        if (word.length() < 4)            // se  molto corta
            continue;
            
        if (stopWord.retrieve(word) >= 0)        // se  una stop word
            continue;

        Link<DocKey> link(word);
        int idx = dictionary.retrieve(link);
        if (idx < 0) 
            continue;

        int count = dictionary[idx].cnt();
        for (i = 0; i < count; ++i) {
            Candidate candidate(&dictionary[idx][i]);
            int id = candidates.retrieve(candidate);
            if (id < 0) {
                candidate.candy(-1/float(wordOrder));
                candidates.insert(candidate);
            }
            else
                candidates[id].candy(1/float(wordOrder));
                           
                  
        }
        ++wordOrder;
    }

    int count = candidates.cnt();
    for (i=0; i < count; ++i)
        elects.insert(candidates[i]);
    
    result.count = (number < count) ? number : count;
    if (result.count > 0) {
        delete[] result.items;
        result.items = new DocKey[result.count];
    }

    for (i=0; i < result.count; ++i) 
        result.items[i] = elects[i].getKey();

    return result;            
}


