#ifndef _FINDER_H_
#define _FINDER_H_

#include "sqlconnection.h"
#include "sqltypes.h"
#include "strings.h"
#include "array.h"

template <class T>
class SortArray {
public:
    SortArray(int _inc = 5);
    ~SortArray();

    void insert(const T & value);
    int retrieve(const T & value);
    T& operator [] (int idx);
    void reset();
    int cnt() {return count;}
    
protected:
    int inc;
    int count;
    int size;
    T* items;

    void extend();    
};

template <class T>
class Link {
public:
    Link(const String & _word = "");
    void link(T & key);
    inline T& operator [] (int idx);
    bool operator < (const Link & other) const; 
    bool operator > (const Link & other) const; 

    int cnt() {return keys.count();}
protected:
    String word;
    Array<T> keys;
};

class Candidate {
public:
    Candidate() {}
    Candidate(DocKey* _key);

    bool operator < (const Candidate & other) const; 
    bool operator > (const Candidate & other) const; 

    void candy(double value); 
protected:
    DocKey* key;
    float goodness;

    friend class Elected;
    
};

class Elected {
public:
    Elected() {}
    Elected(Candidate & candidate);

    bool operator < (const Elected & other) const; 
    bool operator > (const Elected & other) const; 

    DocKey & getKey();
protected:
    DocKey* key;
    float goodness;
   
};

class Finder {
public:
    Finder(SqlConnection* _connection);
    void update();
    KeyArray & select(const SqlString & oggetto, int number);
    
protected:
    SqlConnection* connection;
    SortArray< Link<DocKey> > dictionary;    
    SortArray<String> stopWord;
    KeyArray result;
    
    void insert(const char* c_anno, const char* c_numero, const char* oggetto);
    Link<DocKey>* search(const char* _word);  
    
};


template <class T>
T& SortArray<T>::operator [] (int idx) {
    return items[idx];
}

template <class T>
T& Link<T>::operator [] (int idx) {
    return keys[idx];
}

#endif