/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_BackUp.cc         ULTIMA MODIFICA: 08/07/2000        */
/*                                                                  */
/*  Implementazione della classe BackUp. (op=14)                    */
/*                                                                  */
/*------------------------------------------------------------------*/

#include <fstream.h>
#include <time.h>
#include "operation.h"
#include "html_utils.h"
#include "sys/stat.h"


BackUp::BackUp() {
    classname="BackUp";
    titpagine="Salvataggio del database su dischetti";
    risp="BackUp non ha ancora risposto";
    sprintf(baklogname, "baklog.txt");   // nome del file registro dei backup
    maxbakinterval=15;                   // max # di gg tra un backup e l'altro
    hardFile=NULL;
    initialized=0;
}


void BackUp::init(int id, SqlConnection* c) {
    userid=id;
    connection=c;

    aut_lettura=connection->autorizzato_lettura();
    aut_inserimento=connection->autorizzato_inserimento();
    aut_modifica=connection->autorizzato_modifica();
    aut_cancellazione=connection->autorizzato_cancellazione();
    
    if (hardFile!=NULL) {     // semplice norma di prudenza...
        fclose(hardFile);
        hardFile=NULL;
    }

    initialized=1;

    // controlla la data dell'ultimo backup effettuato aprendo il file
    // registro e controllando la data dell'ultimo successo
    fstream logfile;
    const int linesize=256;   
    char data[linesize];
    char esito[linesize];
    String risultato="fallito (errore sconosciuto)";
    SqlDate lastbackup("1/1/1900");   // "indicatore" ultimo backup
    SqlDate currbackup;
    int i;
    logfile.open(baklogname, ios::in);
    if (!logfile)
        cerr << userid << ": apertura del registro backup fallita" << endl;
    else
        // ciclo che determina la data dell'ultimo backup RIUSCITO;
	while (logfile >> data >> esito) {
            currbackup=data;
	    if ((strcmp(esito, "OK")==0)&&(currbackup>lastbackup))
	        lastbackup=currbackup;
	    logfile.ignore(linesize, '\n');
	}
    logfile.close();
    // prende la data corrente e la confronta con quella dell'ultimo
    // backup: se sono passati piu` di maxbakinterval giorni, allora
    // verra` tentato un backup automatico
    currbackup=datacorr();
    for(i=0; i<maxbakinterval; ++i) ++lastbackup;    // UGLY, very ugly
    if (currbackup<lastbackup) return;

    // c'e` bisogno del backup automatico
    cout << userid << ": sono passati piu` di " << maxbakinterval
         << " giorni dall'ultimo backup!" << endl;
    // il backup e` pero` possibile solo se l'utente ha l'autorizzazione
    // alla lettura
    if (!aut_lettura)
        risultato="fallito (automatico): utente non autorizzato alla lettura";
    else {
        String nomefile="cherubino"+datacorr().sql()+".dat";
        String command="mysqldump -u "+userName+" --password="+userPwd
	    +" cherubino > "+nomefile;
	i=system(command.cString());
	command="gzip -f "+nomefile;
	i=i+system(command.cString());
        if (i==0) risultato="OK (automatico)";
	else risultato="fallito (automatico), colpa di mysqldump o gzip";
    }
    cout << userid << ": backup " << risultato << endl;
    logfile.open(baklogname, ios::app);
    if (logfile) logfile << datacorr().html() << " " << risultato << endl;
    logfile.close();
}


FILE* BackUp::createSave() {
    off_t byteToRead = 1024*1400;
    String command = "mysqldump -u " + userName + " --password=" +
                userPwd + " cherubino > /tmp/cherubino.dat";
    if (system(command.cString())!=0) throwException(Error("executing "+command));
    cout << userid << ": dB dump OK" << endl;
    command = "gzip -f /tmp/cherubino.dat";
    if (system(command.cString())!=0) throwException(Error("executing "+command));
    cout << userid << ": compressione dump con gzip OK" << endl;

    struct stat info;
    stat("/tmp/cherubino.dat.gz", &info);
    
    off_t size = info.st_size;
    
    diskNumber = (size / byteToRead) + 1;
    part = 1;
    return fopen("/tmp/cherubino.dat.gz", "rb");
}


bool BackUp::copySave(FILE* hardFile) {
    FILE* floppyFile;
    String commandcanc, commandcopy;
    int resultcanc, resultcopy;
    String fileName = "monk"+String(part)+".db";
    int byteToRead = 1024*1400;
    char* buffer = new char[byteToRead];
    
    floppyFile = fopen("/tmp/monk.spt", "wb");

    int remain = diskNumber - part;
    fwrite(&remain, 1, sizeof(remain), floppyFile);
    int bytesReaden = fread(buffer, 1, byteToRead, hardFile);
    fwrite(buffer, 1, bytesReaden, floppyFile);
    delete[] buffer;
    fclose(floppyFile);
    
#ifdef __CYGWIN__
    commandcanc = "rm -rf a:";
    commandcopy = "cp /tmp/monk.spt a:monk" + String(part) + ".gz";
#else
    commandcanc = "mformat a:";
    commandcopy = "mcopy /tmp/monk.spt a:monk" + String(part) + ".gz";
#endif
    resultcanc = system(commandcanc.cString());
    if ((resultcanc!=0)&&(resultcanc!=256))
        throwException(Error("executing '"+commandcanc+"', error code "+resultcanc));
    resultcopy = system(commandcopy.cString());
    if (resultcopy!=0)
        throwException(Error("executing '"+commandcopy+"', error code "+resultcopy));

    cout << userid << ": copia su floppy " << part << " OK" << endl;

    ++part;
    return (bytesReaden == byteToRead);
}


void BackUp::stage0_process(stringone* strngn) {
    if (hardFile!=NULL) fclose(hardFile);    // nel caso l'utente avesse premuto "Annulla"
    hardFile = createSave();
    stage1_showpage();
}


void BackUp::stage1_showpage() {
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="function salta(url) { self.location=url; }\n";
    risp+="// --></SCRIPT>\n";
    
    risp+="<FONT FACE=\"Times\">\n";
    risp+="L'operazione di backup permette di salvare su dischetti l'intero\n";
    risp+="contenuto del database.<BR>\n";
    risp+="Nelle pagine seguenti verr chiesto di inserire <STRONG>";
    risp+= String(diskNumber) + "</STRONG> dischetti gi formattati.<BR>\n";
    risp+="Il tempo di attesa tra una schermata e l'altra  normale ed  dovuto\n";
    risp+="alla lentezza con cui i dati vengono trasferiti sul dischetto.<BR>\n";
    risp+="NOTE. Tutto ci che si trova sui dischetti verr automaticamente\n";
    risp+="<STRONG>cancellato</STRONG>. L'operazione di backup non pu essere\n";
    risp+="effettuata in rete. Prima di inserire un dischetto, assicurarsi che\n";
    risp+="la protezione dalla scrittura sia disattivata.<BR>\n";

    risp+="<BR><BR>\n";
    risp+="<STRONG> Inserire il dischetto "+String(part);
    risp+=" e premere il tasto \"Avanti >\"</STRONG>\n<BR><BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=14>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
}


void BackUp::stage2_showpage() {
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="function salta(url) { self.location=url; }\n";
    risp+="// --></SCRIPT>\n";
    
    risp+="<FONT FACE=\"Times\">\n";
    risp+="<BR><BR>\n";
    risp+="<STRONG> Inserire il dischetto "+String(part);
    risp+=" e premere il tasto \"Avanti >\"</STRONG>\n<BR><BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=14>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
}


void BackUp::stage3_showpage() {
    risp+="<FONT FACE=\"Times\">\n";
    risp+="Operazione di backup completata con successo.<BR>\n";

    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
}



void BackUp::stage1_process(stringone* strngn) {
    if (copySave(hardFile) == true)
        stage2_showpage();
    else {
        fclose(hardFile);
	hardFile=NULL;
        system("rm -f /tmp/cherubino.dat.gz");
        system("rm -f /tmp/monk.spt");
	// Aggiorna il file registro dei backup
        fstream logfile;
        logfile.open(baklogname, ios::app);
        if (logfile) logfile << datacorr().html() << " OK username " << userName << endl;
        logfile.close();
        stage3_showpage();
    }
}


String& BackUp::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>BackUp:la classe non  stata inizializzata.</BODY>\n";
        return risp;
    }

    // stampa l'intestazione
    risp=beginbody();
    risp+=big_title(titpagine);

    try {
    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
            stage0_process(strngn);
        break;
        case 1:
            stage1_process(strngn);
        break;
        default:
            risp+="BackUp: contenuto del token 'stage' non valido.<BR>\n";
        break;
    }        

    risp+=endbody();
   }
    
    catch (Error error) {
        risp=beginbody();
        risp+=big_title(titpagine);
        risp+="<FONT FACE=\"Times\">\n";
        risp+="Errore durante il backup: " + error.description() + "<BR>\n";

        risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
        risp+="</FONT>\n";
	// Scrive l'errore nel file registro dei backup
        fstream logfile;
        logfile.open(baklogname, ios::app);
        if (logfile) logfile << datacorr().html() << " fallito username " << userName << endl;
        logfile.close();
    }

    
    return risp;
}


void BackUp::reset() {

}
