/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_CancCA.cc         ULTIMA MODIFICA: 11/08/1999        */
/*                                                                  */
/*  Implementazione della classe CancCA. (op=15)                    */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


CancCA::CancCA() {
    classname="CancCA";
    titpagine="Cancellazione di un corrispondente/affidatario/dipendente";
    risp="CancCA non ha ancora risposto";
    initialized=0;
}


void CancCA::stage1_showpage() {
    risp="<FRAMESET FRAMEBORDER=YES ROWS=60,40>\n";
    risp=risp+"    <FRAME NAME=\"Frame1\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=15&stage=1&frames=si\">\n";
    risp=risp+"    <FRAME NAME=\"Frame2\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=8&type=2&letter=A\">\n";
    risp=risp+"</FRAMESET>\n";
}


void CancCA::stage1_showframe1() {
    risp="<HEAD><BASE TARGET=\"_top\"></HEAD>\n";
    risp+=beginbody();
    risp+=big_title(titpagine);
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"codiceca\");\n";
    risp+="    var reqFieldsNames=new Array(\"Codice del corrispondente/affidatario/dipendente\");\n";
    risp+="    var numFields=new Array(\"codiceca\");\n";
    risp+="    var numFieldsNames=new Array(\"Codice del corrispondente/affidatario/dipendente\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa pagina,  possibile specificare il codice del corrispondente,\n";
    risp+="affidatario o dipendente di cui si vogliono cancellare le informazioni.<BR>\n";
    risp+="Per procedere alla cancellazione, premere il tasto \"Cancella\".<BR>\n";
    risp+="Per annullare la cancellazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. Il campo <STRONG>Codice</STRONG>  obbligatorio.\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=15>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    <STRONG>Codice del corrispondente/affidatario/dipendente</STRONG>:\n";
    risp=risp+"    <INPUT TYPE=TEXT NAME=\"codiceca\" VALUE=\"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Cancella\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta2('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="<TABLE WIDTH=100% BGCOLOR=\"#CCCCDD\"><TR>\n<TD>\n";
    char l[2];
    l[1]='\0';
    for(*l='A';*l<='Z';++*l)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=8&type=2&letter="
             +l+"\" TARGET=\"Frame2\">"+l+"</A>\n";
    risp+="</TD></TR></TABLE>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void CancCA::stage1_process(stringone* strngn) {
    char* buff;
    SqlInt codiceca;

    risp=beginbody();
    risp+=big_title(titpagine);
    risp+="<FONT FACE=\"Times\">\n";

    // determina il codice del c/a/d da cancellare
    buff=check_keytoken(strngn,"codiceca");
    if(buff!=NULL) codiceca=buff; else return;
    
    // esegue l'effettiva cancellazione dalla base dati
    bool OK=1;
    try { connection->cancCA(codiceca); }
    catch(SqlConnection::GenericError error) {
        OK=0;
        risp+=errore(error.toString(), "cancellazione del corrisp./affidatario fallita");
    }
    if(OK) risp+="Cancellazione completata con successo.<BR>\n";

    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
    risp+=endbody();
}


String& CancCA::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>CancCA:la classe non  stata inizializzata.</BODY>\n";
        return risp;
    }

    risp="";

    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
            stage1_showpage();
        break;
        case 1:
            if(strngn->findtoken("frames")!=NULL) stage1_showframe1();
            else stage1_process(strngn);
        break;
        default:
            risp="<BODY>CancCA: contenuto del token 'stage' non valido.</BODY>\n";
        break;
    }        

    return risp;
}
