/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_InsAff.cc         ULTIMA MODIFICA: 11/08/1999        */
/*                                                                  */
/*  Implementazione della classe InsAff. (op=4)                     */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


InsAff::InsAff() {
    classname="InsAff";
    titpagine="Prestito/restituzione di un carico";
    risp="InsAff non ha ancora risposto";
    initialized=0;
}


void InsAff::stage1_showpage() {
    risp="<FRAMESET FRAMEBORDER=YES ROWS=60,40>\n";
    risp=risp+"    <FRAME NAME=\"Frame1\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=4&stage=1&frames=si\">\n";
    risp=risp+"    <FRAME NAME=\"Frame2\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=8&type=2&letter=A\">\n";
    risp=risp+"</FRAMESET>\n";
}


void InsAff::stage1_showframe1() {
    risp="<HEAD><BASE TARGET=\"_top\"></HEAD>\n";
    risp+=beginbody();
    risp+=big_title(titpagine);
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"Anno_carico\",\"Numero_carico\");\n";
    risp+="    var reqFieldsNames=new Array(\"Anno\",\"Numero di protocollo\");\n";
    risp+="    var numFields=new Array(\"Anno_carico\",\"Numero_carico\",\"codiceca\");\n";
    risp+="    var numFieldsNames=new Array(\"Anno\",\"Numero di protocollo\",\"Codice della persona/organizzazione\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Questa pagina permette di registrare l'avvenuto prestito di un carico,\n";
    risp+="oppure di segnalare che un carico  stato restituito.\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="\"Presta\" per prestare il carico alla persona/organizzazione specificata;<BR>\n";
    risp+="premere invece il tasto \"Restituisci\" per notificare una restituzione.<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. I campi indicati in <STRONG>grassetto</STRONG> sono obbligatori.\n";
    risp+="Se non si conoscono l'anno e il numero di protocollo del carico, si\n";
    risp=risp+"consiglia di andare alla pagina della <A HREF=\""+BRIDGE_PATH
         +"?userid="+userid+"&op=9&stage=0\" TARGET=\"_top\">"+"ricerca di documenti</A>\n";
    risp+="e di effettuare poi il prestito (o la restituzione) da l.<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=4>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"type\" VALUE=\"aff\">\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Anno</STRONG>: <INPUT TYPE=TEXT NAME=\"Anno_carico\"  VALUE="+Anno_carico.html()+" SIZE=4 MAXLENGTH=4>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Numero di protocollo</STRONG>: <INPUT TYPE=TEXT NAME=\"Numero_carico\" VALUE=\""+Numero_carico.html()+"\" SIZE=10 MAXLENGTH=40><BR>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    Codice della persona/organizzazione:\n";
    risp=risp+"    <INPUT TYPE=TEXT NAME=\"codiceca\" VALUE=\""+codiceca.html()+"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Presta\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Restituisci\" onClick=\"cambia_tipo(modulo,'rest')\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta2('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="<TABLE WIDTH=100% BGCOLOR=\"#CCCCDD\"><TR>\n<TD>\n";
    char l[2];
    l[1]='\0';
    for(*l='A';*l<='Z';++*l)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=8&type=2&letter="
             +l+"\" TARGET=\"Frame2\">"+l+"</A>\n";
    risp+="</TD><TD ALIGN=\"right\">\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=3&stage=0\" TARGET=\"Frame2\">Aggiungi...</A>\n";
    risp+="</TD></TR></TABLE>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void InsAff::stage3_showpage() {
    risp="<FRAMESET FRAMEBORDER=YES ROWS=60,40>\n";
    risp=risp+"    <FRAME NAME=\"Frame1\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=4&stage=3&frames=si\">\n";
    risp=risp+"    <FRAME NAME=\"Frame2\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=8&type=2&letter=A\">\n";
    risp=risp+"</FRAMESET>\n";
}


void InsAff::stage3_showframe1() {
    risp="<HEAD><BASE TARGET=\"_top\"></HEAD>\n";
    risp+=beginbody();
    risp+=big_title(titpagine);
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"codiceca\");\n";
    risp+="    var reqFieldsNames=new Array(\"Codice della persona/organizzazione\");\n";
    risp+="    var numFields=new Array(\"codiceca\");\n";
    risp+="    var numFieldsNames=new Array(\"Codice della persona/organizzazione\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa pagina,  possibile specificare la persona o l'organizzazione\n";
    risp+"a cui affidare il carico.<BR>\n";
    risp+="Per effettuare il prestito, premere il tasto \"Presta\".<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. Il campo <STRONG>Codice</STRONG>  obbligatorio.\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=4>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=3>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"type\" VALUE=\"aff\">\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    <STRONG>Codice della persona/organizzazione</STRONG>:\n";
    risp=risp+"    <INPUT TYPE=TEXT NAME=\"codiceca\" VALUE=\""+codiceca.html()+"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Presta\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta2('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="<TABLE WIDTH=100% BGCOLOR=\"#CCCCDD\"><TR>\n<TD>\n";
    char l[2];
    l[1]='\0';
    for(*l='A';*l<='Z';++*l)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=8&type=2&letter="
             +l+"\" TARGET=\"Frame2\">"+l+"</A>\n";
    risp+="</TD><TD ALIGN=\"right\">\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=3&stage=0\" TARGET=\"Frame2\">Aggiungi...</A>\n";
    risp+="</TD></TR></TABLE>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void InsAff::affida() {
    risp="<HEAD><BASE TARGET=\"_top\"></HEAD>\n";
    risp+=beginbody();
    risp+=big_title(titpagine);
    risp+="<FONT FACE=\"Times\">\n";
    
    // decide l'operaz. da compiere in base al comntenuto di "type"
    SqlDate DataOggi=datacorr();
    bool OK=1;
    try {
        if(type=="aff")
            connection->insertAffidamento(Anno_carico, Numero_carico, codiceca, DataOggi);
        else
            connection->insertFineAffidamento(Anno_carico, Numero_carico, DataOggi);
    }
    catch (SqlConnection::GenericError error) {
        OK=0;
        risp+=errore(error.toString(), "operazione non riuscita");
    }
    if(OK) risp+="Operazione completata con successo.<BR>\n";
        
    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
    risp+=endbody();
}


void InsAff::stage1_process(stringone* strngn) {
    char* buff;

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_keytoken(strngn,"type");
    if(buff!=NULL) type=buff; else return;

    buff=check_keytoken(strngn,"Anno_carico");
    if(buff!=NULL) Anno_carico=buff; else return;

    buff=check_keytoken(strngn,"Numero_carico");
    if(buff!=NULL) Numero_carico=buff; else return;

    if(type=="aff") {
        buff=check_keytoken(strngn,"codiceca");
        if(buff!=NULL) codiceca=buff; else return;
    } else {
        buff=check_token(strngn,"codiceca");
        if(buff!=NULL) codiceca=buff; else codiceca=null;
    }
    
    // esegue l'operazione di affidamento
    affida();
}


void InsAff::stage2_process(stringone* strngn) {
    char* buff;

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_keytoken(strngn,"type");
    if(buff!=NULL) type=buff; else return;

    buff=check_keytoken(strngn,"Anno_carico");
    if(buff!=NULL) Anno_carico=buff; else return;

    buff=check_keytoken(strngn,"Numero_carico");
    if(buff!=NULL) Numero_carico=buff; else return;

    // decide il da farsi in base al contenuto di "type"
    if(type=="aff") stage3_showpage(); else affida();
}


void InsAff::stage3_process(stringone* strngn) {
    char* buff;
    
    // aggiorna il contenuto della variabile codiceca
    // in base al contenuto del token omonimo
    if(type=="aff") {
        buff=check_keytoken(strngn,"codiceca");
        if(buff!=NULL) codiceca=buff; else return;
    } else {
        buff=check_token(strngn,"codiceca");
        if(buff!=NULL) codiceca=buff; else codiceca=null;
    }

    // esegue l'operazione di affidamento
    affida();
}


String& InsAff::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>InsAff:la classe non  stata inizializzata.</BODY>\n";
        return risp;
    }
    risp="";
    
    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
            stage1_showpage();
        break;
        case 1:
            if(strngn->findtoken("frames")!=NULL) stage1_showframe1();
            else stage1_process(strngn);
        break;
        case 2:
            stage2_process(strngn);
        break;
        case 3:
            if(strngn->findtoken("frames")!=NULL) stage3_showframe1();
            else stage3_process(strngn);
        break;
        default:
            risp="<BODY>InsAff: contenuto del token 'stage' non valido.</BODY>\n";
        break;
    }        

    return risp;
}


void InsAff::reset() {
    Anno_carico=annocorr();
    Numero_carico=null;
    codiceca=null;
    type="aff";
}
