/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_InsCA.cc          ULTIMA MODIFICA: 18/07/1999        */
/*                                                                  */
/*  Implementazione della classe InsCA. (op=3)                      */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


InsCA::InsCA() {
    classname="InsCA";
    titpagine="Inserimento di un nuovo corrispondente/affidatario";
    risp="InsCA non ha ancora risposto";
    initialized=0;
}


void InsCA::stage1_showpage() {
    risp+=small_title("Pagina 1 di 3");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"Denominaz1\",\"Tipo\");\n";
    risp+="    var reqFieldsNames=new Array(\"Denominazione1\",\"Tipo di corrispondente/affidatario\");\n";
    risp+="    var numFields=new Array(\"Cap\");\n";
    risp+="    var numFieldsNames=new Array(\"CAP\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Questa pagina permette di inserire le informazioni relative a\n";
    risp+="una persona o una organizzazione che hanno a che vedere con il\n";
    risp+="protocollo della biblioteca; pu trattarsi di:\n";
    risp+="<BR><LI>una persona o organizzazione che intrattiene corrispondenza con\n";
    risp+="la biblioteca e a cui possono essere affidati dei documenti;\n";
    risp+="<BR><LI>un soggetto esterno (persona o organizzazione) cui possono essere\n";
    risp+="affidati dei documenti ma con cui non si scambia corrispondenza;\n";
    risp+="<BR><LI>un dipendente della biblioteca.\n";
    risp+="<BR>Dato che le informazioni che descrivono un corrispondente/affidatario\n";
    risp+="sono molte, l'inserimento avverr attraverso pi pagine; questa prima pagina\n";
    risp+="contiene le informazioni di carattere generale.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="con il simbolo \"Avanti >\" per passare alla pagina successiva.<BR>\n";
    risp+="Per annullare l'inserimento e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. I campi indicati in <STRONG>grassetto</STRONG> sono obbligatori.\n";
    risp+="Al termine dell'inserimento, il programma assegner al corrispondente/affidatario\n";
    risp+="un codice univoco.<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=3>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Denominazione1</STRONG>: (cognome di una persona, o nome di un'organizzazione)<BR>\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"Denominaz1\" VALUE=\""+Denominaz1.html()+"\" SIZE=40 MAXLENGTH=40>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Denominazione2: (nome di una persona, o divisione di un'organizzazione)<BR>\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"Denominaz2\" VALUE=\""+Denominaz2.html()+"\" SIZE=40 MAXLENGTH=40>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"        <STRONG>Tipo di corrispondente/affidatario</STRONG>:\n";
    risp=risp+"        <SELECT NAME=\"Tipo\">\n";
    risp=risp+"        <OPTION VALUE=\"corr_persona\"";
    if(Tipo=="corr_persona") risp+=" SELECTED";
    risp=risp+ ">Corrispondente (persona)\n";
    risp=risp+"        <OPTION VALUE=\"corr_org\"";
    if(Tipo=="corr_org") risp+=" SELECTED";
    risp=risp+ ">Corrispondente (organizzazione)\n";
    risp=risp+"        <OPTION VALUE=\"aff_persona\"";
    if(Tipo=="aff_persona") risp+=" SELECTED";
    risp=risp+ ">Affidatario (persona)\n";
    risp=risp+"        <OPTION VALUE=\"aff_org\"";
    if(Tipo=="aff_org") risp+=" SELECTED";
    risp=risp+ ">Affidatario (organizzazione)\n";
    risp=risp+"        <OPTION VALUE=\"dipendente\"";
    if(Tipo=="dipendente") risp+=" SELECTED";
    risp=risp+ ">Dipendente della biblioteca\n";
    risp=risp+"        </SELECT>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"        Via: <INPUT TYPE=TEXT NAME=\"Via\" VALUE=\""+Via.html()+"\" SIZE=40 MAXLENGTH=50>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Citt: <INPUT TYPE=TEXT NAME=\"Citta\" VALUE=\""+Citta.html()+"\" SIZE=20 MAXLENGTH=30>\n";
    risp=risp+"        CAP: <INPUT TYPE=TEXT NAME=\"Cap\" VALUE=\""+Cap.html()+"\" SIZE=6 MAXLENGTH=6>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Telefono: <INPUT TYPE=TEXT NAME=\"Telefono\" VALUE=\""+Telefono.html()+"\" SIZE=15 MAXLENGTH=25>\n";
    risp=risp+"        FAX: <INPUT TYPE=TEXT NAME=\"Fax\" VALUE=\""+Fax.html()+"\" SIZE=15 MAXLENGTH=25>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
}


void InsCA::stage2_showpage() {
    risp+=small_title("Pagina 2 di 3");
    risp+=javascript_standard();
    risp+="<FONT FACE=\"Times\">\n";

    risp+="In questa pagina,  possibile inserire alcune informazioni aggiuntive\n";
    if(Tipo=="dipendente") risp+="relative al dipendente.<BR>\n";
    if((Tipo=="corr_persona")||(Tipo=="aff_persona")) risp+="relative alla persona.<BR>\n";
    if((Tipo=="corr_org")||(Tipo=="aff_org")) risp+="relative all'organizzazione.<BR>\n";
    risp+="Dopo questa pagina, tutti i dati fin qui digitati verranno effettivamente\n";
    risp+="inseriti nel database e al";
    if(Tipo=="dipendente") risp+=" dipendente";
    if((Tipo=="corr_persona")||(Tipo=="aff_persona")) risp+="la persona";
    if((Tipo=="corr_org")||(Tipo=="aff_org")) risp+="l'organizzazione";
    risp+=" verr assegnato un codice univoco.<BR>\n";
    risp+="Per procedere con l'inserimento, premere sul tasto con il simbolo \"Avanti >\".<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare l'inserimento e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";    

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=3>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=2>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    if(Tipo=="dipendente") {
        risp=risp+"    <BR>\n";
        risp=risp+"        Ufficio in cui il dipendente lavora:<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"Ufficio\" VALUE=\""+Ufficio.html()
	     +"\" SIZE=40 MAXLENGTH=50>\n";
    }
    if((Tipo=="corr_persona")||(Tipo=="aff_persona")) {
        risp=risp+"    <BR>\n";
        risp=risp+"        Codice fiscale:<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"CodFisc\" VALUE=\""+CodFisc.html()
	     +"\" SIZE=20 MAXLENGTH=16>\n";
        risp=risp+"    <BR>\n";
        risp=risp+"        Titolo: (professore, dottore, cavaliere, ecc.)<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"Titolo\" VALUE=\""+Titolo.html()
	     +"\" SIZE=30 MAXLENGTH=30>\n";
    }
    if((Tipo=="corr_org")||(Tipo=="aff_org")) {
        risp=risp+"    <BR>\n";
        risp=risp+"        Partita IVA:<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"Piva\" VALUE=\""+Piva.html()
	     +"\" SIZE=20 MAXLENGTH=20>\n";
        risp=risp+"    <BR>\n";
        risp=risp+"        Tramite: (nome della persona con cui si  in contatto all'interno dell'organizzazione)<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"Tramite\" VALUE=\""+Tramite.html()
	     +"\" SIZE=40 MAXLENGTH=50>\n";
    }
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
}


void InsCA::stage1_process(stringone* strngn) {
    char* buff;

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_keytoken(strngn,"Denominaz1");
    if(buff!=NULL) Denominaz1=buff; else return;

    buff=check_token(strngn,"Denominaz2");
    if(buff!=NULL) Denominaz2=buff; else Denominaz2=null;

    buff=check_keytoken(strngn,"Tipo");
    if(buff!=NULL) Tipo=buff; else return;

    buff=check_token(strngn,"Via");
    if(buff!=NULL) Via=buff; else Via=null;

    buff=check_token(strngn,"Citta");
    if(buff!=NULL) Citta=buff; else Citta=null;

    buff=check_token(strngn,"Cap");
    if(buff!=NULL) Cap=buff; else Cap=null;

    buff=check_token(strngn,"Telefono");
    if(buff!=NULL) Telefono=buff; else Telefono=null;

    buff=check_token(strngn,"Fax");
    if(buff!=NULL) Fax=buff; else Fax=null;
    
    // mostra la pagina HTML dello stage 2
    stage2_showpage();
}


void InsCA::stage2_process(stringone* strngn) {
    char* buff;
    int OK=0;

    risp+=small_title("Pagina 3 di 3");
    risp+="<FONT FACE=\"Times\">\n";
    
    // aggiorna il contenuto delle variabili in base ai valori contenuti nei
    // token; i token da controllare sono scelti in base al contenuto della
    // variabile privata "Tipo" 
    if(Tipo=="dipendente") {
        OK=1;
        buff=check_token(strngn,"Ufficio");
        if(buff!=NULL) Ufficio=buff; else Ufficio=null;
    }
    if((Tipo=="corr_persona")||(Tipo=="aff_persona")) {
        OK=1;
        buff=check_token(strngn,"CodFisc");
        if(buff!=NULL) CodFisc=buff; else CodFisc=null;
        buff=check_token(strngn,"Titolo");
        if(buff!=NULL) Titolo=buff; else Titolo=null;
    }
    if((Tipo=="corr_org")||(Tipo=="aff_org")) {
        OK=1;
        buff=check_token(strngn,"Piva");
        if(buff!=NULL) Piva=buff; else Piva=null;
        buff=check_token(strngn,"Tramite");
        if(buff!=NULL) Tramite=buff; else Tramite=null;
    }
    
    // Se OK=0, c'e` qualcosa che non va!
    if(!OK) {
        risp+="InsCA: non riesco a determinare il tipo di corrispondente/affidatario.<BR><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
	return;
    }
    
    // se invece OK=1, decide il da farsi in base al contenuto del token "direz"
    buff=check_keytoken(strngn,"direz");
    if(buff==NULL) return;
    if(strcmp(buff,"indietro")==0) stage1_showpage(); else {
        // esegue l'effettivo inserimento nella base dati
        bool OK=1;
        int codice;
	SqlString vuoto=null;
        try {
            codice=connection->insertCorrispondente_affidatario(Denominaz1,
	        Denominaz2, Tipo, Via, Citta, Cap, Telefono, Fax, "VALIDO");
            if(((Tipo=="corr_persona")||(Tipo=="aff_persona"))&&((Titolo!=vuoto)||
	       (CodFisc!=vuoto))) connection->insertCorrispPersona(codice, Titolo, CodFisc);
            if(((Tipo=="corr_org")||(Tipo=="aff_org"))&&((Piva!=vuoto)||
	       (Tramite!=vuoto))) connection->insertCorrispOrganizzazione(codice, Piva, Tramite);
            if((Tipo=="dipendente")&&(Ufficio!=vuoto))
	       connection->insertDipendenteInfoAgg(codice, Ufficio, "1000");
        }
	catch (SqlConnection::GenericError error) {
            OK=0;
            risp+=errore(error.toString(), "inserimento non riuscito");
        }
        if(OK) {
	    risp+="Inserimento completato con successo.<BR>\n";
	    risp=risp+"Al corrispondente/affidatario  stato assegnato il codice "
	         +codice+".<BR>\n";
	}
        risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
        risp+="</FONT>\n";
    } // fine del codice per l'inserimento nella base dati
}


String& InsCA::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>InsCA:la classe non  stata inizializzata.</BODY>\n";
	return risp;
    }
    
    // stampa l'intestazione
    risp=beginbody();
    risp+=big_title(titpagine);

    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
	    stage1_showpage();
	break;
	case 1:
	    stage1_process(strngn);
	break;
	case 2:
	    stage2_process(strngn);
	break;
	default:
	    risp+="InsCA: contenuto del token 'stage' non valido.<BR>\n";
	break;
    }        

    risp+=endbody();
    return risp;
}


void InsCA::reset() {
    Denominaz1=null;
    Denominaz2=null;
    Tipo="corr_persona";
    Via=null;
    Citta=null;
    Cap=null;
    Telefono=null;
    Fax=null;
    Titolo=null;
    CodFisc=null;
    Piva=null;
    Tramite=null;
    Ufficio=null;
}
