/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_InsDoc.cc         ULTIMA MODIFICA: 18/06/2000        */
/*                                                                  */
/*  Implementazione della classe InsDoc. (op=1)                     */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


InsDoc::InsDoc() {
    classname="InsDoc";
    titpagine="Inserimento di un nuovo documento";
    risp="InsDoc non ha ancora risposto";
    initialized=0;
}


void InsDoc::stage1_showpage() {
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 1 di 4");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"Anno\",\"Oggetto\");\n";
    risp+="    var reqFieldsNames=new Array(\"Anno\",\"Oggetto\");\n";
    risp+="    var numFields=new Array(\"Anno\");\n";
    risp+="    var numFieldsNames=new Array(\"Anno\");\n";
    risp+="    var dateFields=new Array(\"Ladata\");\n";
    risp+="    var dateFieldsNames=new Array(\"Data\");\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Dato che le informazioni che descrivono un documento sono molte,\n";
    risp+="l'inserimento avverr attraverso pi pagine; questa prima pagina\n";
    risp+="contiene le informazioni di carattere generale.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="con il simbolo \"Avanti >\" per passare alla pagina successiva.<BR>\n";
    risp+="Per annullare l'inserimento e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. I campi indicati in <STRONG>grassetto</STRONG> sono obbligatori.\n";
    risp+="Il numero di protocollo verr assegnato al documento solo al termine\n";
    risp+="dell'inserimento.<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=1>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Anno</STRONG>: <INPUT TYPE=TEXT NAME=\"Anno\"  VALUE="+Anno.html()+" SIZE=4 MAXLENGTH=4>\n";
    risp=risp+"        Data: <INPUT TYPE=TEXT NAME=\"Ladata\" VALUE=\""+Ladata.html()+"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Oggetto</STRONG>:<TEXTAREA NAME=\"Oggetto\" ROWS=3 COLS=40>"+Oggetto.html()+"</TEXTAREA>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Categoria documento:\n";
    risp=risp+"        <INPUT TYPE=RADIO NAME=\"cat\" VALUE=\"carico\"";
    if(cat=="carico") risp+=" CHECKED";
    risp+=">carico\n";
    risp=risp+"        <INPUT TYPE=RADIO NAME=\"cat\" VALUE=\"scarico\"";
    if(cat=="scarico") risp+=" CHECKED";
    risp+=">scarico\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Tipo documento:\n";
    risp=risp+"        <SELECT NAME=\"Tipo_documento\">\n";
    risp=risp+"        <OPTION VALUE=\"lettera\"";
    if(Tipo_documento=="lettera") risp+=" SELECTED";
    risp=risp+">lettera\n";
    risp=risp+"        <OPTION VALUE=\"FAX\"";
    if(Tipo_documento=="FAX") risp+=" SELECTED";
    risp=risp+">FAX\n";
    risp=risp+"        <OPTION VALUE=\"e-mail\"";
    if(Tipo_documento=="e-mail") risp+=" SELECTED";
    risp=risp+">e-mail\n";
    risp=risp+"        <OPTION VALUE=\"altro\"";
    if(Tipo_documento=="altro") risp+=" SELECTED";
    risp=risp+">altro\n";
    risp=risp+"        </SELECT>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void InsDoc::stage2_showpage() {
    risp="<FRAMESET FRAMEBORDER=YES ROWS=60,40>\n";
    risp=risp+"    <FRAME NAME=\"Frame1\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=1&stage=2&frames=si\">\n";
    risp=risp+"    <FRAME NAME=\"Frame2\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=8&type=1&letter=A\">\n";
    risp=risp+"</FRAMESET>\n";
}


void InsDoc::stage2_showframe1() {
    risp="<HEAD><BASE TARGET=\"_top\"></HEAD>\n";
    risp+=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 2 di 4");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=\"\";\n    var reqFieldsNames=\"\";\n";
    risp+="    var numFields=new Array(\"codiceca\");\n";
    risp+="    var numFieldsNames=new Array(\"Codice del mittente/destinatario\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa seconda pagina,  possibile specificare il mittente (o destinatario)\n";
    risp+="di un documento, inserendo direttamente il suo codice oppure scegliendolo da\n";
    risp+="una lista.<BR>\n";
    risp+="Per inserire un nuovo mittente/destinatario, fare clic su \"Aggiungi...\".<BR>\n";
    risp+="Per procedere alla fase successiva dell'inserimento, premere il tasto \"Avanti >\".<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare l'inserimento e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=1>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=2>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    Codice del mittente/destinatario:\n";
    risp=risp+"    <INPUT TYPE=TEXT NAME=\"codiceca\" VALUE=\""+codiceca.html()+"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta2('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="<TABLE WIDTH=100% BGCOLOR=\"#CCCCDD\"><TR>\n<TD>\n";
    char l[2];
    l[1]='\0';
    for(*l='A';*l<='Z';++*l)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=8&type=1&letter="
             +l+"\" TARGET=\"Frame2\">"+l+"</A>\n";
    risp+="</TD><TD ALIGN=\"right\">\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=3&stage=0\" TARGET=\"Frame2\">Aggiungi...</A>\n";
    risp+="</TD></TR></TABLE>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void InsDoc::stage3_showpage() {
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 3 di 4");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=\"\";\n    var reqFieldsNames=\"\";\n";
    if(cat=="carico") {
        risp+="    var numFields=\"\";\n    var numFieldsNames=\"\";\n";
        risp+="    var dateFields=new Array(\"Data_atto\",\"Data_fax\");\n";
        risp+="    var dateFieldsNames=new Array(\"Data atto\",\"Data FAX di preavviso\");\n";
    } else {
        risp+="    var numFields=new Array(\"Anno_carico\",\"Num_carico\");\n";
        risp+="    var numFieldsNames=new Array(\"Anno carico associato\",\"Numero carico associato\");\n";
        risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    }
    risp+="// --></SCRIPT>\n";

    // esegue una query per avere una lista dei riparti disponibili
    SqlResult* R;
    try { R=connection->queryRiparto(); }
    catch(SqlConnection::GenericError error) {
        risp=errore(error.toString(), "query dei riparti fallita");
        return;
    }

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa terza pagina,  possibile assegnare il documento ad un riparto\n";
    if(cat=="carico")
        risp+="e inserire alcune informazioni specifiche per un carico.<BR>\n";
    else
        risp+="e inserire alcune informazioni specifiche per uno scarico.<BR>\n";
    risp+="Dopo questa pagina, tutti i dati fin qui digitati verranno effettivamente\n";
    risp+="inseriti nel database e al documento verr assegnato un numero di protocollo.<BR>\n";
    risp+="Per procedere con l'inserimento, premere il tasto \"Avanti >\".<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare l'inserimento e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=1>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=3>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    risp=risp+"    <BR>\n";
    risp=risp+"Riparto a cui assegnare il documento:<BR>\n";
    risp=risp+"    <SELECT TYPE=TEXT SIZE=5 NAME=\"Riparto\">\n";
    // adesso sfrutta la lista dei riparti ottenuta prima
    int i,imax;
    imax=R->rowNum();
    for(i=0;i<imax;++i)
        risp=risp+"        <OPTION VALUE=\""+fn(R->get(i,0))+"\">"+fn(R->get(i,0))
             +" - "+fn2(R->get(i,1))+"\n";
    // fine del codice relativo ai riparti
    risp=risp+"    </SELECT><BR><BR>\n";
    if(cat=="carico") {
        risp=risp+"        Data atto: <INPUT TYPE=TEXT NAME=\"Data_atto\" VALUE=\""
            +Data_atto.html()+"\" SIZE=10 MAXLENGTH=20><BR>\n";
        risp=risp+"        Numero atto: <INPUT TYPE=TEXT NAME=\"Num_atto\" VALUE=\""
            +Num_atto.html()+"\" SIZE=10 MAXLENGTH=40><BR>\n";
        risp=risp+"        Data FAX di preavviso: <INPUT TYPE=TEXT NAME=\"Data_fax\" VALUE=\""
            +Data_fax.html()+"\" SIZE=10 MAXLENGTH=10>\n";
    } else {
        risp=risp+"        Anno carico associato: <INPUT TYPE=TEXT NAME=\"Anno_carico\" VALUE=\""
             +Anno_carico.html()+"\" SIZE=10 MAXLENGTH=10><BR>\n";
        risp=risp+"        Numero carico associato: <INPUT TYPE=TEXT NAME=\"Numero_carico\" VALUE=\""
             +Numero_carico.html()+"\" SIZE=10 MAXLENGTH=5><BR>\n";
        risp=risp+"        Annotazioni: <INPUT TYPE=TEXT NAME=\"Annotazioni\" VALUE=\""
             +Annotazioni.html()+"\" SIZE=20 MAXLENGTH=40>\n";
    }
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void InsDoc::stage1_process(stringone* strngn) {
    char* buff;

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_keytoken(strngn,"Anno");
    if(buff!=NULL) Anno=buff; else return;

    buff=check_token(strngn,"Ladata");
    if(buff!=NULL) Ladata=buff; else Ladata=null;

    buff=check_keytoken(strngn, "Oggetto");
    if(buff!=NULL) Oggetto=buff; else return;
    
    buff=check_keytoken(strngn, "cat");
    if(buff!=NULL) cat=buff; else return;

    buff=check_token(strngn,"Tipo_documento");
    if(buff!=NULL) Tipo_documento=buff; else Tipo_documento=null;
    
    // mostra la pagina HTML dello stage 2
    stage2_showpage();
}


void InsDoc::stage2_process(stringone* strngn) {
    char* buff;
    
    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_token(strngn,"codiceca");
    if(buff!=NULL) codiceca=buff; else codiceca=null;
    
    // decide il da farsi in base al contenuto del token "direz"
    // decide il da farsi in base al contenuto del token "direz"
    buff=check_keytoken(strngn, "direz");
    if(buff==NULL) return;
    if(strcmp(buff,"indietro")==0) stage1_showpage(); else stage3_showpage();
}


void InsDoc::stage3_process(stringone* strngn) {
    char* buff;
    
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 4 di 4");
    risp+="<FONT FACE=\"Times\">\n";

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_token(strngn,"Riparto");
    if(buff!=NULL) Riparto=buff; else Riparto=null;
    
    if(cat=="carico") {
        buff=check_token(strngn,"Data_atto");
        if(buff!=NULL) Data_atto=buff; else Data_atto=null;

        buff=check_token(strngn,"Num_atto");
        if(buff!=NULL) Num_atto=buff; else Num_atto=null;

        buff=check_token(strngn,"Data_fax");
        if(buff!=NULL) Data_fax=buff; else Data_fax=null;
    } else {
        buff=check_token(strngn,"Anno_carico");
        if(buff!=NULL) Anno_carico=atoi(buff); else Anno_carico=null;

        buff=check_token(strngn,"Numero_carico");
        if(buff!=NULL) Numero_carico=atoi(buff); else Numero_carico=null;

        buff=check_token(strngn,"Annotazioni");
        if(buff!=NULL) Annotazioni=buff; else Annotazioni=null;
    }

    // decide il da farsi in base al contenuto del token "direz"
    buff=check_keytoken(strngn, "direz");
    if(buff==NULL) return;
    if(strcmp(buff,"indietro")==0) stage2_showpage(); else {
        // esegue l'effettivo inserimento nella base dati
        bool OK=1;
        SqlInt nprot;
        try {
            if(cat=="carico")
                nprot=connection->insertCarico(Anno, Ladata, Oggetto, Tipo_documento,
                      Riparto, codiceca, Data_atto, Num_atto, Data_fax);
            else {
                nprot=connection->insertScarico(Anno, Ladata, Oggetto, Tipo_documento,
                      Riparto, codiceca, Annotazioni);
                if((Anno_carico!=null)&&(Numero_carico!=null))
                    connection->insertCorrispondenza(Anno, nprot, Anno_carico, Numero_carico);
            }
        }
        catch (SqlConnection::GenericError error) {
            OK=0;
            risp+=errore(error.toString(), "inserimento non riuscito");
        }
        if(OK) {
            risp+="Inserimento riuscito.<BR>\n";
            risp=risp+"Al documento  stato assegnato il numero di protocollo "
                 +nprot+".<BR>\n";
        }
        risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
        risp+="</FONT>\n";
        risp+=endbody();
    } // fine del codice per l'inserimento nella base dati
}


String& InsDoc::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>InsDoc:la classe non  stata inizializzata.</BODY>\n";
        return risp;
    }
    risp="";

    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
            stage1_showpage();
        break;
        case 1:
            stage1_process(strngn);
        break;
        case 2:
            if(strngn->findtoken("frames")!=NULL) stage2_showframe1();
            else stage2_process(strngn);
        break;
        case 3:
            stage3_process(strngn);
        break;
        default:
            risp+="<BODY>InsDoc: contenuto del token 'stage' non valido.</BODY>";
        break;
    }        

    return risp;
}


void InsDoc::reset() {
    Anno=annocorr();
    Ladata=datacorr();
    Oggetto=null;
    cat="carico";
    Tipo_documento="lettera";
    codiceca=null;
    Riparto=null;
    Data_atto=null;
    Num_atto=null;
    Data_fax=null;
    Anno_carico=null;
    Numero_carico=null;
    Annotazioni=null;
}
