/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_InsRip.cc         ULTIMA MODIFICA: 15/09/1999        */
/*                                                                  */
/*  Implementazione della classe InsRip. (op=2)                     */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


InsRip::InsRip() {
    classname="InsRip";
    titpagine="Inserimento di un nuovo riparto";
    risp="InsRip non ha ancora risposto";
    initialized=0;
}


void InsRip::stage1_showpage() {
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"codice\",\"sign\");\n";
    risp+="    var reqFieldsNames=new Array(\"Codice\",\"Descrizione\");\n";
    risp+="    var numFields=\"\";\n    var numFieldsNames=\"\";\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Inserire qui sotto il codice del nuovo riparto e una sua descrizione.\n";
    risp+="Si ricorda che il codice del riparto  costituito da una lettera seguita\n";
    risp+="da un numero di 1 o 2 cifre.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="\"Inserisci\" per effettuare l'inserimento.<BR>\n";
    risp+="Per annullare l'inserimento e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. I campi sono entrambi obbligatori.<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=2>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Codice</STRONG>:\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"codice\" SIZE=4 MAXLENGTH=3>\n";
    risp=risp+"        <BR>\n";
    risp=risp+"        <STRONG>Descrizione</STRONG>:\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"sign\" SIZE=20 MAXLENGTH=128>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Inserisci\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
}


void InsRip::stage1_process(stringone* strngn) {
    char* buff;

    risp+="<FONT FACE=\"Times\">\n";

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_keytoken(strngn,"codice");
    if(buff!=NULL) codice=buff; else return;

    buff=check_keytoken(strngn,"sign");
    if(buff!=NULL) sign=buff; else return;
    
    // esegue l'effettivo inserimento nella base dati
    int OK=1;
    try { connection->insertRiparto(codice,sign); }
    catch (SqlConnection::GenericError error) {
        OK=0;
        risp+=errore(error.toString(), "inserimento non riuscito");
    }
    if(OK) risp+="Inserimento completato con successo.<BR>\n";

    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
}


String& InsRip::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>InsRip:la classe non  stata inizializzata.</BODY>\n";
	return risp;
    }
    
    // stampa l'intestazione
    risp=beginbody();
    risp+=big_title(titpagine);

    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
	    stage1_showpage();
	break;
	case 1:
	    stage1_process(strngn);
	break;
	default:
	    risp+="InsRip: contenuto del token 'step' non valido.<BR>\n";
	break;
    }        

    risp+=endbody();
    return risp;
}


void InsRip::reset() {
    codice=null;
    sign=null;
}
