/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_Menu.cc           ULTIMA MODIFICA: 28/06/2000        */
/*                                                                  */
/*  Implementazione della classe Menu. (op=0)                       */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


Menu::Menu() {
    classname="Menu";
    titpagine="Menu principale";
    risp="Menu non ha ancora risposto";
    initialized=0;
}


void Menu::init(int id, SqlConnection* c) {
    userid=id;
    connection=c;

    aut_lettura=connection->autorizzato_lettura();
    aut_inserimento=connection->autorizzato_inserimento();
    aut_modifica=connection->autorizzato_modifica();
    aut_cancellazione=connection->autorizzato_cancellazione();
    
    initialized=1;
}


String& Menu::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>ERRORE:la classe Menu non  stata inizializzata.</BODY>\n";
	return risp;
    }
    	        
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+="Queste sono le pagine a cui si pu accedere:<BR>\n";
    // Bisognerebbe fare in modo che ogni classe fosse in grado di descrivere se stessa

    risp+="<BR><STRONG>Operazioni di interrogazione:</STRONG><BR>\n";
    if(!aut_lettura)
        risp+="<EM>Non consentite</EM><BR>\n";
    else {
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=9&stage=0\">"+"Ricerca di documenti</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=10&type=7\">"+"Ricerca dei documenti prestati e non restituiti</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=10&type=1\">"+"Visione dei documenti registrati dall'inizio dell'anno</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=11&stage=0\">"+"Ricerca di un corrispondente/affidatario/dipendente</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=14&stage=0\">"+"Backup del contenuto del database<BR></A>\n";
    }

    risp+="<BR><STRONG>Operazioni di inserimento dati:</STRONG><BR>\n";
    if(!aut_inserimento)
        risp+="<EM>Non consentite</EM><BR>\n";
    else {
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=1&stage=0\">"+"Inserimento di un nuovo documento</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=3&stage=0\">"+"Inserimento di un nuovo corrispondente/affidatario/dipendente</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=2&stage=0\">"+"Inserimento di un nuovo riparto</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=4&stage=0\">"+"Prestito/restituzione di un carico</A><BR>\n";
    }

    risp+="<BR><STRONG>Operazioni di modifica dei dati:</STRONG><BR>\n";
    if(!aut_modifica)
        risp+="<EM>Non consentite</EM><BR>\n";
    else {
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=5&stage=0\">"+"Modifica delle informazioni su un documento</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=7&stage=0\">"+"Modifica delle informazioni su un corrispondente/affidatario/dipendente</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=6&stage=0\">"+"Modifica della descrizione di un riparto</A><BR>\n";
    }
    
    risp+="<BR><STRONG>Operazioni di cancellazione:</STRONG><BR>\n";
    if(!aut_cancellazione)
        risp+="<EM>Non consentite</EM><BR>\n";
    else {
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=15&stage=0\">"+"Cancellazione delle informazioni su un corrispondente/affidatario/dipendente</A><BR>\n";
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid;
        risp=risp+"&op=16&stage=0\">"+"Restore del contenuto del database</A><BR>\n";
    }
   
    risp+="<BR><STRONG>Altre operazioni:</STRONG><BR>\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\" TARGET=\"_top\">";
    risp+="Elimina tutti i frames!<BR></A>\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=65535\">";
    risp+="Statistiche su questo angelo</A><BR>\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=logout\">";
    risp+="Esci dal programma</A><BR>\n";
    
    risp+=endbody();
    return risp;
}
