/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_ModCA.cc          ULTIMA MODIFICA: 11/08/1999        */
/*                                                                  */
/*  Implementazione della classe ModCA. (op=7)                      */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


ModCA::ModCA() {
    classname="ModCA";
    titpagine="Modifica delle informazioni su un corrispondente/affidatario/dipendente";
    risp="ModCA non ha ancora risposto";
    initialized=0;
}


void ModCA::stage1_showpage() {
    risp="<FRAMESET FRAMEBORDER=YES ROWS=60,40>\n";
    risp=risp+"    <FRAME NAME=\"Frame1\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=7&stage=1&frames=si\">\n";
    risp=risp+"    <FRAME NAME=\"Frame2\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=8&type=2&letter=A\">\n";
    risp=risp+"</FRAMESET>\n";
}


void ModCA::stage1_showframe1() {
    risp="<HEAD><BASE TARGET=\"_top\"></HEAD>\n";
    risp+=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 1 di 4");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"codiceca\");\n";
    risp+="    var reqFieldsNames=new Array(\"Codice del corrispondente/affidatario/dipendente\");\n";
    risp+="    var numFields=new Array(\"codiceca\");\n";
    risp+="    var numFieldsNames=new Array(\"Codice del corrispondente/affidatario/dipendente\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa prima pagina,  possibile specificare il codice del corrispondente,\n";
    risp+="affidatario o dipendente di cui si vogliono modificare le informazioni.<BR>\n";
    risp+="Per procedere alla fase successiva, premere il tasto \"Avanti >\".<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. Il campo <STRONG>Codice</STRONG>  obbligatorio.\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=7>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    <STRONG>Codice del corrispondente/affidatario/dipendente</STRONG>:\n";
    risp=risp+"    <INPUT TYPE=TEXT NAME=\"codiceca\" VALUE=\""+codiceca.html()+"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta2('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="<TABLE WIDTH=100% BGCOLOR=\"#CCCCDD\"><TR>\n<TD>\n";
    char l[2];
    l[1]='\0';
    for(*l='A';*l<='Z';++*l)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=8&type=2&letter="
             +l+"\" TARGET=\"Frame2\">"+l+"</A>\n";
    risp+="</TD></TR></TABLE>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void ModCA::stage2_showpage() {
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 2 di 4");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"Denominaz1\");\n";
    risp+="    var reqFieldsNames=new Array(\"Denominazione1\");\n";
    risp+="    var numFields=new Array(\"Cap\");\n";
    risp+="    var numFieldsNames=new Array(\"CAP\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Questa pagina permette di modificare le informazioni di carattere generale.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="con il simbolo \"Avanti >\" per passare alla pagina successiva.<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. I campi indicati in <STRONG>grassetto</STRONG> sono obbligatori.<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=7>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=2>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Denominazione1</STRONG>: (cognome di una persona, o nome di un'organizzazione)<BR>\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"Denominaz1\" VALUE=\""+Denominaz1.html()
         +"\" SIZE=40 MAXLENGTH=40>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Denominazione2: (nome di una persona, o divisione di un'organizzazione)<BR>\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"Denominaz2\" VALUE=\""+Denominaz2.html()
         +"\" SIZE=40 MAXLENGTH=40>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"        Via: <INPUT TYPE=TEXT NAME=\"Via\" VALUE=\""+Via.html()
         +"\" SIZE=40 MAXLENGTH=50>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Citt: <INPUT TYPE=TEXT NAME=\"Citta\" VALUE=\""+Citta.html()
         +"\" SIZE=20 MAXLENGTH=30>\n";
    risp=risp+"        CAP: <INPUT TYPE=TEXT NAME=\"Cap\" VALUE=\""+Cap.html()
         +"\" SIZE=6 MAXLENGTH=6>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Telefono: <INPUT TYPE=TEXT NAME=\"Telefono\" VALUE=\""
         +Telefono.html()+"\" SIZE=15 MAXLENGTH=25>\n";
    risp=risp+"        FAX: <INPUT TYPE=TEXT NAME=\"Fax\" VALUE=\""+Fax.html()
         +"\" SIZE=15 MAXLENGTH=25>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void ModCA::stage3_showpage() {
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 3 di 4");
    risp+=javascript_standard();

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa pagina,  possibile modificere alcune informazioni aggiuntive\n";
    if(Tipo=="dipendente") risp+="caratteristiche di un dipendente.<BR>\n";
    if((Tipo=="corr_persona")||(Tipo=="aff_persona")) risp+="relative alla persona.<BR>\n";
    if((Tipo=="corr_org")||(Tipo=="aff_org")) risp+="relative all'organizzazione.<BR>\n";
    risp+="Dopo questa pagina, tutti i dati fin qui digitati verranno effettivamente\n";
    risp+="inseriti nel database.<BR>\n";
    risp+="Per procedere alla modifica, premere sul tasto con il simbolo \"Avanti >\".<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";    

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=7>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=3>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    if(Tipo=="dipendente") {
        risp=risp+"    <BR>\n";
        risp=risp+"        Ufficio in cui il dipendente lavora:<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"Ufficio\" VALUE=\""+Ufficio.html()
             +"\" SIZE=40 MAXLENGTH=50>\n";
    }
    if((Tipo=="corr_persona")||(Tipo=="aff_persona")) {
        risp=risp+"    <BR>\n";
        risp=risp+"        Codice fiscale:<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"CodFisc\" VALUE=\""+CodFisc.html()
             +"\" SIZE=20 MAXLENGTH=16>\n";
        risp=risp+"    <BR>\n";
        risp=risp+"        Titolo: (professore, dottore, cavaliere, ecc.)<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"Titolo\" VALUE=\""+Titolo.html()
             +"\" SIZE=30 MAXLENGTH=30>\n";
    }
    if((Tipo=="corr_org")||(Tipo=="aff_org")) {
        risp=risp+"    <BR>\n";
        risp=risp+"        Partita IVA:<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"Piva\" VALUE=\""+Piva.html()
             +"\" SIZE=20 MAXLENGTH=20>\n";
        risp=risp+"    <BR>\n";
        risp=risp+"        Tramite: (nome della persona con cui si  in contatto all'interno dell'organizzazione)<BR>\n";
        risp=risp+"        <INPUT TYPE=TEXT NAME=\"Tramite\" VALUE=\""+Tramite.html()
             +"\" SIZE=40 MAXLENGTH=50>\n";
    }
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void ModCA::stage1_process(stringone* strngn) {
    char* buff;

    // resetta il contenuto di TUTTE la variabili
    reset();

    // determina il codice del c/a/d da modificare in base al contenuto
    // del token "codice"
    buff=check_keytoken(strngn,"codiceca");
    if(buff!=NULL) codiceca=buff; else return;
    
    // esegue una query per determinare tutte le informazioni sul c/a/d
    // e riempire cos le variabili
    SqlResult* R;
    int numtrovati, numcolonne;
    try { R=connection->queryInfoCA(codiceca); }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query del corrisp./affidatario fallita");
        return;
    }

    // se non esiste uno e un solo c/a/d, allora c'e` qualcosa che non va!
    numtrovati=R->rowNum();
    if(numtrovati!=1) {
        risp+=errore("Pi di un corrispondente/affidatario ha il codice dato",
              "la ricerca delle informazioni sul c/a/d  fallita");
        return;
    }

    // aggiorna le variabili con il contenuto della query;
    // le variabili che non vengono aggiornate rimangono a "null"
    if((R->get(0,1))!=NULL) Denominaz1=R->get(0,1);
    if((R->get(0,2))!=NULL) Denominaz2=R->get(0,2);
    if((R->get(0,3))!=NULL) Tipo=R->get(0,3);
    if((R->get(0,4))!=NULL) Via=R->get(0,4);
    if((R->get(0,5))!=NULL) Citta=R->get(0,5);
    if((R->get(0,6))!=NULL) Cap=R->get(0,6);
    if((R->get(0,7))!=NULL) Telefono=R->get(0,7);
    if((R->get(0,8))!=NULL) Fax=R->get(0,8);
    numcolonne=R->colNum();
    if((Tipo=="dipendente")&&(numcolonne>9)) {
        if((R->get(0,9))!=NULL) Ufficio=R->get(0,9);
    }
    if(((Tipo=="corr_persona")||(Tipo=="aff_persona"))&&(numcolonne>9)) {
        if((R->get(0,9))!=NULL) Titolo=R->get(0,9);
        if((R->get(0,10))!=NULL) CodFisc=R->get(0,10);
    }
    if(((Tipo=="corr_org")||(Tipo=="aff_org"))&&(numcolonne>9)) {
        if((R->get(0,9))!=NULL) Piva=R->get(0,9);
        if((R->get(0,10))!=NULL) Tramite=R->get(0,10);
    }
        
    // mostra la pagina HTML dello stage 2
    stage2_showpage();
}


void ModCA::stage2_process(stringone* strngn) {
    char* buff;

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_keytoken(strngn,"Denominaz1");
    if(buff!=NULL) Denominaz1=buff; else return;

    buff=check_token(strngn,"Denominaz2");
    if(buff!=NULL) Denominaz2=buff; else Denominaz2=null;

    buff=check_token(strngn,"Via");
    if(buff!=NULL) Via=buff; else Via=null;

    buff=check_token(strngn,"Citta");
    if(buff!=NULL) Citta=buff; else Citta=null;

    buff=check_token(strngn,"Cap");
    if(buff!=NULL) Cap=buff; else Cap=null;

    buff=check_token(strngn,"Telefono");
    if(buff!=NULL) Telefono=buff; else Telefono=null;

    buff=check_token(strngn,"Fax");
    if(buff!=NULL) Fax=buff; else Fax=null;

    // decide il da farsi in base al contenuto del token "direz"
    buff=check_keytoken(strngn,"direz");
    if(buff==NULL) return;
    if(strcmp(buff,"indietro")==0) stage1_showpage(); else stage3_showpage();
}


void ModCA::stage3_process(stringone* strngn) {
    char* buff;
    
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 4 di 4");
    risp+="<FONT FACE=\"Times\">\n";

    // aggiorna il contenuto delle variabili in base ai valori contenuti nei
    // token; i token da controllare sono scelti in base al contenuto della
    // variabile privata "Tipo" 
    if(Tipo=="dipendente") {
        buff=check_token(strngn,"Ufficio");
        if(buff!=NULL) Ufficio=buff; else Ufficio=null;
    }
    if((Tipo=="corr_persona")||(Tipo=="aff_persona")) {
        buff=check_token(strngn,"CodFisc");
        if(buff!=NULL) CodFisc=buff; else CodFisc=null;
        buff=check_token(strngn,"Titolo");
        if(buff!=NULL) Titolo=buff; else Titolo=null;
    }
    if((Tipo=="corr_org")||(Tipo=="aff_org")) {
        buff=check_token(strngn,"Piva");
        if(buff!=NULL) Piva=buff; else Piva=null;
        buff=check_token(strngn,"Tramite");
        if(buff!=NULL) Tramite=buff; else Tramite=null;
    }
    
    // decide il da farsi in base al contenuto del token "direz"
    buff=check_keytoken(strngn,"direz");
    if(buff==NULL) return;
    if(strcmp(buff,"indietro")==0) stage2_showpage(); else {
        // esegue l'effettiva modifica delle informazioni nel database
        bool OK=1, OK2=0;
        try {
            if(Tipo=="dipendente") {
               connection->modCADipendente(codiceca, Denominaz1, Denominaz2,
                           Tipo, Via, Citta, Cap, Telefono, Fax, Ufficio);
               OK2=1;
            }
            if((Tipo=="corr_persona")||(Tipo=="aff_persona")) {
               connection->modCAPersona(codiceca, Denominaz1, Denominaz2,
                           Tipo, Via, Citta, Cap, Telefono, Fax, Titolo, CodFisc);
               OK2=1;
            }
            if((Tipo=="corr_org")||(Tipo=="aff_org")) {
               connection->modCAOrganizzazione(codiceca, Denominaz1, Denominaz2,
                           Tipo, Via, Citta, Cap, Telefono, Fax, Piva, Tramite);
               OK2=1;
            }
        }
        catch (SqlConnection::GenericError error) {
            OK=0;
            risp+=errore(error.toString(), "modifica delle informazioni fallita");
        }
        if(OK&&OK2) risp+="Modifica riuscita.<BR>\n";
        if(!OK2) risp+="ModCA: non riesco a determinare il tipo di corrispondente/affidatario.<BR>\n";
        risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
        risp+="Torna al menu</A><BR>\n";
        risp+="</FONT>\n";
        risp+=endbody();
    } // fine del codice per l'inserimento nella base dati
}


String& ModCA::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>ModCA:la classe non  stata inizializzata.</BODY>\n";
        return risp;
    }
    risp="";
    
    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
            stage1_showpage();
        break;
        case 1:
            if(strngn->findtoken("frames")!=NULL) stage1_showframe1();
            else stage1_process(strngn);
        break;
        case 2:
            stage2_process(strngn);
        break;
        case 3:
            stage3_process(strngn);
        break;
        default:
            risp="<BODY>ModCA: contenuto del token 'stage' non valido.</BODY>\n";
        break;
    }        

    return risp;
}


void ModCA::reset() {
    Denominaz1=null;
    Denominaz2=null;
    Tipo=null;
    Via=null;
    Citta=null;
    Cap=null;
    Telefono=null;
    Fax=null;
    Titolo=null;
    CodFisc=null;
    Piva=null;
    Tramite=null;
    Ufficio=null;

    codiceca=null;
}
