/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_ModDoc.cc         ULTIMA MODIFICA: 18/06/2000        */
/*                                                                  */
/*  Implementazione della classe ModDoc. (op=5)                     */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


ModDoc::ModDoc() {
    classname="ModDoc";
    titpagine="Modifica delle informazioni su un documento";
    risp="ModDoc non ha ancora risposto";
    initialized=0;
}


void ModDoc::stage1_showpage() {
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 1 di 5");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"Anno\",\"numdoc\");\n";
    risp+="    var reqFieldsNames=new Array(\"Anno\",\"Numero di protocollo\");\n";
    risp+="    var numFields=new Array(\"Anno\",\"numdoc\");\n";
    risp+="    var numFieldsNames=new Array(\"Anno\",\"Numero di protocollo\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Inserire qui sotto anno e numero di protocollo del documento di cui si\n";
    risp+="intendono modificare le informazioni; se anno e numero non sono noti,\n";
    risp=risp+"si consiglia di andare alla pagina della <A HREF=\""+BRIDGE_PATH
         +"?userid="+userid+"&op=9&stage=0\">"+"ricerca di documenti</A>\n";
    risp+="e di effettuare poi la modifica da l.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="con il simbolo \"Avanti >\" per passare alla pagina successiva.<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. I campi sono entrambi obbligatori.\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=5>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Anno</STRONG>: <INPUT TYPE=TEXT NAME=\"Anno\"  VALUE=\""
         +Anno.html()+"\" SIZE=4 MAXLENGTH=4>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Numero di protocollo</STRONG>: <INPUT TYPE=TEXT NAME=\"numdoc\" VALUE=\""
         +numdoc.html()+"\" SIZE=10 MAXLENGTH=40><BR>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void ModDoc::stage2_showpage() {
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 2 di 5");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"Oggetto\");\n";
    risp+="    var reqFieldsNames=new Array(\"Oggetto\");\n";
    risp+="    var numFields=\"\";\n    var numFieldsNames=\"\";\n";
    risp+="    var dateFields=new Array(\"Ladata\");\n";
    risp+="    var dateFieldsNames=new Array(\"Data\");\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Questa seconda pagina consente di modificare le informazioni di carattere\n";
    risp+="generale sul documento.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="con il simbolo \"Avanti >\" per passare alla pagina successiva.<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. I campi indicati in <STRONG>grassetto</STRONG> sono obbligatori.<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=5>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=2>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Documento n. "+numdoc.html()+" dell'anno "+Anno.html()+"\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Categoria documento: "+cat+"</STRONG>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"        Data: <INPUT TYPE=TEXT NAME=\"Ladata\" VALUE=\""+Ladata.html()
         +"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Oggetto</STRONG>:<TEXTAREA NAME=\"Oggetto\" ROWS=3 COLS=40>"
         +Oggetto.html()+"</TEXTAREA>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Tipo documento:\n";
    risp=risp+"        <SELECT NAME=\"Tipo_documento\">\n";
    risp=risp+"        <OPTION VALUE=\"lettera\"";
    if(Tipo_documento=="lettera") risp+=" SELECTED";
    risp=risp+">lettera\n";
    risp=risp+"        <OPTION VALUE=\"FAX\"";
    if(Tipo_documento=="FAX") risp+=" SELECTED";
    risp=risp+">FAX\n";
    risp=risp+"        <OPTION VALUE=\"e-mail\"";
    if(Tipo_documento=="e-mail") risp+=" SELECTED";
    risp=risp+">e-mail\n";
    risp=risp+"        <OPTION VALUE=\"altro\"";
    if(Tipo_documento=="altro") risp+=" SELECTED";
    risp=risp+">altro\n";
    risp=risp+"        </SELECT>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void ModDoc::stage3_showpage() {
    risp="<FRAMESET FRAMEBORDER=YES ROWS=60,40>\n";
    risp=risp+"    <FRAME NAME=\"Frame1\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=5&stage=3&frames=si\">\n";
    risp=risp+"    <FRAME NAME=\"Frame2\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=8&type=1&letter=A\">\n";
    risp=risp+"</FRAMESET>\n";
}


void ModDoc::stage3_showframe1() {
    risp="<HEAD><BASE TARGET=\"_top\"></HEAD>\n";
    risp+=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 3 di 5");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=\"\";\n    var reqFieldsNames=\"\";\n";
    risp+="    var numFields=new Array(\"codiceca\");\n";
    risp+="    var numFieldsNames=new Array(\"Codice\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa terza pagina,  possibile specificare il ";
    if(cat=="carico") risp+="mittente"; else risp+="destinatario";
    risp+=" del documento, inserendo direttamente il suo codice\n";
    risp+="oppure scegliendolo da una lista.<BR>\n";
    risp=risp+"Per inserire un nuovo ";
    if(cat=="carico") risp+="mittente"; else risp+="destinatario";
    risp+=", fare clic su \"Aggiungi...\".<BR>\n";
    risp+="Per procedere alla pagina successiva, premere il tasto \"Avanti >\".<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=5>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=3>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    risp=risp+"    <BR>\n";
    risp=risp+"    Codice del ";
    if(cat=="carico") risp+="mittente:\n"; else risp+="destinatario:\n";
    risp=risp+"    <INPUT TYPE=TEXT NAME=\"codiceca\" VALUE=\""+codiceca.html()+"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta2('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="<TABLE WIDTH=100% BGCOLOR=\"#CCCCDD\"><TR>\n<TD>\n";
    char l[2];
    l[1]='\0';
    for(*l='A';*l<='Z';++*l)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=8&type=1&letter="
             +l+"\" TARGET=\"Frame2\">"+l+"</A>\n";
    risp+="</TD><TD ALIGN=\"right\">\n";
    risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=3&stage=0\" TARGET=\"Frame2\">Aggiungi...</A>\n";
    risp+="</TD></TR></TABLE>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void ModDoc::stage4_showpage() {
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 4 di 5");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=\"\";\n    var reqFieldsNames=\"\";\n";
    if(cat=="carico") {
        risp+="    var numFields=\"\";\n    var numFieldsNames=\"\";\n";
        risp+="    var dateFields=new Array(\"Data_atto\",\"Data_fax\");\n";
        risp+="    var dateFieldsNames=new Array(\"Data atto\",\"Data FAX di preavviso\");\n";
    } else {
        risp+="    var numFields=new Array(\"Anno_carico\",\"Num_carico\");\n";
        risp+="    var numFieldsNames=new Array(\"Anno carico associato\",\"Numero carico associato\");\n";
        risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    }
    risp+="// --></SCRIPT>\n";

    // esegue una query per avere una lista dei riparti disponibili
    SqlResult* R;
    try { R=connection->queryRiparto(); }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query dei riparti fallita");
        return;
    }

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa quarta pagina,  possibile assegnare il documento ad un riparto\n";
    if(cat=="carico")
        risp+="e inserire alcune informazioni specifiche per un carico.<BR>\n";
    else
        risp+="e inserire alcune informazioni specifiche per uno scarico.<BR>\n";
    risp+="Dopo questa pagina, tutti i dati fin qui digitati verranno effettivamente\n";
    risp+="inseriti nel database.<BR>\n";
    risp+="Per procedere con la modifica, premere il tasto \"Avanti >\".<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare l'operazione e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=5>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=4>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    risp=risp+"    <BR>\n";
    risp=risp+"Riparto a cui assegnare il documento:<BR>\n";
    risp=risp+"    <SELECT TYPE=TEXT SIZE=5 NAME=\"Riparto\">\n";
    // adesso sfrutta la lista dei riparti ottenuta prima
    int i,imax;
    imax=R->rowNum();
    for(i=0;i<imax;++i)
    risp=risp+"        <OPTION VALUE=\""+R->get(i,0)+"\">"+R->get(i,0)+" - "+R->get(i,1)+"\n";
    // fine del codice relativo ai riparti
    risp=risp+"    </SELECT><BR><BR>\n";
    if(cat=="carico") {
        risp=risp+"        Data atto: <INPUT TYPE=TEXT NAME=\"Data_atto\" VALUE=\""
             +Data_atto.html()+"\" SIZE=10 MAXLENGTH=20><BR>\n";
        risp=risp+"        Numero atto: <INPUT TYPE=TEXT NAME=\"Num_atto\" VALUE=\""+Num_atto.html()
             +"\" SIZE=10 MAXLENGTH=40><BR>\n";
        risp=risp+"        Data FAX di preavviso: <INPUT TYPE=TEXT NAME=\"Data_fax\" VALUE=\""
             +Data_fax.html()+"\" SIZE=10 MAXLENGTH=10>\n";
    } else {
        risp=risp+"        Anno carico associato: <INPUT TYPE=TEXT NAME=\"Anno_carico\" VALUE=\""
             +Anno_carico.html()+"\" SIZE=10 MAXLENGTH=10><BR>\n";
        risp=risp+"        Numero carico associato: <INPUT TYPE=TEXT NAME=\"Numero_carico\" VALUE=\""
             +Numero_carico.html()+"\" SIZE=10 MAXLENGTH=5><BR>\n";
        risp=risp+"        Annotazioni: <INPUT TYPE=TEXT NAME=\"Annotazioni\" VALUE=\""
             +Annotazioni.html()+"\" SIZE=20 MAXLENGTH=40>\n";
    }
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void ModDoc::stage1_process(stringone* strngn) {
    char* buff;

    // resetta il contenuto di TUTTE la variabili
    reset();

    // determina il documento di cui modificare le informazioni in base al
    // contenuto dei token "Anno" e "numdoc"
    buff=check_keytoken(strngn,"Anno");
    if(buff!=NULL) Anno=buff; else return;
    buff=check_keytoken(strngn,"numdoc");
    if(buff!=NULL) numdoc=buff; else return;
    
    // esegue una query per determinare tutte le informazioni sul
    // documento, e riempire cos le variabili
    SqlResult* R;
    int numtrovati;
    try {
        // cerca prima il documento tra i carichi
        R=connection->queryInfoCaricoMod(Anno, numdoc);
        numtrovati=R->rowNum();
        
        // se non lo trova, allora lo cerca tra gli scarichi
        if(numtrovati==0) {
            R=connection->queryInfoScaricoMod(Anno, numdoc);
            numtrovati=R->rowNum();
            cat="scarico";
        }
    }
    catch(SqlConnection::GenericError error) {
        risp+=errore(error.toString(), "query del documento fallita");
        return;
    }

    // se non esiste uno e un solo documento, allora c'e` un errore
    if(numtrovati!=1) {
        risp+=errore("Non esiste uno e un solo documento",
              "la ricerca delle informazioni sul documento  fallita");
        return;
    }
    // aggiorna le variabili con il contenuto della query;
    // le variabili che non vengono aggiornate rimangono a "null"
    Ladata.format=english; Ladata=R->get(0,0); Ladata.format=italian;
    Oggetto=R->get(0,1);
    Tipo_documento=R->get(0,2);
    Riparto=R->get(0,3);
    codiceca=R->get(0,4);
    if(cat=="carico") {
        Data_atto.format=english; Data_atto=R->get(0,5); Data_atto.format=italian;
        Num_atto=R->get(0,6);
        Data_fax.format=english; Data_fax=R->get(0,7); Data_fax.format=italian;
    } else {
        Anno_carico=R->get(0,5);
        Numero_carico=R->get(0,6);
        Annotazioni=R->get(0,7);
    }
        
    // mostra la pagina HTML dello stage 2
    stage2_showpage();
}


void ModDoc::stage2_process(stringone* strngn) {
    char* buff;

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_token(strngn,"Ladata");
    if(buff!=NULL) Ladata=buff; else Ladata=null;

    buff=check_keytoken(strngn, "Oggetto");
    if(buff!=NULL) Oggetto=buff; else return;
    
    buff=check_token(strngn,"Tipo_documento");
    if(buff!=NULL) Tipo_documento=buff; else Tipo_documento=null;
    
    // decide il da farsi in base al contenuto del token "direz"
    buff=check_keytoken(strngn, "direz");
    if(buff==NULL) return;
    if(strcmp(buff,"indietro")==0) stage1_showpage(); else stage3_showpage();
}


void ModDoc::stage3_process(stringone* strngn) {
    char* buff;
    
    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_token(strngn,"codiceca");
    if(buff!=NULL) codiceca=buff; else codiceca=null;
    
    // decide il da farsi in base al contenuto del token "direz"
    buff=check_keytoken(strngn, "direz");
    if(buff==NULL) return;
    if(strcmp(buff,"indietro")==0) stage2_showpage(); else stage4_showpage();
}


void ModDoc::stage4_process(stringone* strngn) {
    char* buff;
    
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 5 di 5");
    risp+="<FONT FACE=\"Times\">\n";

    // aggiorna il contenuto delle variabili in base ai valori contenuti nei
    // token; i token sono scelti in base al tipo di documento
    // UGLY: al contrario di tutte le altre variabili, "Riparto" non viene
    // impostata a null anche se il relativo token lo e`; questo perche' il
    // tag <SELECT> non puo` avere una selezione di default e quindi un
    // valore nullo e` probabilmente non voluto dall'utente
    buff=check_token(strngn,"Riparto");
    if(buff!=NULL) Riparto=buff;
    
    if(cat=="carico") {
        buff=check_token(strngn,"Data_atto");
        if(buff!=NULL) Data_atto=buff; else Data_atto=null;

        buff=check_token(strngn,"Num_atto");
        if(buff!=NULL) Num_atto=buff; else Num_atto=null;

        buff=check_token(strngn,"Data_fax");
        if(buff!=NULL) Data_fax=buff; else Data_fax=null;
    } else {
        buff=check_token(strngn,"Anno_carico");
        if(buff!=NULL) Anno_carico=atoi(buff); else Anno_carico=null;

        buff=check_token(strngn,"Numero_carico");
        if(buff!=NULL) Numero_carico=atoi(buff); else Numero_carico=null;

        buff=check_token(strngn,"Annotazioni");
        if(buff!=NULL) Annotazioni=buff; else Annotazioni=null;
    }

    // decide il da farsi in base al contenuto del token "direz"
    buff=check_keytoken(strngn,"direz");
    if(buff==NULL) return;
    if(strcmp(buff,"indietro")==0) stage3_showpage(); else {
        // esegue l'effettiva modifica delle informazioni nel database
        bool OK=1;
        try {
            if(cat=="carico")
                connection->modCarico(Anno, numdoc, Ladata, Oggetto, Tipo_documento,
                    Riparto, codiceca, Data_atto, Num_atto, Data_fax);
            else {
                connection->modScarico(Anno, numdoc, Ladata, Oggetto,
                    Tipo_documento, Riparto, codiceca, Annotazioni,
		    Anno_carico, Numero_carico);
            }
        }
        catch (SqlConnection::GenericError error) {
            OK=0;
            risp+=errore(error.toString(), "modifica delle informazioni fallita");
        }
        if(OK) risp+="Modifica completata con successo.<BR>\n";
    } // fine del codice per l'inserimento nella base dati
    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
    risp+=endbody();
}


String& ModDoc::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>ModDoc:la classe non  stata inizializzata.</BODY>\n";
        return risp;
    }
    risp="";
    
    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
            stage1_showpage();
        break;
        case 1:
            stage1_process(strngn);
        break;
        case 2:
            stage2_process(strngn);
        break;
        case 3:
            if(strngn->findtoken("frames")!=NULL) stage3_showframe1();
            else stage3_process(strngn);
        break;
        case 4:
            stage4_process(strngn);
        break;
        default:
            risp+="ModDoc: contenuto del token 'stage' non valido.<BR>\n";
        break;
    }        

    return risp;
}


void ModDoc::reset() {
    Anno=null;
    Ladata=null;
    Oggetto=null;
    Tipo_documento=null;
    codiceca=null;
    Riparto=null;
    Data_atto=null;
    Num_atto=null;
    Data_fax=null;
    Anno_carico=null;
    Numero_carico=null;
    Annotazioni=null;

    numdoc=null;
    cat="carico";
}
