/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_ModRip.cc         ULTIMA MODIFICA: 18/07/1999        */
/*                                                                  */
/*  Implementazione della classe ModRip. (op=6)                     */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


ModRip::ModRip() {
    classname="ModRip";
    titpagine="Modifica delle informazioni su un riparto";
    risp="ModRip non ha ancora risposto";
    initialized=0;
}


void ModRip::stage1_showpage() {
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=new Array(\"codice\",\"sign\");\n";
    risp+="    var reqFieldsNames=new Array(\"Codice\",\"Descrizione\");\n";
    risp+="    var numFields=\"\";\n    var numFieldsNames=\"\";\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";

    // esegue una query per avere una lista dei riparti disponibili
    SqlResult* R;
    try { R=connection->queryRiparto(); }
    catch(SqlConnection::GenericError error) {
        risp=errore(error.toString(), "query dei riparti fallita");
	return;
    }

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Scegliere dall'elenco a sinistra il nome del riparto da modificare,\n";
    risp+="e inserire sulla destra la nuova descrizione del riparto.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="\"Modifica\" per effettuare la modifica della descrizione del riparto.<BR>\n";
    risp+="Per annullare la modifica e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";
    risp+="NOTA. I campi sono entrambi obbligatori.<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=6>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR><TABLE WIDTH=100% ALIGN=\"center\"><TR><TD>\n";
    risp=risp+"    <STRONG>Codice</STRONG>:<BR>\n";
    risp=risp+"    <SELECT TYPE=TEXT SIZE=5 NAME=\"codice\">\n";
    // adesso sfrutta la lista dei riparti ottenuta prima
    int i,imax;
    imax=R->rowNum();
    for(i=0;i<imax;++i)
        risp=risp+"        <OPTION VALUE=\""+fn(R->get(i,0))+"\">"+fn(R->get(i,0))
	     +" - "+fn2(R->get(i,1))+"\n";
    // fine del codice relativo ai riparti
    risp=risp+"    </SELECT></TD><TD>\n";
    risp=risp+"        <STRONG>Descrizione</STRONG>:<BR>\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"sign\" SIZE=20 MAXLENGTH=128>\n";
    risp=risp+"    </TD></TR></TABLE><BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Modifica\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
}


void ModRip::stage1_process(stringone* strngn) {
    char* buff;
    SqlString codice, sign;

    risp+="<FONT FACE=\"Times\">\n";

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_keytoken(strngn,"codice");
    if(buff!=NULL) codice=buff; else return;

    buff=check_keytoken(strngn,"sign");
    if(buff!=NULL) sign=buff; else return;
    
    // esegue la modifica della descrizione del riparto
    int OK=1;
    try { connection->modRiparto(codice,sign); }
    catch (SqlConnection::GenericError error) {
        OK=0;
        risp+=errore(error.toString(), "Modifica non riuscita");
    }
    if(OK) risp+="Modifica completata con successo.<BR>\n";

    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
}


String& ModRip::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>ModRip:la classe non  stata inizializzata.</BODY>\n";
	return risp;
    }
    
    // stampa l'intestazione
    risp=beginbody();
    risp+=big_title(titpagine);

    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
	    stage1_showpage();
	break;
	case 1:
	    stage1_process(strngn);
	break;
	default:
	    risp+="ModRip: contenuto del token 'step' non valido.<BR>\n";
	break;
    }        

    risp+=endbody();
    return risp;
}
