/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_QueryCA.cc        ULTIMA MODIFICA: 18/07/1999        */
/*                                                                  */
/*  Implementazione della classe QueryCA. (op=11)                   */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


QueryCA::QueryCA() {
    classname="QueryCA";
    titpagine="Ricerca delle informazioni su un corrispondente/affidatario/dipendente";
    risp="QueryCA non ha ancora risposto";
    initialized=0;
}


void QueryCA::stage1_showpage() {
    risp+=javascript_standard();

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Inserire qui sotto i dati sul corrispondente, affidatario o dipendente\n";
    risp+="che si vuole cercare.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="\"Ricerca\" per mostrare una lista dei corrispondenti, affidatari e\n";
    risp+="dipendenti che soddisfano i criteri specificati.<BR>\n";
    risp+="Per annullare la ricerca e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=11>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Denominazione1: (cognome di una persona, o nome di un'organizzazione)<BR>\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"Denominaz1\" VALUE=\""+Denominaz1.html()
         +"\" SIZE=40 MAXLENGTH=40>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        Denominazione2: (nome di una persona, o divisione di un'organizzazione)<BR>\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"Denominaz2\" VALUE=\""+Denominaz2.html()
         +"\" SIZE=40 MAXLENGTH=40>\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Ricerca\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
}


void QueryCA::stage1_process(stringone* strngn) {
    char* buff;

    risp+="<FONT FACE=\"Times\">\n";

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_token(strngn,"Denominaz1");
    if(buff!=NULL) Denominaz1=buff; else Denominaz1=null;

    buff=check_token(strngn,"Denominaz2");
    if(buff!=NULL) Denominaz2=buff; else Denominaz2=null;

    // esegue la ricerca nella base dati
    bool OK=1;
    SqlResult* R;
    int i,imax,j;
    try { R=connection->queryInfoCALista(Denominaz1, Denominaz2); }
    catch (SqlConnection::GenericError error) {
        OK=0;
        risp+=errore(error.toString(), "errore durante l'esecuzione della ricerca");
    }
    if(OK) {
        imax=R->rowNum();
        risp=risp+imax+" elementi trovati.<BR><BR>\n";
        risp+="<TABLE BORDER=1 CELLSPACING=0 WIDTH=100%>\n";
        risp+="<TR  ALIGN=\"center\" VALIGN=\"middle\">\n";
        risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
        risp+="        <STRONG>Denominazione1</STRONG></FONT></TD>\n";
        risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
        risp+="        <STRONG>Denominazione2</STRONG></FONT></TD>\n";
        risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
        risp+="        <STRONG>Tipo</STRONG></FONT></TD>\n";
        risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
        risp+="        <STRONG>Codice</STRONG></FONT></TD>\n";
        risp+="    <TD></TD>\n</TR>\n";
        for(i=0;i<imax;++i) {
            risp+="<TR  ALIGN=\"center\" VALIGN=\"middle\">\n";
	    for(j=0;j<4;++j) {
	        risp=risp+"<TD>";
		if(R->get(i,j)!=NULL) risp+=R->get(i,j); else risp+="<EM>null</EM>";
		risp+="</TD>\n";
	    }
	    risp=risp+"<TD><FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=10>\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"type\" VALUE=5>\n";
            risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"codiceca\" VALUE="+R->get(i,3)+">\n";
            risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Mostra\">\n";
	    risp=risp+"</FORM></TD>\n";
	    risp+="</TR>\n";
	}
	risp=risp+"</TABLE>\n";
        risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=11&stage=0\">";
        risp+="Torna alla pagina precedente</A>\n";
    }
    risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
    risp+="Torna al menu</A><BR>\n";
    risp+="</FONT>\n";
}


String& QueryCA::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>QueryCA:la classe non  stata inizializzata.</BODY>\n";
	return risp;
    }
    
    // stampa l'intestazione
    risp=beginbody();
    risp+=big_title(titpagine);

    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
	    stage1_showpage();
	break;
	case 1:
	    stage1_process(strngn);
	break;
	default:
	    risp+="QueryCA: contenuto del token 'stage' non valido.\n";
	break;
    }        

    risp+=endbody();
    return risp;
}


void QueryCA::reset() {
    Denominaz1=null;
    Denominaz2=null;
}
