/*------------------------------------------------------------------*/
/*                                                                  */
/*    NOME: op_QueryDoc.cc       ULTIMA MODIFICA: 14/08/1999        */
/*                                                                  */
/*  Implementazione della classe QueryDoc. (op=9)                   */
/*                                                                  */
/*------------------------------------------------------------------*/

#include "operation.h"
#include "html_utils.h"


QueryDoc::QueryDoc() {
    classname="QueryDoc";
    titpagine="Ricerca di documenti";
    risp="QueryDoc non ha ancora risposto";
    finder=NULL;
    initialized=0;
}


QueryDoc::~QueryDoc() {
    if(finder!=NULL) delete finder;
}


void QueryDoc::init(int id, SqlConnection* c) {
    userid=id;
    connection=c;

    reset();        // inizializza le variabili ai valori predefiniti

    if(finder!=NULL) delete finder;
    if(connection->autorizzato_lettura()) {
        finder = new Finder(connection);  // inizializza la classe della ricerca
        finder->update();                 // per oggetto
    }
    
    initialized=1;
}


void QueryDoc::stage1_showpage() {
    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 1 di 3");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=\"\";\n    var reqFieldsNames=\"\";\n";
    risp+="    var numFields=new Array(\"preanno\",\"postanno\",\"prenumero\",\"postnumero\");\n";
    risp+="    var numFieldsNames=new Array(\"preanno\",\"postanno\",\"prenumero\",\"postnumero\");\n";
    risp+="    var dateFields=new Array(\"predata\",\"postdata\");\n";
    risp+="    var dateFieldsNames=new Array(\"predata\",\"postdata\");\n";
    risp+="// --></SCRIPT>\n";

    risp+="<FONT FACE=\"Times\">\n";
    risp+="Questa pagina e la successiva permettono di inserire tutte le informazioni\n";
    risp+="necessarie a cercare un documento. Non  necessario riempire tutti i\n";
    risp+="campi, ma  indispensabile che almeno <EM>un</EM> campo contenga qualcosa.<BR>\n";
    risp+="Dopo aver completato l'inserimento dei dati, premere sul tasto\n";
    risp+="con il simbolo \"Avanti >\" per passare alla pagina successiva.<BR>\n";
    risp+="Per annullare la ricerca e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=9>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=1>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        <STRONG>Cerca</STRONG> tutti i documenti registrati tra gli anni\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"preanno\"  VALUE=\""+preanno.html()
         +"\" SIZE=4 MAXLENGTH=4>\n";
    risp=risp+"        e <INPUT TYPE=TEXT NAME=\"postanno\"  VALUE=\""+postanno.html()
         +"\" SIZE=4 MAXLENGTH=4>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        con numeri di protocollo compresi tra\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"prenumero\"  VALUE=\""+prenumero.html()
         +"\" SIZE=4 MAXLENGTH=4>\n";
    risp=risp+"        e <INPUT TYPE=TEXT NAME=\"postnumero\"  VALUE=\""+postnumero.html()
         +"\" SIZE=4 MAXLENGTH=4>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        con data compresa tra\n";
    risp=risp+"        <INPUT TYPE=TEXT NAME=\"predata\" VALUE=\""+predata.html()
         +"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"        e <INPUT TYPE=TEXT NAME=\"postdata\" VALUE=\""+postdata.html()
         +"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        appartenenti alla categoria\n";
    risp=risp+"        <INPUT TYPE=RADIO NAME=\"cat\" VALUE=\"carico\"";
    if(cat=="carico") risp+=" CHECKED";
    risp+=">carico\n";
    risp=risp+"        <INPUT TYPE=RADIO NAME=\"cat\" VALUE=\"scarico\"";
    if(cat=="scarico") risp+=" CHECKED";
    risp+=">scarico\n";
    risp=risp+"    <BR>\n";
    risp=risp+"        e il cui oggetto contiene le seguenti parole:<BR>\n";
    risp=risp+"        <TEXTAREA NAME=\"Oggetto\" ROWS=3 COLS=40>"+Oggetto.html()
         +"</TEXTAREA>\n";
    risp=risp+"        <BR>(separare le parole con uno spazio)\n";
    risp=risp+"    <BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp+="</FORM>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void QueryDoc::stage2_showpage() {
    risp="<FRAMESET FRAMEBORDER=YES ROWS=60,40>\n";
    risp=risp+"    <FRAME NAME=\"Frame1\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=9&stage=2&frames=si\">\n";
    risp=risp+"    <FRAME NAME=\"Frame2\" SRC=\""+BRIDGE_PATH+"?userid="+userid
         +"&op=8&type=1&letter=A\">\n";
    risp=risp+"</FRAMESET>\n";
}


void QueryDoc::stage2_showframe1() {
    risp="<HEAD><BASE TARGET=\"_top\"></HEAD>\n";
    risp+=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 2 di 3");
    risp+=javascript_standard();
    risp+="<SCRIPT LANGUAGE=\"javascript\"><!--\n";
    risp+="    var reqFields=\"\";\n    var reqFieldsNames=\"\";\n";
    risp+="    var numFields=new Array(\"codiceca\");\n";
    risp+="    var numFieldsNames=new Array(\"Codice del mittente/destinatario\");\n";
    risp+="    var dateFields=\"\";\n    var dateFieldsNames=\"\";\n";
    risp+="// --></SCRIPT>\n";
    // esegue una query per avere una lista dei riparti disponibili
    SqlResult* R;
    try { R=connection->queryRiparto(); }
    catch(SqlConnection::GenericError error) {
        risp="<BODY>QueryDoc: query dei riparti fallita.</BODY>\n";
        return;
    }

    risp+="<FONT FACE=\"Times\">\n";
    risp+="In questa seconda pagina,  possibile specificare il mittente (o destinatario)\n";
    risp+="dei documenti che si stanno cercando, nonch il riparto a cui i documenti\n";
    risp+="stessi sono assegnati.<BR>\n";
    risp+="Dopo questa pagina, verr presentata una lista dei documenti che soddisfano\n";
    risp+="i criteri di ricerca impostati.<BR>\n";
    risp+="Per effettuare la ricerca, premere il tasto \"Avanti >\".<BR>\n";
    risp+="Per tornare alla pagina precedente, premere il tasto \"< Indietro\".<BR>\n";
    risp+="Per annullare la ricerca e tornare al menu principale, premere\n";
    risp+="il tasto \"Annulla\".<BR>\n";

    risp=risp+"<FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\" onSubmit=\"return valida(this)\">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=9>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"stage\" VALUE=2>\n";
    risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"direz\" VALUE=\"avanti\">\n";
    risp=risp+"    <BR><TABLE WIDTH=100%><TR><TD ALIGN=\"center\">\n";
    if(cat=="carico")
    risp=risp+"    Codice del mittente:<BR>\n";
    else
    risp=risp+"    Codice del destinatario:<BR>\n";
    risp=risp+"    <INPUT TYPE=TEXT NAME=\"codiceca\" VALUE=\""+codiceca.html()
         +"\" SIZE=10 MAXLENGTH=10>\n";
    risp=risp+"    <BR></TD><TD ALIGN=\"center\">\n";
    risp=risp+"    Riparto cui sono assegnati i documenti:<BR>\n";
    risp=risp+"    <SELECT TYPE=TEXT SIZE=5 NAME=\"Riparto\">\n";
    // adesso sfrutta la lista dei riparti ottenuta prima
    int i,imax;
    imax=R->rowNum();
    for(i=0;i<imax;++i)
    risp=risp+"        <OPTION VALUE=\""+R->get(i,0)+"\">"+R->get(i,0)+" - "+R->get(i,1)+"\n";
    // fine del codice relativo ai riparti
    risp=risp+"    </SELECT><BR><BR>\n";
    risp=risp+"    </TD></TR></TABLE>\n<BR><BR>\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"< Indietro\" onClick=\"cambia_direz(modulo,'indietro')\">\n";
    risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Avanti >\">\n";
    risp=risp+"    <INPUT TYPE=BUTTON VALUE=\"Annulla\" onClick=\"salta('"+BRIDGE_PATH
         +"?userid="+userid+"&op=0')\">\n";
    risp=risp+"</FORM>\n";

    risp+="<TABLE WIDTH=100% BGCOLOR=\"#CCCCDD\"><TR>\n<TD>\n";
    char l[2];
    l[1]='\0';
    for(*l='A';*l<='Z';++*l)
        risp=risp+"<A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=8&type=1&letter="
             +l+"\" TARGET=\"Frame2\">"+l+"</A>\n";
    risp+="</TD></TR></TABLE>\n";

    risp+="</FONT>\n";
    risp+=endbody();
}


void QueryDoc::stage1_process(stringone* strngn) {
    char* buff;

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_token(strngn,"preanno");
    if(buff!=NULL) preanno=buff; else preanno=null;

    buff=check_token(strngn,"postanno");
    if(buff!=NULL) postanno=buff; else postanno=null;

    buff=check_token(strngn,"prenumero");
    if(buff!=NULL) prenumero=buff; else prenumero=null;

    buff=check_token(strngn,"postnumero");
    if(buff!=NULL) postnumero=buff; else postnumero=null;

    buff=check_token(strngn,"predata");
    if(buff!=NULL) predata=buff; else predata=null;

    buff=check_token(strngn,"postdata");
    if(buff!=NULL) postdata=buff; else postdata=null;

    buff=check_keytoken(strngn, "cat");
    if(buff!=NULL) cat=buff; else return;

    buff=check_token(strngn, "Oggetto");
    if(buff!=NULL) Oggetto=buff; else Oggetto=null;

    // mostra la pagina HTML dello stage 2
    stage2_showpage();
}


void QueryDoc::stage2_process(stringone* strngn) {
    char* buff;

    risp=beginbody();
    risp+=big_title(titpagine);
    risp+=small_title("Pagina 3 di 3");
    risp+="<FONT FACE=\"Times\">\n";

    // aggiorna il contenuto delle variabili in base ai valori
    // contenuti nei token
    buff=check_token(strngn,"codiceca");
    if(buff!=NULL) codiceca=buff; else codiceca=null;
    
    buff=check_token(strngn, "Riparto");
    if(buff!=NULL) Riparto=buff; else Riparto=null;

    // decide il da farsi in base al contenuto del token "direz"
    buff=strngn->findtoken("direz");
    if(strcmp(buff,"indietro")==0) stage1_showpage(); else {
        // esegue la query nella base dati
        bool OK=1;
        SqlResult* R;
        int i,imax,j;
        try {
            if(cat=="carico")
                R=connection->queryCarico(preanno, postanno, prenumero, postnumero,
                    predata, postdata, Riparto, codiceca,
                    finder->select(Oggetto, 9999));
            else {
                R=connection->queryScarico(preanno, postanno, prenumero, postnumero,
                    predata, postdata, Riparto, codiceca,
                    finder->select(Oggetto, 9999));
            }
        }
        catch (SqlConnection::GenericError error) {
            OK=0;
            risp+=errore(error.toString(), "errore durante l'esecuzione della ricerca");
        }
        if(OK) {
            imax=R->rowNum();
            risp=risp+imax+" documenti trovati.<BR><BR>\n";
            risp+="<TABLE BORDER=1 CELLSPACING=0 WIDTH=100%>\n";
            risp+="<TR  ALIGN=\"center\" VALIGN=\"middle\">\n";
            risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
            risp+="        <STRONG>Anno</STRONG></FONT></TD>\n";
            risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
            risp+="        <STRONG>Numero</STRONG></FONT></TD>\n";
            risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
            risp+="        <STRONG>Data</STRONG></FONT></TD>\n";
            risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
            risp+="        <STRONG>Oggetto</STRONG></FONT></TD>\n";
            risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
            risp+="        <STRONG>Denominaz1</STRONG></FONT></TD>\n";
            risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
            risp+="        <STRONG>Denominaz2</STRONG></FONT></TD>\n";
            risp+="    <TD BGCOLOR=\"#000000\"><FONT FACE=\"helvetica\" COLOR=\"#FFFFFF\">\n";
            risp+="        <STRONG>Rip.</STRONG></FONT></TD>\n";
            risp+="    <TD></TD>\n</TR>\n";
            for(i=0;i<imax;++i) {
                risp+="<TR  ALIGN=\"center\" VALIGN=\"middle\">\n";
                for(j=0;j<7;++j) {
                    risp=risp+"<TD>";
                    if(R->get(i,j)!=NULL) risp+=R->get(i,j); else risp+="<EM>null</EM>";
                    risp+="</TD>\n";
                }
                risp=risp+"<TD><FORM ACTION=\""+BRIDGE_PATH+"\" METHOD=\"POST\" NAME=\"modulo\">\n";
                risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"userid\" VALUE="+userid+">\n";
                risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"op\" VALUE=10>\n";
                risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"type\" VALUE=4>\n";
                risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"annodoc\" VALUE="+R->get(i,0)+">\n";
                risp=risp+"    <INPUT TYPE=HIDDEN NAME=\"numdoc\" VALUE="+R->get(i,1)+">\n";
                risp=risp+"    <INPUT TYPE=SUBMIT VALUE=\"Mostra\">\n";
                risp=risp+"</FORM></TD>\n";
                risp+="</TR>\n";
            }
            risp=risp+"</TABLE>\n";
            risp=risp+"<BR><A HREF=\""+BRIDGE_PATH+"?userid="+userid+"&op=0\">";
            risp+="Torna al menu</A><BR>\n";
        }
        risp+="</FONT>\n";
        risp+=endbody();
    }  // fine del codice per la query
}


String& QueryDoc::process(stringone* strngn) {
    if(!initialized) {
        risp="<BODY>QueryDoc:la classe non  stata inizializzata.</BODY>\n";
        return risp;
    }
    risp="";

    // decide il da farsi in base al token "stage"
    char* buff=check_keytoken(strngn,"stage");
    if(buff==NULL) return risp;
    int i=atoi(buff);
    switch(i) {
        case 0:
            stage1_showpage();
        break;
        case 1:
            stage1_process(strngn);
        break;
        case 2:
            if(strngn->findtoken("frames")!=NULL) stage2_showframe1();
            else stage2_process(strngn);
        break;
        default:
            risp+="QueryDocDoc: contenuto del token 'stage' non valido.<BR>\n";
        break;
    }        

    return risp;
}


void QueryDoc::reset() {
    preanno=annocorr();
    postanno=annocorr();
    prenumero=1;
    postnumero=9999;
    predata=SqlDate("01/01/"+preanno);
    postdata=datacorr();
    Oggetto=null;
    cat="carico";
    Riparto=null,
    codiceca=null;
    Tipo_documento="lettera";
}
